/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <queue>
#include <cmath>

using namespace std;

const int oo = (int)1e10;
const int DEPTH = 4;

int dir[4][2] = {{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
direction number_to_enum[4] = {OUEST, NORD, EST, SUD};


struct Action_str
{
    direction dir;
    bool adjacent;
};

struct Target
{
    position pos;
    int cost;
    vector<Action_str> path;

    void erase()
    {
        pos = {0,0};
        cost = 0;
        path.clear();
    }

    int get_nbtours()
    {
        return (cost + 7) / 8;
    }

    bool operator<(const Target &B) const
    {
        return cost > B.cost;
    }
};


bool inside(position p)
{
    if(p.ligne >= 0 && p.ligne < 25 && p.colonne >= 0 && p.colonne < 25)
        return true;
    return false;
}


position slide(position pos, int d)
{
    position next = {pos.ligne + dir[d][1], pos.colonne + dir[d][0]};
    while(inside(next) && type_case(next) != MUR && agent_sur_case(next) == -1)
    {
        pos = next;
        next.ligne += dir[d][1];
        next.colonne += dir[d][0];
    }

    return pos;
}
// met des &&&&&&&&&&&&&&&&&
//
void follow_path(vector<Action_str> &path_to_alien, int iagent)
{
    for(Action_str move : path_to_alien)
        if(move.adjacent)
        {
            if(deplacer(iagent, move.dir) == PA_INSUFFISANTS)
                break;
        }
        else
            if(glisser(iagent, move.dir) == PA_INSUFFISANTS)
                break;
}

bool dead(alien_info alien)
{
    return (alien.tour_invasion <= tour_actuel() - NB_TOURS_CAPTURE
            && !alien_sur_case(alien.pos) );
}

bool capturable(Target cible)
{
    return !cible.path.empty() && info_alien(cible.pos).tour_invasion + info_alien(cible.pos).duree_invasion >= tour_actuel() + NB_TOURS_CAPTURE + cible.get_nbtours();
}

bool acceptable(alien_info alien)
{
    int accepted_wait = 5;
    //cout << "tour invasion " << info_alien(cible.pos).tour_invasion << endl;
    return alien.tour_invasion <= tour_actuel() + accepted_wait;
}

double value(Target target)
{
    return (double)info_alien(target.pos).points_capture / ((double)target.cost + 2);
}


Target chemin_slide(position A, position B)
{
    priority_queue<Target> file;
    Target start;
    start.pos = A;
    start.cost = 0;

    file.push(start);

    int minCost[25][25];

    for(int i = 0; i < 25; i++) for(int j = 0; j < 25; j++) minCost[i][j] = +oo;
    minCost[A.ligne][A.colonne] = 0;

    while(!file.empty() && file.top().pos != B && file.top().cost <= 8 * DEPTH)
    {
        Target cur = file.top();
        file.pop();

        for(int idir = 0; idir < 4; idir++)
        {
            position seek = {cur.pos.ligne + dir[idir][1], cur.pos.colonne + dir[idir][0]};

            if(inside(seek) && type_case(seek) != MUR && agent_sur_case(seek) == -1)
                if(minCost[seek.ligne][seek.colonne] > cur.cost + 1)
                {
                    vector<Action_str> temp = cur.path;
                    temp.push_back({number_to_enum[idir], true});
                    file.push({seek, cur.cost + 1, temp});
                    minCost[seek.ligne][seek.colonne] = cur.cost + 1;
                }

            seek = slide(cur.pos, idir);

            if(minCost[seek.ligne][seek.colonne] > cur.cost + 3)
            {
                vector<Action_str> temp = cur.path;
                temp.push_back({number_to_enum[idir], false});
                file.push({seek, cur.cost + 3, temp});
                minCost[seek.ligne][seek.colonne] = cur.cost + 3;
            }
        }
    }
    Target return_target;

    if(!file.empty() && file.top().pos == B)
    {
        //cout << "je suis a " << file.top().pos.ligne << " " << file.top().pos.colonne << endl;

        return_target = file.top();
    }

    return return_target;
}

bool free_case(position pos)
{
    return type_case(pos) == LIBRE &&  agent_sur_case(pos) == -1;
}

bool should_move_ennemy(alien_info alien, int idir)
{
    return free_case({alien.pos.ligne + dir[(idir + 2) % 4][1], 
                      alien.pos.colonne + dir[(idir + 2) % 4][0]});
}

bool move_adj_ennemy(int agent)
{
    for(int idir = 0; idir < 4; idir++)
    {
        if(agent_sur_case({position_agent(moi(), agent).ligne + dir[idir][1], 
                           position_agent(moi(), agent).colonne + dir[idir][0]}) == adversaire())
        {
            pousser(agent, number_to_enum[idir]);
            deplacer(agent, number_to_enum[idir]);
            return true;
        }
    }

    return false;

}

Target ennemy(int iagent, alien_info alien)
{
    Target best_adj;

    for(int idir = 0; idir < 4; idir++)
    {
        if(should_move_ennemy(alien, idir))
        {
            Target temp = chemin_slide(position_agent(moi(), iagent), {alien.pos.ligne + dir[idir][1], alien.pos.colonne + dir[idir][0]});

            Target adj = {alien.pos, temp.cost, temp.path};

            if(value(adj) > value(best_adj))
                best_adj = adj;
        }
    }

    return best_adj;
}

void move_agent(int iagent)
{
    Target best_target;
    bool found_best = false;

    if (!move_adj_ennemy(iagent))
        for(alien_info alien : liste_aliens())
        {
            if(dead(alien) || !acceptable(alien))
                continue;

            Target target;
            if(agent_sur_case(alien.pos) == adversaire())
            {
                target = ennemy(iagent, alien);
            }
            else
            {
                target = chemin_slide(position_agent(moi(), iagent), alien.pos);
                if(!capturable(target))
                    target.erase();
            }

            if(!target.path.empty() && value(target) > value(best_target))
            {
                found_best = true;
                best_target = target;
            }
        }

    if(found_best)
    {
        follow_path(best_target.path, iagent);
    }

    move_adj_ennemy(iagent);
}

/// Fonction appelée au début de la partie.
void partie_init()
{
    cout << "ready?" << endl;
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    cout << "TOUR " << tour_actuel() << endl;

    for(int iagent = 0; iagent < 4; iagent++)
    {
        cout << "agent " << iagent << endl;
        if(!alien_sur_case(position_agent(moi(), iagent)))
        {
            move_agent(iagent);
        }
        else
        {
            move_adj_ennemy(iagent);
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    cout << "gg" << endl;  // fonction a completer
}

