/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <vector>
#include <algorithm>
#include <stack>
#include <queue>
#include <cmath>

#define all(a) a.begin(), a.end()


//Types
template <typename T>
using Array = std::vector<T>;

struct Alien
{
    Alien(alien_info a) : pos(a.pos), fin(a.tour_invasion + a.duree_invasion), score(a.points_capture) {}
    position pos; int fin, score;
    int taken = -1;

    bool operator <(const Alien &other) const
    {
        if (score == other.score)
            return (fin < other.fin);
        return (score < other.score);
    }
};

struct Attaque
{
    int tour, alien;
};

struct Deplacement
{
    Deplacement(action_type a, direction d) : action(a), dir(d) {}
    Deplacement(position delta)
    {
        if (abs(delta.ligne + delta.colonne) == 1)
            action = ACTION_DEPLACER;
        else
            action = ACTION_GLISSER;

        if (delta.ligne < 0)
            dir = NORD;
        else if (delta.ligne > 0)
            dir = SUD;
        else if (delta.colonne < 0)
            dir = OUEST;
        else
            dir = EST;
    }

    action_type action; direction dir;

    bool operator ==(const Deplacement &other) const
    {
        return (action == other.action && dir == other.dir);
    }
};

struct PetitDejeunekstra
{
    PetitDejeunekstra(position pr, position p, int e) :
        provenance(pr), pos(p), energieUtilisee(e) {}

    position provenance, pos;
    int energieUtilisee;

    bool operator <(const PetitDejeunekstra &other) const
    {
        return (other.energieUtilisee < energieUtilisee);
    }
};


//Variables
Array<Alien> timeline[NB_TOURS];
Attaque strategie[NB_AGENTS];

position dejaVu[TAILLE_BANQUISE][TAILLE_BANQUISE];
const int deltaLig[4] = { -1, 0, 1, 0 };
const int deltaCol[4] = { 0, 1, 0, -1 };
const direction deltaDir[4] = { NORD, EST, SUD, OUEST };

const position NOPE = { -1, -1 };
const position FIN = { TAILLE_BANQUISE, TAILLE_BANQUISE };
const Deplacement NORAJ = { ACTION_POUSSER, NORD };


//Operateurs
position operator -(const position &a, const position &b)
{
    return { a.ligne - b.ligne, a.colonne - b.colonne };
}

//Fonctions
int posinfo(position pos)
{
    if (type_case(pos) == MUR || type_case(pos) == ERREUR)
        return -1;
    if (agent_sur_case(pos) != -1)
        return agent_sur_case(pos);
    return 0;
}

bool inutilisable(int iTour, int iAlien, int iAgent)
{
    if (iAlien >= (int)timeline[iTour].size())
        return true;
    if (tour_actuel() >= timeline[iTour][iAlien].fin)
        return true;
    if (info_alien(timeline[iTour][iAlien].pos).capture_en_cours == NB_TOURS_CAPTURE)
        return true;
    return (timeline[iTour][iAlien].taken != -1 && timeline[iTour][iAgent].taken != iAgent);
}

bool prochaineAttaque(int iAgent)
{
    bool change = false;
    while (strategie[iAgent].tour < NB_TOURS && inutilisable(strategie[iAgent].tour, strategie[iAgent].alien, iAgent))
    {
        strategie[iAgent].alien++;
        change = true;

        if (strategie[iAgent].alien >= (int)timeline[strategie[iAgent].tour].size())
        {
            strategie[iAgent].tour++;
            strategie[iAgent].alien = 0;
        }
    }

    if (strategie[iAgent].tour < NB_TOURS)
        timeline[strategie[iAgent].tour][strategie[iAgent].alien].taken = iAgent;
    return change;
}

int actionenenergie(action_type action)
{
    if (action == ACTION_DEPLACER)
        return 1;
    if (action == ACTION_GLISSER)
        return 3;
    return 5;
}

int distpoussee(int iAgent, direction dir)
{
    position pos = position_agent(moi(), iAgent);
    pos.ligne += deltaLig[dir];
    pos.colonne += deltaCol[dir];

    if (posinfo(pos) == -1)
        return 0;
    if (posinfo(pos) == moi())
        return -1;
    pos.ligne += deltaLig[dir];
    pos.colonne += deltaCol[dir];

    int distance = 0;
    while (posinfo(pos) == 0)
    {
        pos.ligne += deltaLig[dir];
        pos.colonne += deltaCol[dir];
        distance++;
    }

    return distance;
}

//Dijkstra
Array<Deplacement> dijkstra(position depart, position arrivee)
{
    for (int ligne = 0; ligne < TAILLE_BANQUISE; ligne++)
        std::fill_n(dejaVu[ligne], TAILLE_BANQUISE, NOPE);
    std::priority_queue<PetitDejeunekstra> suivant;
    suivant.emplace(FIN, depart, 0);

    while (!suivant.empty())
    {
        PetitDejeunekstra cur = suivant.top();
        suivant.pop();

        if (dejaVu[cur.pos.ligne][cur.pos.colonne] != NOPE)
           continue;
        dejaVu[cur.pos.ligne][cur.pos.colonne] = cur.provenance;

        if (cur.pos == arrivee)
            break;
        for (int iDir = 0; iDir < 4; iDir++)
        {
            position depl = cur.pos;
            depl.ligne += deltaLig[iDir];
            depl.colonne += deltaCol[iDir];

            if (posinfo(depl) == -1 || posinfo(depl) == adversaire())
                continue;
            if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                suivant.emplace(cur.pos, depl, cur.energieUtilisee + 1);

            while (posinfo(depl) == 0)
            {
                depl.ligne += deltaLig[iDir];
                depl.colonne += deltaCol[iDir];
            }

            depl.ligne -= deltaLig[iDir];
            depl.colonne -= deltaCol[iDir];
            if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                suivant.emplace(cur.pos, depl, cur.energieUtilisee + 3);
        }
    }

    if (dejaVu[arrivee.ligne][arrivee.colonne] == NOPE)
        return {};

    std::stack<Deplacement> cheminPris;
    while (arrivee != depart)
    {
        cheminPris.emplace(arrivee - dejaVu[arrivee.ligne][arrivee.colonne]);
        arrivee = dejaVu[arrivee.ligne][arrivee.colonne];
    }

    Array<Deplacement> tour;
    int energieNecessaire = 0;

    while (!cheminPris.empty() && energieNecessaire + actionenenergie(cheminPris.top().action) <= 8)
    {
        tour.emplace_back(cheminPris.top());
        energieNecessaire += actionenenergie(cheminPris.top().action);
        cheminPris.pop();
    }

    tour.emplace_back(NORAJ);
    return tour;
}

/// Fonction appelée au début de la partie.
void partie_init()
{
    // fonction a completer
    Array<alien_info> aliens = liste_aliens();
    for (const alien_info &alien : aliens)
        timeline[alien.tour_invasion].emplace_back(alien);

    for (int iTour = 0; iTour < NB_TOURS; iTour++)
        std::sort(all(timeline[iTour]));

    strategie[0] = { 0, 0 };
    prochaineAttaque(0);

    strategie[1] = { strategie[0].tour, 1 };
    prochaineAttaque(1);

    strategie[2] = { strategie[1].tour + 10, 0 };
    prochaineAttaque(2);

    strategie[3] = { strategie[2].tour, 1 };
    prochaineAttaque(3);
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    // fonction a completer
    bool change[NB_AGENTS];
    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
        change[iAgent] = prochaineAttaque(iAgent);

    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
    {
        if (strategie[iAgent].tour >= NB_TOURS)
            continue;
        position depart = position_agent(moi(), iAgent);
        position arrivee = timeline[strategie[iAgent].tour][strategie[iAgent].alien].pos;
        Array<Deplacement> cheminTour = dijkstra(depart, arrivee);

        if (cheminTour.empty())
        {
            if (pousser(iAgent, Deplacement(arrivee - depart).dir) == RIEN_A_POUSSER)
            {
                glisser(iAgent, Deplacement(arrivee - depart).dir);
                pousser(iAgent, Deplacement(arrivee - depart).dir);
            }
            else
                deplacer(iAgent, Deplacement(arrivee - depart).dir);
        }
        else if (cheminTour[0] == NORAJ)
        {
            int poussee[4];
            for (int iDir = 0; iDir < 4; iDir++)
                poussee[iDir] = distpoussee(iAgent, deltaDir[iDir]);

            int meilleure = 0;
            for (int iDir = 1; iDir < 4; iDir++)
                if (poussee[iDir] > poussee[meilleure])
                    meilleure = iDir;

            if (poussee[meilleure] != -1)
                pousser(iAgent, deltaDir[meilleure]);
        }
        else
        {
            for (const Deplacement &depl : cheminTour)
            {
                if (depl.action == ACTION_DEPLACER)
                    deplacer(iAgent, depl.dir);
                else if (depl.action == ACTION_GLISSER)
                    glisser(iAgent, depl.dir);
            }
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    // fonction a completer
    ;
}

