/**
 *  Fonctionnement : A chaque tour, pour chaque manchot, je calcule un score pour chaque case et j'envoie le manchot la ou 
 *  le score est le plus grand, divise par la fatigue necessaire pour y acceder
 * 
 *  Algorithmes : dijkstra, heuristique
 * 
 *  Strategies : J'ai essaye de calculer un score en fonction des points de capture des aliens, de la distance en fatigue, 
 *  et de quelques cas particuliers
 *  Au final, j'essaye d'avoir des manchots qui font un peu de tout (capturer, pousser, aider les amis)
 * 
 *  Autres Idees : J'ai essaye d'attribuer un alien a chaque manchot. Ca marchait au debut mais pas trop a la fin
 * 
 *  J'ai perdu beaucoup de temps a debuguer le dijkstra, j'ai code cet heuristique que depuis ce soir
 *  J'aurais aime y reflechir plus longtemps
 * 
 *  Et il y a des times outs car j'appelle les aliens a chaque tour
 **/
#include "prologin.hh"
#include <vector>
#include <queue>
#include <list>
using namespace std;

struct Direction
{
	direction dir;
	int lig, col;
};
struct Mouvement
{
	action_type type;
	int dir;
};
struct Situation
{
	position pos;
	int fatigue;
	Mouvement mouv;
	position prec;
	bool operator< (const Situation &autre) const
	{
		return fatigue > autre.fatigue;
	}
};
const int IMPOSSIBLE = 2000000000;
const int AUCUN = -1;

bool memePos(position a, position b)
{
	return a.ligne == b.ligne && a.colonne == b.colonne;
}
int getDirContr(int iDir)
{
	if(iDir == 0)
		return 2;
	if(iDir == 1)
		return 3;
	if(iDir == 2)
		return 0;
	if(iDir == 3)
		return 1;
	return -1;
}

Direction dirs[4];
Situation plan[4][25][25];
double scoreCase[25][25];
bool visited[4][25][25];
double moyPoints = 0;

// Calcul du dijkstra
void dijstra(int agent)
{
	priority_queue<Situation> visite;
	
	Situation depart;
	depart.pos = position_agent(moi(), agent);
	depart.fatigue = 0;
	visite.push(depart);
	
	for(int lig = 0; lig < 25; lig ++)
		for(int col = 0; col < 25; col ++)
			visited[agent][lig][col] = false;
	
	while(!visite.empty())
	{
		Situation actuel = visite.top();
		visite.pop();
		if(visited[agent][actuel.pos.ligne][actuel.pos.colonne])
			continue;
		visited[agent][actuel.pos.ligne][actuel.pos.colonne] = true;
		plan[agent][actuel.pos.ligne][actuel.pos.colonne] = actuel; // Stocke les situations
			
		for(int iDir = 0; iDir < 4; iDir ++)
		{
			Direction dir = dirs[iDir];
			{ // Deplacement normal
				position nouvPos = {actuel.pos.ligne + dir.lig, actuel.pos.colonne + dir.col};
				if(agent_sur_case(nouvPos) != -1 || type_case(nouvPos) != LIBRE || visited[agent][nouvPos.ligne][nouvPos.colonne])
					continue;
				
				Situation nouv;
				nouv.pos = nouvPos;
				nouv.fatigue = actuel.fatigue+1;
				nouv.prec = actuel.pos;
				nouv.mouv = {ACTION_DEPLACER, iDir};
				visite.push(nouv);
			}
			
			{ // Deplacement en glissant
				position nouvPos = {actuel.pos.ligne + dir.lig, actuel.pos.colonne + dir.col};
				while(agent_sur_case(nouvPos) == -1 && type_case(nouvPos) == LIBRE)
				{
					nouvPos.ligne += dir.lig;
					nouvPos.colonne += dir.col;
				}
				nouvPos.ligne -= dir.lig;
				nouvPos.colonne -= dir.col;
				
				if(visited[agent][nouvPos.ligne][nouvPos.colonne])
					continue;
				
				Situation nouv;
				nouv.pos = nouvPos;
				nouv.fatigue = actuel.fatigue+3;
				nouv.mouv = {ACTION_GLISSER, iDir};
				nouv.prec = actuel.pos;
				visite.push(nouv);
			}
		}
	}
}

/// Fonction appelée au début de la partie.
void partie_init()
{
	dirs[0].dir = NORD; dirs[0].lig = -1; dirs[0].col = 0;
	dirs[1].dir = EST; dirs[1].lig = 0; dirs[1].col = 1;
	dirs[2].dir = SUD; dirs[2].lig = 1; dirs[2].col = 0;
	dirs[3].dir = OUEST; dirs[3].lig = 0; dirs[3].col = -1;
	for(alien_info alien : liste_aliens())
		moyPoints += alien.points_capture;
	moyPoints /= (double)liste_aliens().size();
	printf("=== Initialisation termine ===\n");
}

// Essaye de pousser tous les ennemis, ceux sur un alien en priorite
void pousserEnnemis(int agent)
{
	position pos = position_agent(moi(), agent);
	for(int iDir = 0; iDir < 4; iDir ++)
	{
		Direction dir = dirs[iDir];
		int ligAdj = pos.ligne + dir.lig;
		int colAdj = pos.colonne + dir.col;
		for(int ennemi = 0; ennemi < 4; ennemi ++)
		{
			position posEnnemi = position_agent(adversaire(), ennemi);
			if(memePos(posEnnemi, {ligAdj, colAdj}) && alien_sur_case(posEnnemi))
				pousser(agent, dir.dir);
		}
	}
	for(int iDir = 0; iDir < 4; iDir ++)
	{
		Direction dir = dirs[iDir];
		int ligAdj = pos.ligne + dir.lig;
		int colAdj = pos.colonne + dir.col;
		bool correct = true;
		for(int ami = 0; ami < 4; ami ++)
		{
			position posAmi = position_agent(moi(), ami);
			if(posAmi.ligne == ligAdj && posAmi.colonne == colAdj)
				correct = false;
		}
		if(!correct)
			continue;
		pousser(agent, dir.dir);
	}
}

/* Retourne la fatigue necessaire pour un agent pour aller a une position
 * et si besoin on y va ensuite */
int getFatigue(int agent, position pos, bool yAller = false)
{
	if(!visited[agent][pos.ligne][pos.colonne])
		return IMPOSSIBLE;
	
	position depart = position_agent(moi(), agent);
	list<Mouvement> mouvs;
	int fatigue = plan[agent][pos.ligne][pos.colonne].fatigue;
	
	while(!memePos(depart, pos))
	{
		mouvs.push_front(plan[agent][pos.ligne][pos.colonne].mouv);
		pos = plan[agent][pos.ligne][pos.colonne].prec;
	}
	
	if(yAller)
	{
		for(Mouvement mouv : mouvs)
		{
			if(mouv.type == ACTION_DEPLACER)
				deplacer(agent, dirs[mouv.dir].dir);
			else
				glisser(agent, dirs[mouv.dir].dir);
		}
	}
	return fatigue;
}
void aller(int agent, position posArrive)
{
	getFatigue(agent, posArrive, true);
}

// verif si un alien est correct (si on peut encore le capturer)
bool verifAlien(alien_info alien)
{
	position pos = alien.pos;
	/*if(alien.points_capture <= 0)
	{
		printf("[%d] Alien %d %d rapporte rien\n", tour_actuel(), pos.ligne, pos.colonne);
		return false;
	}*/
	if(tour_actuel()+2-alien.capture_en_cours >= alien.tour_invasion + alien.duree_invasion)
	{
		//printf("[%d] Alien %d %d trop tard\n", tour_actuel(), pos.ligne, pos.colonne);
		return false;
	}
	if(alien.tour_invasion <= tour_actuel() && !alien_sur_case(pos))
	{
		//printf("[%d] Alien %d %d parti\n", tour_actuel(), pos.ligne, pos.colonne);
		return false;
	}
	return true;
}

// Calcul du score, en fonction de l'agent
void calculerScore(int agent)
{
	position pos = position_agent(moi(), agent);
	for(int lig = 0; lig < 25; lig ++)
		for(int col = 0; col < 25; col ++)
			scoreCase[lig][col] = 0;
			
	for(alien_info alien : liste_aliens())
	{
		if(!verifAlien(alien)) // alien pas correct
			continue;
		if(alien.points_capture <= 0) // alien negatif qui sert a rien
			scoreCase[alien.pos.ligne][alien.pos.colonne] = -1000;
		
		bool deja = false;
		for(int l = alien.pos.ligne-1; l <= alien.pos.ligne+1; l ++)
		{
			for(int c = alien.pos.colonne-1; c <= alien.pos.colonne+1; c ++)
			{
				if(memePos(pos, {l, c}))
					continue;
				if(agent_sur_case({l, c}) == moi())
					deja = true;
			}	
		}
		if(deja) // deja occupe par un ami
			continue;
		
		if(agent_sur_case(alien.pos) == moi()) // deja pris
			continue;
		else if(agent_sur_case(alien.pos) == adversaire()) // un adversaire est dessus
		{
			for(int iDir = 0; iDir < 4; iDir ++)
			{
				position nouv = alien.pos;
				position contr = alien.pos;
				nouv.ligne += dirs[iDir].lig;
				nouv.colonne += dirs[iDir].col;
				contr.ligne += dirs[getDirContr(iDir)].lig;
				contr.colonne += dirs[getDirContr(iDir)].col;
				if(agent_sur_case(contr) == -1 && type_case(contr) == LIBRE)
				{
					scoreCase[nouv.ligne][nouv.colonne] += alien.points_capture; // on donne des points si on peut le pousser
				}
			}
		}
		else
		{
			scoreCase[alien.pos.ligne][alien.pos.colonne] += alien.points_capture * 1.2; // on donne des points si on peut acceder a l'alien
			
			int nb = 0;
			for(int iDir = 0; iDir <= 1; iDir ++)
			{
				position nouv = alien.pos;
				position contr = alien.pos;
				nouv.ligne += dirs[iDir].lig;
				nouv.colonne += dirs[iDir].col;
				contr.ligne += dirs[getDirContr(iDir)].lig;
				contr.colonne += dirs[getDirContr(iDir)].col;
				if(type_case(nouv) != LIBRE || type_case(contr) != LIBRE)
					nb ++;
			}
			if(nb == 2)
				scoreCase[alien.pos.ligne][alien.pos.colonne] *= 2; // c'est un coin *= 3
			if(alien.tour_invasion > tour_actuel())
				scoreCase[alien.pos.ligne][alien.pos.colonne] *= 1.0/(alien.tour_invasion - tour_actuel()); // on diminue si l'alien apparait plus tard
		}
	}
	
	for(int iDir = 0; iDir < 4; iDir ++)
	{
		position posAlien = pos;
		posAlien.ligne += dirs[iDir].lig;
		posAlien.colonne += dirs[iDir].col;
		if(agent_sur_case(posAlien) == moi() && alien_sur_case(posAlien))
		{
			position adj1 = posAlien;
			position adj2 = posAlien;
			int dirContr = (iDir+1)%4;
			adj1.ligne += dirs[dirContr].lig;
			adj1.colonne += dirs[dirContr].col;
			adj2.ligne += dirs[getDirContr(dirContr)].lig;
			adj2.colonne += dirs[getDirContr(dirContr)].col;
			if(type_case(adj1) != LIBRE || type_case(adj2) != LIBRE)
			{
				scoreCase[pos.ligne][pos.colonne] += 200; // L'ami sert a boucher
			}
		}
	}
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	for(int agent = 0; agent < 4; agent ++)
	{
		dijstra(agent);
		calculerScore(agent);
		position pos = position_agent(moi(), agent);
		
		pousserEnnemis(agent);
		if(alien_sur_case(pos) && info_alien(pos).points_capture > 0) // il est deja sur un alien
		{
			continue;
		}
		
		double scoreMax = -IMPOSSIBLE;
		position bestPos;
		
		for(int lig = 0; lig < 25; lig ++)
		{
			for(int col = 0; col < 25; col ++)
			{
				int fatigue = getFatigue(agent, {lig, col});
				if(fatigue == IMPOSSIBLE)
					continue;
				double score = scoreCase[lig][col] / fatigue;// on divise par la fatigue necessaire
				if(score > scoreMax)
				{
					scoreMax = score; // on prend le max
					bestPos = {lig, col};
				}
			}
		}
		
		if(scoreMax > -IMPOSSIBLE)
		{
			debug_afficher_drapeau(bestPos, DRAPEAU_BLEU);
			aller(agent, bestPos); // l'agent va vers la meilleur case
			pousserEnnemis(agent); 
		}
	}
}

void partie_fin()
{
}
