/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

/*
 * Premiere version : On se deplace vers le prochain alien dans l'ordre du temps.
 * Si l'alien est prit ou a disparu, on passe au suivant.
 */

#include "prologin.hh"
#include <iostream>
#include <vector>
#include <algorithm>

#define all(a) a.begin(), a.end()


//Declaration de fonctions
int finInvasion(alien_info alien);


//Types
template <typename T>
using Array = std::vector<T>;

Array<alien_info> aliens;
int iAlienActuel;

Array<direction> plusCourtChemin[NB_AGENTS];
int posSurChemin[NB_AGENTS];
int alienCible[NB_AGENTS];

// Fonctions utilitaires
int finInvasion(alien_info alien)
{
    return (alien.tour_invasion + alien.duree_invasion);
}

bool cmptemps(alien_info a, alien_info b) //Compare deux aliens selon leur intervalle de presence
{
    if (a.tour_invasion == b.tour_invasion)
    {
        if (finInvasion(a) == finInvasion(b))
            return (a.points_capture < b.points_capture);
        return (finInvasion(a) < finInvasion(b));
    }

    return (a.tour_invasion < b.tour_invasion);
}

/// Fonction appelée au début de la partie.
void partie_init()
{
    // fonction a completer
    aliens = liste_aliens();
    std::sort(all(aliens), cmptemps);

    iAlienActuel = 0;
    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
    {
        if (iAlienActuel == (int)aliens.size())
            alienCible[iAgent] = -1;
        else
        {
            plusCourtChemin[iAgent] = chemin(position_agent(moi(), iAgent), aliens[iAlienActuel].pos);
            posSurChemin[iAgent] = 0;
            alienCible[iAgent] = iAlienActuel++;
        }
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    // fonction a completer
    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
    {
        if (alienCible[iAgent] == -1 ||
            (finInvasion(aliens[alienCible[iAgent]]) < tour_actuel() &&
             aliens[alienCible[iAgent]].capture_en_cours != NB_TOURS_CAPTURE))
            continue;

        if (iAlienActuel == (int)aliens.size())
            alienCible[iAgent] = -1;
        else
        {
            plusCourtChemin[iAgent] = chemin(position_agent(moi(), iAgent), aliens[iAlienActuel].pos);
            posSurChemin[iAgent] = 0;
            alienCible[iAgent] = iAlienActuel++;
        }
    }

    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
    {
deplacement:
        if (alienCible[iAgent] == -1)
            continue;
        if (posSurChemin[iAgent] == (int)plusCourtChemin[iAgent].size() &&
            agent_sur_case(aliens[alienCible[iAgent]].pos) != moi())
        {
            plusCourtChemin[iAgent] = chemin(position_agent(moi(), iAgent), aliens[alienCible[iAgent]].pos);
            posSurChemin[iAgent] = 0;
        }

        int prochainePosition = std::min(posSurChemin[iAgent] + points_action_agent(iAgent),
                                (int)plusCourtChemin[iAgent].size() - 1);

        for (; posSurChemin[iAgent] < prochainePosition; posSurChemin[iAgent]++)
            deplacer(iAgent, plusCourtChemin[iAgent][posSurChemin[iAgent]]);
        if (posSurChemin[iAgent] == (int)plusCourtChemin[iAgent].size() - 1)
        {
            if (agent_sur_case(aliens[alienCible[iAgent]].pos) == -1)
                if (deplacer(iAgent, plusCourtChemin[iAgent].back()) != PA_INSUFFISANTS)
                {
                    posSurChemin[iAgent]++;
                    continue;
                }

            direction &dernierDeplacement = plusCourtChemin[iAgent].back();
            position fin = position_agent(moi(), iAgent);

            if (dernierDeplacement == NORD)
                fin.ligne -= 2;
            else if (dernierDeplacement == EST)
                fin.colonne += 2;
            else if (dernierDeplacement == SUD)
                fin.ligne += 2;
            else
                fin.colonne -= 2;

            if (type_case(fin) == MUR || agent_sur_case(fin) != -1)
            {
                fin = position_agent(moi(), iAgent);
                position fin2 = fin;

                if (dernierDeplacement == NORD)
                   fin.ligne -= 1;
                else
                    fin.ligne += 1;
                if (dernierDeplacement == OUEST)
                    fin.colonne -= 1;
                else
                    fin.colonne += 1;

                if (dernierDeplacement == SUD)
                    fin2.ligne += 1;
                else
                    fin2.ligne -= 1;
                if (dernierDeplacement == EST)
                    fin2.colonne += 1;
                else
                    fin2.colonne -= 1;

                if (type_case(fin) == MUR || agent_sur_case(fin) != -1 || agent_sur_case(fin2) != -1)
                    continue;
            }
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    // fonction a completer
    ;
}
