/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

/* Tactique adoptee :
 * Je vais chercher l'alien le plus "rentable". Pour chaque alien sur la
 * banquise, je calcule la quantite d'energie minimale d'energie necessaire
 * pour y aller. Ensuite, je calcule le nombre de tours necessaires pour y
 * aller a partir de cette quantite d'energie. Enfin, je recupere comme element
 * de comparaison le score de l'alien divise par sa distance en tours. Je garde
 * le ratio maximum, et je commence a me diriger vers l'alien auquel il
 * correspond en prenant le debut du chemin le plus court.
 * Je fais aussi attention a ne pas rester sur une case avec un score negatif,
 * grace a quelques conditions.
 *
 * Pour calculer le plus court chemin, j'utilise l'algorithme de dijkstra. Mes
 * transitions sont les action de l'agent, et le poids est le cout en points
 * d'action de l'action. Je garde pour chaque noeud le noeud dont on arrive.
 * Pour retrouver le chemin, j'utilise une pile. J'empile les deplacements qu'on
 * retrouve en remontant depuis la fin vers le debut. Ensuite, il ne me reste
 * plus qu'a prendre les premiers deplacements de la liste tels que la somme de
 * leurs couts en PA soit inferieure ou egale a 8.
 * Dans me fonction jouer_tour, je lance l'algorithme de dijkstra et j'effectue
 * les deplacements renvoyes.
 *
 * Ma premiere idee etait de devancer l'adversaire, en partant sur les
 * positions des aliens qui allaient apparaitre plus tard. Cependant, cette
 * technique etait trop dure a utiliser assez bien pour avoir un resultat
 * concluant. Je suis donc passe a ma strategie actuelle.
 *
 * Je ne visais pas forcement quelque chose de plus complique que ce que j'ai
 * fait, et je n'ai de toute facon plus d'idees... X)
 */

#include "prologin.hh"
#include <iostream>
#include <vector>
#include <algorithm>
#include <stack>
#include <queue>
#include <cmath>

#define all(a) a.begin(), a.end()
#define SIX 1 + 5
#define NEUF 8 + 1

//Types
template <typename T>
using Array = std::vector<T>;

struct Deplacement
{
    Deplacement(action_type a, direction d) : action(a), dir(d) {}
    Deplacement(position delta)
    {
        if (abs(delta.ligne + delta.colonne) == 1)
            action = ACTION_DEPLACER;
        else
            action = ACTION_GLISSER;

        if (delta.ligne < 0)
            dir = NORD;
        else if (delta.ligne > 0)
            dir = SUD;
        else if (delta.colonne < 0)
            dir = OUEST;
        else
            dir = EST;
    }

    action_type action; direction dir;

    bool operator ==(const Deplacement &other) const
    {
        return (action == other.action && dir == other.dir);
    }
};

struct PetitDejeunekstra
{
    PetitDejeunekstra(position pr, position p, bool po, int e) :
        provenance(pr), pos(p), pousse(po), energieUtilisee(e) {}

    position provenance, pos;
    bool pousse;
    int energieUtilisee;

    bool operator <(const PetitDejeunekstra &other) const
    {
        return (other.energieUtilisee < energieUtilisee);
    }
};

struct Alien
{
    Alien(alien_info a, int e)
        : pos(a.pos), score(a.points_capture), toursNecessaires(e / NB_POINTS_ACTION + 1) {}
    Alien(position p) : pos(p), score(0), toursNecessaires(1) {}

    position pos; int score, toursNecessaires;

    bool operator >=(const Alien &other) const
    {
        return (score / toursNecessaires >= other.score / other.toursNecessaires);
    }
};


//Variables
position dejaVu[TAILLE_BANQUISE][TAILLE_BANQUISE];
bool halte[TAILLE_BANQUISE][TAILLE_BANQUISE];
const int deltaLig[4] = { -1, 0, 1, 0 };
const int deltaCol[4] = { 0, 1, 0, -1 };
const direction deltaDir[4] = { NORD, EST, SUD, OUEST };

const position NOPE = { -1, -1 };
const position FIN = { TAILLE_BANQUISE, TAILLE_BANQUISE };

//Operateurs
position operator -(const position &a, const position &b)
{
    return { a.ligne - b.ligne, a.colonne - b.colonne };
}

//Fonctions
int posinfo(position pos)
{
    if (type_case(pos) == MUR || type_case(pos) == ERREUR)
        return -1;
    if (agent_sur_case(pos) != -1)
        return agent_sur_case(pos);
    return 0;
}

int actionenenergie(action_type action)
{
    if (action == ACTION_DEPLACER)
        return 1;
    if (action == ACTION_GLISSER)
        return 3;
    return 5;
}

void appliquerdelta(position &pos, int iDir)
{
    pos.ligne += deltaLig[iDir];
    pos.colonne += deltaCol[iDir];
}

int augmenterenergie(int energieInitiale, int modif)
{
    int limite = NB_POINTS_ACTION - modif;
    if (energieInitiale % NB_POINTS_ACTION > limite)
        return ((energieInitiale / 8 + 1) * 8 + modif);
    return (energieInitiale + modif);
}

//Dijkstra
Array<Deplacement> dijkstra(position depart)
{
    for (int ligne = 0; ligne < TAILLE_BANQUISE; ligne++)
        std::fill_n(dejaVu[ligne], TAILLE_BANQUISE, NOPE);
    std::priority_queue<PetitDejeunekstra> suivant;
    suivant.emplace(FIN, depart, false, 0);

    Alien meilleur(depart);
    if (alien_sur_case(depart))
        meilleur = Alien(info_alien(depart), 0);

    while (!suivant.empty())
    {
        PetitDejeunekstra cur = suivant.top();
        suivant.pop();

        if (dejaVu[cur.pos.ligne][cur.pos.colonne] != NOPE)
           continue;
        dejaVu[cur.pos.ligne][cur.pos.colonne] = cur.provenance;
        halte[cur.pos.ligne][cur.pos.colonne] = cur.pousse;

        if (alien_sur_case(cur.pos))
        {
            Alien ici(info_alien(cur.pos), cur.energieUtilisee);
            if (ici >= meilleur)
                meilleur = ici;
        }
        else if (meilleur.score < 0)
            meilleur = Alien(cur.pos);

        for (int iDir = 0; iDir < 4; iDir++)
        {
            position depl = cur.pos;
            appliquerdelta(depl, iDir);

            if (posinfo(depl) == -1 || posinfo(depl) == moi())
                continue;
            if (posinfo(depl) != 0)
            {
                appliquerdelta(depl, iDir);
                if (posinfo(depl) != 0)
                    continue;

                appliquerdelta(depl, iDir ^ 2);
                if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                    suivant.emplace(cur.pos, depl, true,
                                    augmenterenergie(augmenterenergie(cur.energieUtilisee, 5), 1));

                while (posinfo(depl) == 0)
                    appliquerdelta(depl, iDir);

                appliquerdelta(depl, iDir ^ 2);
                appliquerdelta(depl, iDir ^ 2);

                if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                    suivant.emplace(cur.pos, depl, true,
                                    augmenterenergie(augmenterenergie(cur.energieUtilisee, 5), 3));
                continue;
            }

            if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                suivant.emplace(cur.pos, depl, false, augmenterenergie(cur.energieUtilisee, 1));
            while (posinfo(depl) == 0)
                appliquerdelta(depl, iDir);

            appliquerdelta(depl, iDir ^ 2);
            if (dejaVu[depl.ligne][depl.colonne] == NOPE)
                suivant.emplace(cur.pos, depl, false, augmenterenergie(cur.energieUtilisee, 3));
        }
    }

    position arrivee = meilleur.pos;
    std::stack<Deplacement> cheminPris;

    while (arrivee != depart)
    {
        cheminPris.emplace(arrivee - dejaVu[arrivee.ligne][arrivee.colonne]);
        if (halte[arrivee.ligne][arrivee.colonne])
            cheminPris.emplace(ACTION_POUSSER, cheminPris.top().dir);
        arrivee = dejaVu[arrivee.ligne][arrivee.colonne];
    }

    Array<Deplacement> tour;
    int energieNecessaire = 0;

    while (!cheminPris.empty() && energieNecessaire + actionenenergie(cheminPris.top().action) <= 8)
    {
        tour.emplace_back(cheminPris.top());
        energieNecessaire += actionenenergie(cheminPris.top().action);
        cheminPris.pop();
    }

    return tour;
}

/// Fonction appelée au début de la partie.
void partie_init()
{
    // fonction a completer
    ;
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    // fonction a completer
    for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++)
    {
        position depart = position_agent(moi(), iAgent);
        Array<Deplacement> cheminTour = dijkstra(depart);

        for (const Deplacement &depl : cheminTour)
        {
            if (depl.action == ACTION_DEPLACER)
                deplacer(iAgent, depl.dir);
            else if (depl.action == ACTION_GLISSER)
                glisser(iAgent, depl.dir);
            else
                pousser(iAgent, depl.dir);
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    // fonction a completer
    std::cout << SIX * NEUF << std::endl;
}

