#include <bits/stdc++.h>
using namespace std;

#include "prologin.hh"

#define lig ligne
#define col colonne

const int DEPLACER = 0;
const int LACHER = 1;
const int AGRIPPER = 2;
const int MINER = 3;
const int TIRER = 4;
const int POSER_CORDE = 5;

const int VIDE = -1;
const int GRANIT = -2;
const int OBSI = -3;
const int CORDE = -4;
const int TAVERNE[2] = {-5, -6};
const int NAINS[2] = {-7, -8};

const int oo = 1000;

vector<direction> directions;
vector<direction> directionsLaterales;

/********** Coup **********/

struct Coup {
	int iNain;
	action_type type;
	direction dir = HAUT, sens = HAUT;
	Coup(){}
	Coup(int iNain, action_type type) : iNain(iNain), type(type) {}
	Coup(int iNain, action_type type, direction dir) : iNain(iNain), type(type), dir(dir) {}
	Coup(int iNain, action_type type, direction dir, direction sens) : iNain(iNain), type(type), dir(dir), sens(sens) {}
};

/********** Etat **********/

struct Etat {
	int nbCoups = 0;
	int ID[2];
	vector<nain> nains[2];
	vector<position> pos_minerais;
	vector<minerai> minerais;
	vector<position> cordes;
	vector<position> pos_nains[2];
	position taverne[2];
	vector<vector<int>> mine;
	vector<vector<int>> nainIci;
	vector<vector<int>> id_nain;
	vector<int> vie_nains[2];
	vector<Etat> hist;
	void lire();
	void jouerCoup(Coup coup);
	void annuler();
	int lireCase(int lig, int col);
	void afficher();
	int trouverMinerai(int lig, int col);
};

void Etat::lire() {
	ID[0] = moi();
	ID[1] = adversaire();
	taverne[0] = position_taverne(ID[0]);
	taverne[1] = position_taverne(ID[1]);
	mine.assign(TAILLE_MINE, vector<int>(TAILLE_MINE, LIBRE));
	nainIci.assign(TAILLE_MINE, vector<int>(TAILLE_MINE, -1));
	id_nain.assign(TAILLE_MINE, vector<int>(TAILLE_MINE, -1));
	pos_minerais = liste_minerais();
	/*cerr<<"-------------------------\n";
	for(position pos : pos_minerais) {
		cerr << pos.lig << " " << pos.col << endl;
	}
	cerr<<"-------------------------\n";*/
	cordes = liste_cordes();
	nains[0].clear();
	nains[1].clear();
	for(int joueur = 0; joueur < 2; joueur++) {
		for(int iNain = 0; iNain < 6; iNain++)
			nains[joueur].push_back(info_nain(ID[joueur], iNain));
		int _i = 0;
		for(nain n : nains[joueur]) {
			pos_nains[joueur].push_back({n.pos.lig, n.pos.col});
			vie_nains[joueur].push_back(n.vie);
			if(n.pos.lig != -1) {
				nainIci[n.pos.lig][n.pos.col] = NAINS[joueur];
				id_nain[n.pos.lig][n.pos.col] = _i;
			}
			_i++;
		}
	}
	for(int lig = 0; lig < TAILLE_MINE; lig++)
		for(int col = 0; col < TAILLE_MINE; col++)
			mine[lig][col] = lireCase(lig, col);
	minerais.resize((int)pos_minerais.size());
	for(int lig = 0; lig < TAILLE_MINE; lig++)
		for(int col = 0; col < TAILLE_MINE; col++)
			if(mine[lig][col] >= 0)
				minerais[mine[lig][col]] = info_minerai({lig, col});
	mine[taverne[0].lig][taverne[0].col] = TAVERNE[0];
	mine[taverne[1].lig][taverne[1].col] = TAVERNE[1];
}

int Etat::trouverMinerai(int lig, int col) {
	for(int i = 0; i < (int)pos_minerais.size(); i++) {
		if(pos_minerais[i].lig == lig and pos_minerais[i].col == col)
			return i;
	}
	return -1;
}

int Etat::lireCase(int lig, int col) {
	case_type ici = type_case({lig, col});
	if(corde_sur_case({lig, col})) return CORDE;
	if(ici == LIBRE) return VIDE;
	if(ici == GRANITE) {
		int idx = trouverMinerai(lig, col);
		if(idx == -1) return GRANIT;
		return idx;
	}
	if(ici == OBSIDIENNE) return OBSI;
	cerr << "Case inconnue: " << lig << " " << col << endl;
	exit(1);
	return VIDE;
}

void Etat::annuler() {
	Etat ancien = hist.back();
	for(int i = 0; i < 2; i++) {
		ID[i] = ancien.ID[i];
		taverne[i] = ancien.taverne[i];
		nains[i] = ancien.nains[i];
	}
	nbCoups--;
	hist.pop_back();
	cordes = ancien.cordes;
	mine = ancien.mine;
}

void Etat::jouerCoup(Coup coup) {
	nbCoups++;
	if(coup.type == ACTION_DEPLACER) {
		deplacer(coup.iNain, coup.dir);
	}
	else if(coup.type == ACTION_LACHER) {
		lacher(coup.iNain);
	}
	else if(coup.type == ACTION_MINER) {
		miner(coup.iNain, coup.dir);
	}
	else if(coup.type == ACTION_POSER_CORDE) {
		poser_corde(coup.iNain, coup.dir);
	}
	else if(coup.type == ACTION_TIRER) {
		tirer(coup.iNain, coup.dir, coup.sens);
	}
	else {
		agripper(coup.iNain);
	}
}

void Etat::afficher() {
	for(int lig = 0; lig < TAILLE_MINE; lig++) {
		for(int col = 0; col < TAILLE_MINE; col++) {
			if(mine[lig][col] == VIDE) cerr << ".";
			else if(mine[lig][col] == CORDE) cerr << "|";
			else if(mine[lig][col] == OBSI) cerr << "%";
			else cerr << mine[lig][col];
			cerr << "\t\n"[col==TAILLE_MINE-1];
		}
	}
}

/********** Nain **********/

struct Nain {
	int id, lig, col, vie, pm, pa;
	bool accroche;
	int nbTours = 0;
	Nain(){}
	Nain(int id, int lig, int col, int vie, int pm, int pa, bool accroche, int nbTours = 0) : id(id), lig(lig), col(col), vie(vie), pm(pm), pa(pa), accroche(accroche), nbTours(nbTours) {}
};

bool operator < (Nain a, Nain b) {
	return (a.nbTours == b.nbTours ? a.pm < b.pm : a.nbTours > b.nbTours);
}

Nain toNain(nain n1) {
	return Nain(moi(), n1.pos.lig, n1.pos.col, n1.vie, n1.pm, n1.pa, n1.accroche);
}

/*********** Plus court chemin **********/

bool dedans(int lig, int col) {
	return (lig >= 0 and lig < TAILLE_MINE and col >= 0 and col < TAILLE_MINE);
}

bool dedans(position pos) {
	return dedans(pos.lig, pos.col);
}

int degatsChute(Etat &pos, int lig, int col) {
	int hauteur = 0;
	lig++;
	while(lig < TAILLE_MINE) {
		if((pos.mine[lig][col] != VIDE and pos.mine[lig][col] != CORDE) or pos.nainIci[lig][col] == NAINS[1]) break;
		hauteur++;
		lig++;
	}
	if(hauteur < 4) return 0;
	else return (1 << (hauteur - 4));
}

int hauteurChute(Etat &pos, int lig, int col) {
	int hauteur = 0;
	lig++;
	while(lig < TAILLE_MINE) {
		if((pos.mine[lig][col] != VIDE and pos.mine[lig][col] != CORDE) or pos.nainIci[lig][col] == NAINS[1]) break;
		hauteur++;
		lig++;
	}
	return hauteur;
}

bool cibleTaverne = false;

int paMinage(Etat &pos, int lig, int col) {
	if(!cibleTaverne and pos.mine[lig][col] == TAVERNE[1]) return -1;
	if(pos.mine[lig][col] == OBSI) return -1;
	if(pos.nainIci[lig][col] == NAINS[1]) return pos.vie_nains[1][pos.id_nain[lig][col]] / 3;
	if(pos.mine[lig][col] == TAVERNE[1]) return -1;
	if(pos.mine[lig][col] == VIDE or pos.mine[lig][col] == TAVERNE[1] or pos.mine[lig][col] == CORDE)
		return 0;
	if(pos.mine[lig][col] >= 0) return pos.minerais[pos.mine[lig][col]].resistance;
	return 1; // pour le granite
}

const int dx[] = {-1, 1, 0, 0};
const int dy[] = {0, 0, 1, -1};

int iDir(direction dir) {
	if(dir == HAUT) return 0;
	if(dir == BAS) return 1;
	if(dir == DROITE) return 2;
	return 3;
}

bool peutMarcher(Etat &pos, int lig, int col) {
	if(lig == TAILLE_MINE-1) return true;
	if(pos.mine[lig+1][col] == TAVERNE[1] or pos.mine[lig+1][col] == CORDE) return false;
	if(pos.mine[lig+1][col] == GRANIT or pos.mine[lig+1][col] == OBSI or pos.mine[lig+1][col] >= 0 or pos.nainIci[lig+1][col] == NAINS[1])
		return true;
	return false;
}

vector<pair<Nain, Coup>> listeAdj(Etat &pos, Nain n) {
	vector<pair<Nain, Coup>> adj;
	int h = hauteurChute(pos, n.lig, n.col);
	if(h < 4 and h > 0) {
	//	pos.afficher();
		adj.push_back({Nain(n.id, n.lig + h, n.col, n.vie, n.pm, n.pa, 0, n.nbTours), Coup(0, ACTION_LACHER)});
	}
	int nlig = n.lig + 1;
	int ncol = n.col;
	if(dedans(nlig, ncol) and (pos.mine[nlig][ncol] == GRANIT or pos.mine[nlig][ncol] >= 0 or pos.nainIci[nlig][ncol] == NAINS[1])) {
		int tours = paMinage(pos, nlig, ncol) - 1;
		if(tours < 0) tours++;
		int h = hauteurChute(pos, nlig, n.col) + 1;
		if(paMinage(pos, nlig, ncol) != -1 and h < 4 and h > 0) {
			int npm = 0;
			if(n.pm == 0) npm = NB_POINTS_DEPLACEMENT, tours++;
			adj.push_back({Nain(n.id, n.lig + h, ncol, n.vie, npm, n.pa, 0, n.nbTours + tours), Coup(0, ACTION_LACHER, BAS)});
		}
	}
	for(direction dir : directionsLaterales) {
		if(!peutMarcher(pos, n.lig, n.col)) continue;
		int nlig = n.lig + dx[iDir(dir)];
		int ncol = n.col + dy[iDir(dir)];
		if(!dedans(nlig, ncol)) continue;
		int tours = paMinage(pos, nlig, ncol) - 1;
		bool mine = 1;
		if(tours < 0) tours++, mine = 0;
		if(paMinage(pos, nlig, ncol) == -1) continue;
		int npm = n.pm - 1;
		if(npm < 0) tours++, npm += NB_POINTS_DEPLACEMENT;
		if(!peutMarcher(pos, nlig, ncol)) continue;
		adj.push_back({Nain(n.id, nlig, ncol, n.vie, (mine ? 0 : npm), n.pa, 0, n.nbTours + tours), Coup(0, ACTION_DEPLACER, dir)});
	}
	for(direction dir : directions) {
		int nlig = n.lig + dx[iDir(dir)];
		int ncol = n.col + dy[iDir(dir)];
		if(!dedans(nlig, ncol)) continue;
		int tours = paMinage(pos, nlig, ncol) - 1;
		bool mine = 1;
		if(tours < 0) tours++, mine = 0;
		if(paMinage(pos, nlig, ncol) == -1) continue;
		int npm = n.pm - 2;
		if(pos.mine[nlig][ncol] == CORDE) {
			npm++;
			if(npm < 0) tours++, npm += NB_POINTS_DEPLACEMENT;
		}
		else {
			if(npm < 0) tours++, npm = NB_POINTS_DEPLACEMENT - 2;
		}
		adj.push_back({Nain(n.id, nlig, ncol, n.vie, (mine ? 0 : npm), n.pa, 1, n.nbTours + tours), Coup(0, ACTION_DEPLACER, dir)});
	}
	return adj;
}

struct Res {
	int nbTours, pm;
	Coup coup;
	Nain precedent;
};

typedef vector<vector<Res>> Dist;

Dist initDist(int a, int b) {
	return Dist(a, vector<Res>(b, {+oo, 0, Coup(), Nain()}));
}

Dist plusCourtChemin(Etat &pos, Nain n) {
	Dist dist = initDist(TAILLE_MINE, TAILLE_MINE);
	n.nbTours = 0;
	priority_queue<Nain> file;
	file.push(n);
	dist[n.lig][n.col] = {0, n.pm, Coup()};
	int cnt = 0;
	while(!file.empty()) {
		Nain act = file.top();
		file.pop();
		if(dist[act.lig][act.col].nbTours < act.nbTours or (dist[act.lig][act.col].nbTours == act.nbTours and dist[act.lig][act.col].pm > act.pm)) continue;
		cnt++;
		vector<pair<Nain, Coup>> adj = listeAdj(pos, act);
		for(auto p : adj) {
			if(p.first.nbTours < dist[p.first.lig][p.first.col].nbTours or (p.first.nbTours == dist[p.first.lig][p.first.col].nbTours and p.first.pm > dist[p.first.lig][p.first.col].pm)) {
				dist[p.first.lig][p.first.col].nbTours = p.first.nbTours;
				dist[p.first.lig][p.first.col].pm = p.first.pm;
				dist[p.first.lig][p.first.col].coup = p.second;
				dist[p.first.lig][p.first.col].precedent = act;
				file.push(p.first);
			}
		}
	}
	return dist;
}

/********** Aller a case **********/

void afficherCoup(Coup coup) {
	if(coup.type == ACTION_DEPLACER) cout << "Deplacement ";
	else if(coup.type == ACTION_LACHER) cout << "Lacher ";
	else if(coup.type == ACTION_AGRIPPER) cout << "Agripper: ";
	else if(coup.type == ACTION_MINER) cout << "Miner: ";
	else cout << "Autre ";
	if(coup.dir == HAUT) cout << "HAUT";
	if(coup.dir == BAS) cout << "BAS";
	if(coup.dir == DROITE) cout << "DROITE";
	if(coup.dir == GAUCHE) cout << "GAUCHE";
	cout << endl;
}

bool allerVers(Etat &pos, Dist &dist, Nain n, position p) {
	if(dist[p.lig][p.col].nbTours >= +oo or (n.lig == p.lig and n.col == p.col)) return 0;
	vector<Coup> chemin;
	int lig = p.lig, col = p.col;
	int _lig, _col;
	//reconstituer le chemin:
	while(lig != n.lig or col != n.col) {
		chemin.push_back(dist[lig][col].coup);
		_lig = dist[lig][col].precedent.lig;
		_col = dist[lig][col].precedent.col;
		lig = _lig;
		col = _col;
	}
	reverse(chemin.begin(), chemin.end());
	/*for(Coup coup : chemin) {
		afficherCoup(coup);
	}*/
	//suivre le chemin:
	int i = 0, pm = NB_POINTS_DEPLACEMENT;//, pa = NB_POINTS_ACTION;
	bool utilisePA = 0;
	while(i < (int)chemin.size() and pm > 0) {
		pos.lire();
		chemin[i].iNain = n.id;
		// trouver le coup a faire
		pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
		// si c'est un coup lacher :
		if(chemin[i].type == ACTION_LACHER) {
			int h = hauteurChute(pos, lig, col);
		//	cout << lig << " " << col << " " << h << endl;
			if(chemin[i].dir == BAS) {
				int aMiner = paMinage(pos, lig + 1, col);
				if(aMiner > 0) pos.jouerCoup(Coup(n.id, ACTION_MINER, chemin[i].dir)), utilisePA = 1;
				pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
				if(aMiner > 1) break;
				h = hauteurChute(pos, lig+1, col) + 1;
				lig += h;
				pos.jouerCoup(Coup(n.id, ACTION_LACHER));
				pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
				break;
			}
			pos.jouerCoup(Coup(n.id, ACTION_LACHER));
			pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
			lig += h;
			i++;
			continue;
		}
		// Si il faut miner :
		int nlig = lig + dx[iDir(chemin[i].dir)];
		int ncol = col + dy[iDir(chemin[i].dir)];
		int aMiner = paMinage(pos, nlig, ncol);
		bool casser = 0;
		if(aMiner > 0) pos.jouerCoup(Coup(n.id, ACTION_MINER, chemin[i].dir)), utilisePA = 1, casser = 1;
		pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
		if(aMiner > 1) break;
		bool marche = 0;
		if(chemin[i].dir == GAUCHE or chemin[i].dir == DROITE) {
			if(peutMarcher(pos, lig, col) and peutMarcher(pos, nlig, ncol)) {
				pos.jouerCoup(Coup(n.id, ACTION_LACHER));
				pm++;
				marche = 1;
			}
		}
		if(!marche and pos.mine[nlig][ncol] == CORDE) {
			pm++;
		}
		if(pm < 2) break;
		pos.jouerCoup(chemin[i]);
		pm -= 2;
		pos.jouerCoup(Coup(n.id, ACTION_AGRIPPER));
		lig = nlig, col = ncol;
		i++;
		if(casser) break;
	}
	return utilisePA;
}

/********** Interaction **********/

int MOI;

void partie_init() {
	MOI = moi();
	directions.clear();
	directions.push_back(HAUT);
	directions.push_back(BAS);
	directions.push_back(DROITE);
	directions.push_back(GAUCHE);
	directionsLaterales.clear();
	directionsLaterales.push_back(DROITE);
	directionsLaterales.push_back(GAUCHE);
}

int nbTour = 0;

void jouer_tour() {
	nbTour++;
	Etat jeu;
	jeu.lire();
	
	vector<int> deja((int)jeu.minerais.size(), 0);
	vector<int> dejaAttaque(6, 0);
	vector<vector<int>> DEJA(TAILLE_MINE, vector<int>(TAILLE_MINE, 0));
	bool utilisePA = false;
	
	int cntAttaque = 0;
	
	for(int i = 0; i < 6; i++) {
	//	cout << "debut nain " << i << endl;
		jeu.lire();
		nain cur = jeu.nains[0][i];
		if(cur.pos.lig == -1) continue;
		Nain n = Nain(i, cur.pos.lig, cur.pos.col, cur.vie, cur.pm, cur.pa, 0, 0);
		Dist dist = plusCourtChemin(jeu, n);
		int dTaverne = dist[jeu.taverne[0].lig][jeu.taverne[0].col].nbTours;
		// retourner chez soi
		if(cur.butin > 20 or (100 - nbTour <= dTaverne + 3 and cur.butin > 0)) {
			utilisePA |= allerVers(jeu, dist, n, jeu.taverne[0]);
			continue;
		}
		// aller pres de la taverne de l'autre si butin est negatif
		if(cur.butin < 0 and dist[jeu.taverne[1].lig][jeu.taverne[1].col].nbTours < +oo) {
			cibleTaverne = true;
			utilisePA |= allerVers(jeu, dist, n, jeu.taverne[1]);
			cibleTaverne = false;
			continue;
		}
		// si on est attaque
		bool attaque = false;
		int vMax = -oo;
		int iAttaque = -1;
		position cible;
		for(int iEnnemi = 0; iEnnemi < 6; iEnnemi++) {
			nain adv = jeu.nains[1][iEnnemi];
			if(adv.pos.lig == -1 or (adv.pos.lig == jeu.taverne[1].lig and adv.pos.col == jeu.taverne[1].col))
				continue;
			int lig = jeu.pos_nains[1][iEnnemi].lig;
			int col = jeu.pos_nains[1][iEnnemi].col;
			for(direction dir : directions) {
		//		cout << "debut dir" << endl;
				int nlig = lig + dx[iDir(dir)];
				int ncol = col + dy[iDir(dir)];
				if(!dedans(nlig, ncol)) continue;
				if(dist[nlig][ncol].nbTours == 0 and cntAttaque < 4 and dejaAttaque[iEnnemi] < 4 and DEJA[nlig][ncol] < 4) {
					attaque = true;
					iAttaque = iEnnemi;
					if(vMax < adv.butin) {
						vMax = adv.butin;
						cible = adv.pos;
					}
				}
	//			cout << "fin dir" << endl;
			}
		}
		if(attaque) {
			if(cur.butin <= 10) {
				cntAttaque++;
				dejaAttaque[iAttaque]++;
				DEJA[cible.lig][cible.col]++;
				utilisePA |= allerVers(jeu, dist, n, cible);
				continue;
			}
			else {
				utilisePA |= allerVers(jeu, dist, n, jeu.taverne[0]);
				continue;
			}
		}
		// sinon on determine la meilleure action
		double meilleur = 0;
		int iMeilleurMinerai = -1;
		bool miner = false;
		for(int iMinerai = 0; iMinerai < (int)jeu.minerais.size(); iMinerai++) {
			double d = (double)dist[jeu.pos_minerais[iMinerai].lig][jeu.pos_minerais[iMinerai].col].nbTours + 0.1;
			double valeur = (double)jeu.minerais[iMinerai].rendement;
			valeur = min(valeur, 25.0 - (double)cur.butin);
			if(jeu.mine[jeu.pos_minerais[iMinerai].lig][jeu.pos_minerais[iMinerai].col] == VIDE)
				continue;
			valeur /= (double)(deja[iMinerai] + 1);
			valeur /= d;
			if(valeur > meilleur) {
				meilleur = valeur;
				iMeilleurMinerai = iMinerai;
				miner = true;
			}
		}
		int iMeilleurEnnemi = -1;
		for(int iEnnemi = 0; iEnnemi < 6; iEnnemi++) {
			nain adv = jeu.nains[1][iEnnemi];
			if(adv.pos.lig == -1 or (adv.pos.lig == jeu.taverne[1].lig and adv.pos.col == jeu.taverne[1].col))
				continue;
			double d = (double)dist[jeu.pos_nains[1][iEnnemi].lig][jeu.pos_nains[1][iEnnemi].col].nbTours + 0.1;
			double valeur = (double)jeu.nains[1][iEnnemi].butin;
			valeur = min(valeur, 25.0 - (double)cur.butin);
			valeur *= 1.2;
			if(valeur <= 0) continue;
			valeur /= d;
			if(valeur > meilleur) {
				meilleur = valeur;
				iMeilleurEnnemi = iEnnemi;
				miner = false;
			}
		}
		// faire le coup:
		if(iMeilleurEnnemi == -1 and iMeilleurMinerai == -1) {
			if(dist[jeu.taverne[1].lig][jeu.taverne[1].col].nbTours > 1)
				utilisePA |= allerVers(jeu, dist, n, jeu.taverne[1]);
			continue;
		}
		if(miner) {
			utilisePA |= allerVers(jeu, dist, n, jeu.pos_minerais[iMeilleurMinerai]);
			deja[iMeilleurMinerai]++;
			continue;
		}
		else {
			utilisePA |= allerVers(jeu, dist, n, jeu.pos_nains[1][iMeilleurEnnemi]);
			continue;
		}
	//	cout << "fin nain " << i << endl;
	}
	// poser une corde si on n'a pas utilise les points d'actions:
	jeu.lire();
	int idPlusHaut = -1;
	int hMax = 0;
	for(int i = 0; i < 6; i++) {
		nain cur = jeu.nains[0][i];
		if(cur.pos.lig == -1) continue;
		int h = hauteurChute(jeu, cur.pos.lig, cur.pos.col);
		if(h > hMax) {
			hMax = h;
			idPlusHaut = i;
		}
	}
	if(idPlusHaut != -1) {
		direction dir = BAS;
		nain cur = jeu.nains[0][idPlusHaut];
		if(dedans(cur.pos.lig-1, cur.pos.col) and jeu.mine[cur.pos.lig-1][cur.pos.col] == VIDE)
			dir = HAUT;
		jeu.jouerCoup(Coup(idPlusHaut, ACTION_POSER_CORDE, dir));
	}
//	cout << "fin" << endl;
}

void partie_fin() {
	
}




























































































































