#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

const int oo = 1e9;

string carte[TAILLE_BANQUISE];

// infos sur la partie
int id_joueur, id_ennemi;
vector<position> agents, ennemis;
vector<position> aliens;//vector<alien_info> aliens;
int D[25][25];
position parent[25][25];
int TOUR = 0;
int aggressif = 0;
int defendu[4];
int attaque[25][25];
vector<alien_info> liste;

const int DX[] = {0, 1, 0, -1};
const int DY[] = {1, 0, -1, 0};
direction DIR[] = {EST, SUD, OUEST, NORD};

bool libre(position pos) {
	for(position p : ennemis)if(pos == p) return false;
	for(position p : agents)if(pos == p) return false;
	return (type_case(pos) == LIBRE);
}

vector<pair<int, position>> adj(position pos) {
	vector<pair<int, position>> voisins;
	for(int dir = 0; dir < 4; dir++)
		if(libre({pos.ligne + DX[dir], pos.colonne + DY[dir]}))
			voisins.push_back({1, {pos.ligne + DX[dir], pos.colonne + DY[dir]}});
	int lig,col;
	for(int dir=0;dir<4;dir++){
		lig=pos.ligne;
		col=pos.colonne;
		while(libre({lig+DX[dir], col+DY[dir]}))lig+=DX[dir], col+=DY[dir];
		voisins.push_back({3, {lig, col}}); 
	}
	return voisins;
}

position _actuelDijkstra = {-1, -1};
void dijkstra(position pos) {
	if(_actuelDijkstra == pos) return;
	_actuelDijkstra = pos;
	for(int lig = 0; lig < 25; lig++)
		for(int col = 0; col < 25; col++)
			D[lig][col] = +oo;
	D[pos.ligne][pos.colonne] = 0;
	priority_queue<pair<int, pair<int, int>>, vector<pair<int, pair<int, int>>>, greater<pair<int, pair<int, int>>>>Q;
	Q.push({0, {pos.ligne, pos.colonne}});
	while(!Q.empty()) {
		int poids = Q.top().first;
		int lig = Q.top().second.first;
		int col = Q.top().second.second;
		Q.pop();
		if(poids > D[lig][col])continue;
		vector<pair<int, position>> voisins = adj({lig, col});
		for(pair<int, position> p : voisins) {
			int cost = p.first;
			int nlig = p.second.ligne;
			int ncol = p.second.colonne;
			if(D[nlig][ncol] > cost + poids) {
				D[nlig][ncol] = cost + poids;
				Q.push({D[nlig][ncol], {nlig, ncol}});
				parent[nlig][ncol] = {lig, col};
			}
		}
	}
}

vector<pair<bool, direction>> Chemin(position p1, position p2) {
	dijkstra(p1);
	vector<pair<bool, direction>> way;
	if(p1.ligne < 0 or p1.ligne > 24 or p1.colonne < 0 or
		p1.colonne > 24 or p2.ligne < 0 or p2.ligne > 24 or
			p2.colonne < 0 or p2.colonne > 24 or D[p2.ligne][p2.colonne] == +oo)
				return way;
	position ret;
	while(p2 != p1) {
		ret = parent[p2.ligne][p2.colonne];
		bool glissade = false;
		if(abs(ret.ligne - p2.ligne) + abs(ret.colonne - p2.colonne) > 1) glissade = true;
		direction dir = NORD;
		if(ret.ligne < p2.ligne) dir = SUD;
		else if(ret.colonne < p2.colonne) dir = EST;
		else if(ret.colonne > p2.colonne) dir = OUEST;
		way.push_back({glissade, dir});
		p2 = ret;
	}
	reverse(way.begin(), way.end());
	return way;
}

//appelee au debut de la partie
void partie_init() {
	id_joueur = moi();
	id_ennemi = adversaire();
	liste = liste_aliens();
}

//const action_type poussade = ACTION_POUSSER;

void actualiser() {
	agents.clear();
	ennemis.clear();
	for(int i = 0; i < 4; i++) agents.push_back(position_agent(id_joueur, i));
	for(int i = 0; i < 4; i++) ennemis.push_back(position_agent(id_ennemi, i));
	aliens.clear();
	for(int lig = 0; lig < 25; lig++){
		for(int col = 0; col < 25; col++){
			position act = {lig, col};
			bool ennemi = false;
			for(int i=0;i<4;i++)ennemi|=(act == ennemis[i]);
			bool agent = false;
			for(int i=0;i<4;i++)agent|=(act == agents[i]);
			if(alien_sur_case(act) and !ennemi and !agent)
				aliens.push_back(act);
		}
	}
}

void defendreAutour(int i) {
	bool aDefendu = false;
	for(int dir = 0; dir < 4; dir++) {
		if(aDefendu)break;
		position pos = {agents[i].ligne + DX[dir], agents[i].colonne + DY[dir]};
		for(position ennemi : ennemis) {
			if(ennemi == pos) {
				pousser(i, DIR[dir]);
				aDefendu = true;
			}
		}
	}
	actualiser();
}

void choisirJouerCoup(int i, int PA = 8) {
	if(alien_sur_case(agents[i])) {
		defendreAutour(i);
		return;
	}
	bool aDefendu = false;
	double valMaxCoup = 0;
	direction poussage = NORD;
	vector<pair<bool, direction>> coups;
	int _j = -1;
	for(int j = 0; j < 4; j++){
		if(PA < 5 or defendu[j] > 1) continue;
		if(alien_sur_case(ennemis[j]) and info_alien(ennemis[j]).points_capture > 0) {
			for(int dir = 0; dir < 4; dir++) {
				int x = ennemis[j].ligne + DX[dir];
				int y = ennemis[j].colonne + DY[dir];
				vector<pair<bool, direction>> way = Chemin(agents[i], {x, y});
				if(x<0 or x>24 or y<0 or y>24)continue;
				if(D[x][y] > 8+8+3)continue;
				int nbTours = (D[x][y] + 5) / PA;
				if((D[x][y]+5)%PA) nbTours++;
				if(TOUR + 3 - info_alien(ennemis[j]).capture_en_cours > info_alien(ennemis[j]).tour_invasion + info_alien(ennemis[j]).duree_invasion) continue;
				if(nbTours > 3 - info_alien(ennemis[j]).capture_en_cours) continue;
				if(!libre({x-2*DX[dir], y-2*DY[dir]})) continue;
				double valCoup = 1.0 * (double)info_alien(ennemis[j]).points_capture;
				if(nbTours) valCoup /= (double)nbTours;
				if(valCoup > valMaxCoup) {
					valMaxCoup = valCoup;
					coups = way;
					if(dir == 0)poussage = OUEST;
					else if(dir == 1)poussage = NORD;
					else if(dir == 2)poussage = EST;
					else poussage = SUD;
					aDefendu = true;
					_j = j;
				}
			}
			
		}
	}
	position Alien = {0, 0};
	for(position alien : aliens) {
		if(info_alien(alien).points_capture <= 0) continue;
		if(attaque[alien.ligne][alien.colonne] > 1) continue;
		vector<pair<bool, direction>> way = Chemin(agents[i], alien);
		if(D[alien.ligne][alien.colonne] == +oo)continue;
		int nbTours = (D[alien.ligne][alien.colonne]) / PA;
		if(D[alien.ligne][alien.colonne] % PA) nbTours++;
		if(TOUR + nbTours + 2 > info_alien(alien).tour_invasion + info_alien(alien).duree_invasion) continue;
		double valCoup = 1.0 * (double)info_alien(alien).points_capture;
		if(nbTours) valCoup /= (double)nbTours;
		if(valCoup > valMaxCoup) {
			valMaxCoup = valCoup;
			coups = way;
			aDefendu = false;
			Alien = alien;
		}
	}
	//pos, points_capture, tour_invasion, duree_invasion, capture_en_cours
	for(alien_info alien : liste) {
		if(alien.points_capture <= 0) continue;
		if(attaque[alien.pos.ligne][alien.pos.colonne] > 1) continue;
		if(TOUR >= alien.tour_invasion) continue;
		vector<pair<bool, direction>> way = Chemin(agents[i], alien.pos);
		int nbTours = (D[alien.pos.ligne][alien.pos.colonne]) / PA;
		if(D[alien.pos.ligne][alien.pos.colonne] % PA) nbTours++;
		nbTours = max(nbTours, alien.tour_invasion - TOUR + 1);
		if(TOUR + nbTours + 2 > alien.tour_invasion + alien.duree_invasion) continue;
		double valCoup = 1.0 * (double)alien.points_capture;
		if(nbTours) valCoup /= (double)nbTours;
		if(valCoup > valMaxCoup) {
			valMaxCoup = valCoup;
			coups = way;
			aDefendu = false;
			Alien = alien.pos;
		}
	}
	int pa = 0;
	int j = 0;
	if(aDefendu and _j != -1) defendu[_j]++;
	else attaque[Alien.ligne][Alien.colonne]++;
	while(pa < PA and j < (int)coups.size()) {
		if(coups[j].first and pa + 3 > PA) {
			pa = 9;
			break;
		}
		if(!coups[j].first) deplacer(i, coups[j].second), pa++;
		else glisser(i, coups[j].second), pa += 3;
		j++;
	}
	if(aDefendu and j == (int)coups.size() and pa + 5 <= PA) {
		pousser(i, poussage);
		actualiser();
		if(pa + 5 < PA)
			choisirJouerCoup(i, PA - pa - 5);
	}
	actualiser();
}

void jouer_tour() {
	actualiser();
	
	for(int i = 0; i < 4; i++) defendu[i] = 0;
	for(int i = 0; i < 25; i++)
		for(int j = 0; j < 25; j++)
			attaque[i][j] = 0;
	
	for(action_hist act : historique())
		if(act.atype == ACTION_POUSSER)
			aggressif++;
	
	for(int i = 0; i < 4; i++)
		choisirJouerCoup(i);
	
	TOUR++;
}

//appelee a la fin de la partie
void partie_fin() {
	
}

int main() {
	cout << 42 << endl;
	
	return 0;
}



















































