// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Types de cases
	public enum CaseType {
		LIBRE, // <- Case libre
		MUR, // <- Mur
		ERREUR, // <- Erreur
	}

// Points cardinaux
	public enum Direction {
		NORD, // <- Direction : nord
		EST, // <- Direction : est
		SUD, // <- Direction : sud
		OUEST, // <- Direction : ouest
	}

// Erreurs possibles
	public enum Erreur {
		OK, // <- L'action s'est effectuée avec succès.
		PA_INSUFFISANTS, // <- Votre agent ne possède pas assez de points d'action pour réaliser cette action.
		POSITION_INVALIDE, // <- La position spécifiée n'est pas sur la banquise.
		OBSTACLE_MUR, // <- La position spécifiée est un mur.
		OBSTACLE_AGENT, // <- La position spécifiée est un agent.
		DEPLACEMENT_HORS_LIMITES, // <- Ce déplacement fait sortir un agent des limites de la banquise.
		DIRECTION_INVALIDE, // <- La direction spécifiée n'existe pas.
		ID_AGENT_INVALIDE, // <- L'agent spécifié n'existe pas.
		RIEN_A_POUSSER, // <- Aucun agent à pousser dans la direction indiquée.
		DRAPEAU_INVALIDE, // <- Le drapeau spécifié n'existe pas.
	}

// Types d'actions
	public enum ActionType {
		ACTION_DEPLACER, // <- Action ``deplacer``
		ACTION_GLISSER, // <- Action ``glisser``
		ACTION_POUSSER, // <- Action ``pousser``
	}

// Types de drapeaux de débug
	public enum DebugDrapeau {
		AUCUN_DRAPEAU, // <- Aucun drapeau, enlève le drapeau présent
		DRAPEAU_BLEU, // <- Drapeau bleu
		DRAPEAU_VERT, // <- Drapeau vert
		DRAPEAU_ROUGE, // <- Drapeau rouge
	}

// Position sur la banquise, donnée par deux coordonnées.
	class Position {
		public Position() {
		}
		public int Ligne; // <- Coordonnée : ligne
		public int Colonne; // <- Coordonnée : colonne
	}

// Alien à capturer durant la mission.
	class AlienInfo {
		public AlienInfo() {
		}
		public Position Pos; // <- Position de l'alien
		public int PointsCapture; // <- Nombre de points obtenus pour la capture de cet alien
		public int TourInvasion; // <- Tour où l'alien débarque sur la banquise
		public int DureeInvasion; // <- Nombre de tours où l'alien reste sur la banquise
		public int CaptureEnCours; // <- Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE
	}

// Action de déplacement représentée dans l'historique.
	class ActionHist {
		public ActionHist() {
		}
		public ActionType Atype; // <- Type de l'action
		public int IdAgent; // <- Numéro de l'agent concerné par l'action
		public Direction Dir; // <- Direction visée par l'agent durant le déplacement
	}

	class Api {
// Taille de la banquise (longueur et largeur).
		public const int TAILLE_BANQUISE = 25;

// Nombre de tours à jouer avant la fin de la partie.
		public const int NB_TOURS = 100;

// Nombre de points d'action par tour par agent.
		public const int NB_POINTS_ACTION = 8;

// Nombre de point d'action que coûte un déplacement.
		public const int COUT_DEPLACEMENT = 1;

// Nombre de points d'action que coûte une glissade.
		public const int COUT_GLISSADE = 3;

// Nombre de points d'action nécessaires pour pousser un agent.
		public const int COUT_POUSSER = 5;

// Nombre d'agents par joueur.
		public const int NB_AGENTS = 4;

// Nombre de tours nécessaires pour capturer un alien.
		public const int NB_TOURS_CAPTURE = 3;

// Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deplacer(int id_agent, Direction dir);

// Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Glisser(int id_agent, Direction dir);

// L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Pousser(int id_agent, Direction dir);

// Affiche le drapeau spécifié sur la case indiquée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur DebugAfficherDrapeau(Position pos, DebugDrapeau drapeau);

// Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PointsActionAgent(int id_agent);

// Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Direction[] Chemin(Position pos1, Position pos2);

// Renvoie le type d'une case donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern CaseType TypeCase(Position pos);

// Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int AgentSurCase(Position pos);

// Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool AlienSurCase(Position pos);

// Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position PositionAgent(int id_joueur, int id_agent);

// Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern AlienInfo InfoAlien(Position pos);

// Renvoie la liste de tous les aliens présents durant la partie.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern AlienInfo[] ListeAliens();

// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern ActionHist[] Historique();

// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Score(int id_joueur);

// Renvoie votre numéro de joueur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Moi();

// Renvoie le numéro de joueur de votre adversaire.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Adversaire();

// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Annuler();

// Retourne le numéro du tour actuel.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Affiche le contenu d'une valeur de type case_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherCaseType(CaseType v);

// Affiche le contenu d'une valeur de type direction
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherDirection(Direction v);

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type action_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherActionType(ActionType v);

// Affiche le contenu d'une valeur de type debug_drapeau
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherDebugDrapeau(DebugDrapeau v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type alien_info
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherAlienInfo(AlienInfo v);

// Affiche le contenu d'une valeur de type action_hist
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherActionHist(ActionHist v);

	}
}
