/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

/// Position sur la banquise, donnée par deux coordonnées.
typedef struct __internal__cxx__position {
  int ligne;
  int colonne;
} __internal__cxx__position;

/// Alien à capturer durant la mission.
typedef struct __internal__cxx__alien_info {
  __internal__cxx__position pos;
  int points_capture;
  int tour_invasion;
  int duree_invasion;
  int capture_en_cours;
} __internal__cxx__alien_info;

/// Action de déplacement représentée dans l'historique.
typedef struct __internal__cxx__action_hist {
  action_type atype;
  int id_agent;
  direction dir;
} __internal__cxx__action_hist;

/// Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
extern "C" erreur api_deplacer(int id_agent, direction dir);

/// Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
extern "C" erreur api_glisser(int id_agent, direction dir);

/// L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
extern "C" erreur api_pousser(int id_agent, direction dir);

/// Affiche le drapeau spécifié sur la case indiquée.
extern "C" erreur api_debug_afficher_drapeau(__internal__cxx__position pos, debug_drapeau drapeau);

/// Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
extern "C" int api_points_action_agent(int id_agent);

/// Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
extern "C" std::vector<direction> api_chemin(__internal__cxx__position pos1, __internal__cxx__position pos2);

/// Renvoie le type d'une case donnée.
extern "C" case_type api_type_case(__internal__cxx__position pos);

/// Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
extern "C" int api_agent_sur_case(__internal__cxx__position pos);

/// Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
extern "C" bool api_alien_sur_case(__internal__cxx__position pos);

/// Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
extern "C" __internal__cxx__position api_position_agent(int id_joueur, int id_agent);

/// Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
extern "C" __internal__cxx__alien_info api_info_alien(__internal__cxx__position pos);

/// Renvoie la liste de tous les aliens présents durant la partie.
extern "C" std::vector<__internal__cxx__alien_info> api_liste_aliens(void);

/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
extern "C" std::vector<__internal__cxx__action_hist> api_historique(void);

/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
extern "C" int api_score(int id_joueur);

/// Renvoie votre numéro de joueur.
extern "C" int api_moi(void);

/// Renvoie le numéro de joueur de votre adversaire.
extern "C" int api_adversaire(void);

/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
extern "C" bool api_annuler(void);

/// Retourne le numéro du tour actuel.
extern "C" int api_tour_actuel(void);

/// Affiche le contenu d'une valeur de type case_type
extern "C" void api_afficher_case_type(case_type v);

/// Affiche le contenu d'une valeur de type direction
extern "C" void api_afficher_direction(direction v);

/// Affiche le contenu d'une valeur de type erreur
extern "C" void api_afficher_erreur(erreur v);

/// Affiche le contenu d'une valeur de type action_type
extern "C" void api_afficher_action_type(action_type v);

/// Affiche le contenu d'une valeur de type debug_drapeau
extern "C" void api_afficher_debug_drapeau(debug_drapeau v);

/// Affiche le contenu d'une valeur de type position
extern "C" void api_afficher_position(__internal__cxx__position v);

/// Affiche le contenu d'une valeur de type alien_info
extern "C" void api_afficher_alien_info(__internal__cxx__alien_info v);

/// Affiche le contenu d'une valeur de type action_hist
extern "C" void api_afficher_action_hist(__internal__cxx__action_hist v);

#endif
