#include <bits/stdc++.h>
#include "prologin.hh"
using namespace std;

const int oo = 1e9;

string carte[TAILLE_BANQUISE];

// infos sur la partie
int id_joueur, id_ennemi;
vector<position> agents, ennemis;
vector<position> aliens;//vector<alien_info> aliens;
int D[25][25];
position parent[25][25];
int TOUR = 1;

const int DX[] = {0, 1, 0, -1};
const int DY[] = {1, 0, -1, 0};

bool libre(position pos) {
	for(position p : ennemis)if(pos == p) return false;
	for(position p : agents)if(pos == p) return false;
	return (type_case(pos) == LIBRE);
}

vector<pair<int, position>> adj(position pos) {
	vector<pair<int, position>> voisins;
	for(int dir = 0; dir < 4; dir++)
		if(libre({pos.ligne + DX[dir], pos.colonne + DY[dir]}))
			voisins.push_back({1, {pos.ligne + DX[dir], pos.colonne + DY[dir]}});
	int lig,col;
	for(int dir=0;dir<4;dir++){
		lig=pos.ligne;
		col=pos.colonne;
		while(libre({lig+DX[dir], col+DY[dir]}))lig+=DX[dir], col+=DY[dir];
		voisins.push_back({3, {lig, col}}); 
	}
	return voisins;
}

position _actuelDijkstra = {-1, -1};
void dijkstra(position pos) {
	if(_actuelDijkstra == pos) return;
	_actuelDijkstra = pos;
	for(int lig = 0; lig < 25; lig++)
		for(int col = 0; col < 25; col++)
			D[lig][col] = +oo;
	D[pos.ligne][pos.colonne] = 0;
	priority_queue<pair<int, pair<int, int>>, vector<pair<int, pair<int, int>>>, greater<pair<int, pair<int, int>>>>Q;
	Q.push({0, {pos.ligne, pos.colonne}});
	while(!Q.empty()) {
		int poids = Q.top().first;
		int lig = Q.top().second.first;
		int col = Q.top().second.second;
		Q.pop();
		if(poids > D[lig][col])continue;
		vector<pair<int, position>> voisins = adj({lig, col});
		for(pair<int, position> p : voisins) {
			int cost = p.first;
			int nlig = p.second.ligne;
			int ncol = p.second.colonne;
			if(D[nlig][ncol] > cost + poids) {
				D[nlig][ncol] = cost + poids;
				Q.push({D[nlig][ncol], {nlig, ncol}});
				parent[nlig][ncol] = {lig, col};
			}
		}
	}
}

vector<pair<bool, direction>> Chemin(position p1, position p2) {
	dijkstra(p1);
	vector<pair<bool, direction>> way;
	if(p1.ligne < 0 or p1.ligne > 24 or p1.colonne < 0 or
		p1.colonne > 24 or p2.ligne < 0 or p2.ligne > 24 or
			p2.colonne < 0 or p2.colonne > 24 or D[p2.ligne][p2.colonne] == +oo)
				return way;
	position ret;
	while(p2 != p1) {
		ret = parent[p2.ligne][p2.colonne];
		bool glissade = false;
		if(abs(ret.ligne - p2.ligne) + abs(ret.colonne - p2.colonne) > 1) glissade = true;
		direction dir = NORD;
		if(ret.ligne < p2.ligne) dir = SUD;
		else if(ret.colonne < p2.colonne) dir = EST;
		else if(ret.colonne > p2.colonne) dir = OUEST;
		way.push_back({glissade, dir});
		p2 = ret;
	}
	reverse(way.begin(), way.end());
	return way;
}

//appelee au debut de la partie
void partie_init() {
	id_joueur = moi();
	id_ennemi = adversaire();
}

void actualiser() {
	agents.clear();
	ennemis.clear();
	for(int i = 0; i < 4; i++) agents.push_back(position_agent(id_joueur, i));
	for(int i = 0; i < 4; i++) ennemis.push_back(position_agent(id_ennemi, i));
	aliens.clear();
	for(int lig = 0; lig < 25; lig++){
		for(int col = 0; col < 25; col++){
			position act = {lig, col};
			bool ennemi = false;
			for(int i=0;i<4;i++)ennemi|=(act == ennemis[i]);
			bool agent = false;
			for(int i=0;i<4;i++)agent|=(act == agents[i]);
			if(alien_sur_case(act) and !ennemi and !agent)
				aliens.push_back(act);
		}
	}
}

//appelee a chaque tour
// sans glissade
/*void jouer_tour() {
	actualiser();
	for(int i = 0; i < 4; i++) {
		if(alien_sur_case(agents[i])) continue;
		vector<direction> coups;
		int maxi = 0;
		for(position alien : aliens) {
			vector<direction> way = chemin(agents[i], alien);
			if(way.size() > 0 and way.size() < 9) {
				if(info_alien(alien).points_capture > maxi)
					coups = way;
			}
			else if(way.size() > 0 and coups.size() == 0)
				coups = way;
		}
		for(int j = 0; j < min(8, (int)coups.size()); j++) deplacer(i, coups[j]);
		actualiser();
	}
	TOUR++;
}*/

//pareil mais avec glissade
/*
void jouer_tour() {
	actualiser();
	for(int i = 0; i < 4; i++) {
		if(alien_sur_case(agents[i])) continue;
		vector<pair<bool, direction>> coups;
		int maxi = 0;
		for(position alien : aliens) {
			vector<pair<bool, direction>> way = Chemin(agents[i], alien);
			if(D[alien.ligne][alien.colonne] < 9) {
				if(info_alien(alien).points_capture > maxi)
					coups = way;
			}
			else if(way.size() > 0 and coups.size() == 0)
				coups = way;
		}
		int pa = 0;
		int j = 0;
		while(pa < 8 and j < min(8, (int)coups.size())){
			if(coups[j].first and pa + 3 > 8) break;
			if(!coups[j].first) deplacer(i, coups[j].second), pa++;
			else glisser(i, coups[j].second), pa += 3;
			j++;
		}
		actualiser();
	}
	TOUR++;
}*/

void attaquer(int i) {
	if(alien_sur_case(agents[i])) return;
	vector<pair<bool, direction>> coups;
	int maxi = 0;
	bool finissable = 0;
	for(position alien : aliens) {
		vector<pair<bool, direction>> way = Chemin(agents[i], alien);
		if(D[alien.ligne][alien.colonne] < 9) {
			if(info_alien(alien).points_capture > maxi) {
				maxi = info_alien(alien).points_capture;
				coups = way;
				finissable = 1;
			}
		}
		else if(way.size() > 0 and coups.size() == 0) {
			if(!finissable and info_alien(alien).points_capture > maxi) {
				coups = way;
				maxi = info_alien(alien).points_capture;
			}
		}
	}
	int pa = 0;
	int j = 0;
	while(pa < 8 and j < min(8, (int)coups.size())){
		if(coups[j].first and pa + 3 > 8) break;
		if(!coups[j].first) deplacer(i, coups[j].second), pa++;
		else glisser(i, coups[j].second), pa += 3;
		j++;
	}
	actualiser();
}

//defense v1
/*
void defendre(int i) {
	if(alien_sur_case(agents[i])) return;
	bool aDefendu = false;
	int mini = +oo;
	direction poussage = NORD;
	vector<pair<bool, direction>> coups;
	for(int j = 0; j < 4; j++){
		if(alien_sur_case(ennemis[j])) {
			aDefendu = true;
			for(int dir = 0; dir < 4; dir++) {
				int x = ennemis[j].ligne + DX[dir];
				int y = ennemis[j].colonne + DY[dir];
				vector<pair<bool, direction>> way = Chemin(agents[i], {x, y});
				if(x<0 or x>24 or y<0 or y>24)continue;
				if(D[x][y] <= 3) {
					mini = D[x][y];
					coups = way;
					if(dir == 0)poussage = OUEST;
					else if(dir == 1)poussage = NORD;
					else if(dir == 2)poussage = EST;
					else poussage = SUD;
				}
				else if(D[x][y] != +oo) {
					if(mini > D[x][y]) {
						mini = D[x][y];
						coups = way;
					}
				}
			}
			
		}
	}
	int pa = 0;
	int j = 0;
	while(pa < 8 and j < min(8, (int)coups.size())){
		if(coups[j].first and pa + 3 > 8) {
			pa = 9;
			break;
		}
		if(!coups[j].first) deplacer(i, coups[j].second), pa++;
		else glisser(i, coups[j].second), pa += 3;
		j++;
	}
	if(pa <= 3) pousser(i, poussage);
	if(!aDefendu) attaquer(i);
}*/

//defense v2
/*
void defendre(int i) {
	if(alien_sur_case(agents[i])) return;
	bool aDefendu = false;
	int mini = +oo;
	int maxi = 0;
	direction poussage = NORD;
	vector<pair<bool, direction>> coups;
	for(int j = 0; j < 4; j++){
		if(alien_sur_case(ennemis[j])) {
			aDefendu = true;
			for(int dir = 0; dir < 4; dir++) {
				int x = ennemis[j].ligne + DX[dir];
				int y = ennemis[j].colonne + DY[dir];
				vector<pair<bool, direction>> way = Chemin(agents[i], {x, y});
				if(x<0 or x>24 or y<0 or y>24)continue;
				if(D[x][y] <= 3) {
					if(info_alien(ennemis[j]).points_capture > maxi) {
						maxi = info_alien(ennemis[j]).points_capture;
						mini = D[x][y];
						coups = way;
						if(dir == 0)poussage = OUEST;
						else if(dir == 1)poussage = NORD;
						else if(dir == 2)poussage = EST;
						else poussage = SUD;
					}
				}
				else if(D[x][y] != +oo) {
					if(mini > D[x][y] and maxi < info_alien(ennemis[j]).points_capture) {
						maxi = info_alien(ennemis[j]).points_capture;
						mini = D[x][y];
						coups = way;
					}
				}
			}
			
		}
	}
	int pa = 0;
	int j = 0;
	while(pa < 8 and j < min(8, (int)coups.size())){
		if(coups[j].first and pa + 3 > 8) {
			pa = 9;
			break;
		}
		if(!coups[j].first) deplacer(i, coups[j].second), pa++;
		else glisser(i, coups[j].second), pa += 3;
		j++;
	}
	if(pa <= 3) pousser(i, poussage);
	if(!aDefendu) attaquer(i);
	actualiser();
}*/

void attaquerDefendre(int i) {
	if(alien_sur_case(agents[i])) return;
	bool aDefendu = false;
	int mini = +oo;
	int maxi = 0;
	direction poussage = NORD;
	vector<pair<bool, direction>> coups;
	for(int j = 0; j < 4; j++){
		if(alien_sur_case(ennemis[j])) {
			aDefendu = true;
			for(int dir = 0; dir < 4; dir++) {
				int x = ennemis[j].ligne + DX[dir];
				int y = ennemis[j].colonne + DY[dir];
				vector<pair<bool, direction>> way = Chemin(agents[i], {x, y});
				if(x<0 or x>24 or y<0 or y>24)continue;
				if(D[x][y] <= 3) {
					if(info_alien(ennemis[j]).points_capture > maxi) {
						maxi = info_alien(ennemis[j]).points_capture;
						mini = D[x][y];
						coups = way;
						if(dir == 0)poussage = OUEST;
						else if(dir == 1)poussage = NORD;
						else if(dir == 2)poussage = EST;
						else poussage = SUD;
					}
				}
				else if(D[x][y] != +oo) {
					if(mini > D[x][y] and maxi < info_alien(ennemis[j]).points_capture) {
						maxi = info_alien(ennemis[j]).points_capture;
						mini = D[x][y];
						coups = way;
					}
				}
			}
			
		}
	}
	int maxi2 = 0;
	vector<pair<bool, direction>> coups2;
	bool finissable = 0;
	for(position alien : aliens) {
		vector<pair<bool, direction>> way = Chemin(agents[i], alien);
		if(D[alien.ligne][alien.colonne] < 9) {
			if(info_alien(alien).points_capture > maxi2) {
				maxi2 = info_alien(alien).points_capture;
				coups2 = way;
				finissable = 1;
			}
		}
		else if(way.size() > 0 and coups.size() == 0) {
			if(!finissable and info_alien(alien).points_capture > maxi2) {
				coups2 = way;
				maxi2 = info_alien(alien).points_capture;
			}
		}
	}
	if((maxi2 < maxi + 10 and aDefendu and mini <= 3) or maxi > maxi2 + 4) {
		int pa = 0;
		int j = 0;
		while(pa < 8 and j < min(8, (int)coups.size())){
			if(coups[j].first and pa + 3 > 8) {
				pa = 9;
				break;
			}
			if(!coups[j].first) deplacer(i, coups[j].second), pa++;
			else glisser(i, coups[j].second), pa += 3;
			j++;
		}
		if(pa <= 3) pousser(i, poussage);
		if(!aDefendu) attaquer(i);
		actualiser();
	}
	else {
		int pa = 0;
		int j = 0;
		while(pa < 8 and j < min(8, (int)coups2.size())){
			if(coups2[j].first and pa + 3 > 8) break;
			if(!coups2[j].first) deplacer(i, coups2[j].second), pa++;
			else glisser(i, coups2[j].second), pa += 3;
			j++;
		}
		actualiser();
	}
}

/*void jouer_tour() {
	actualiser();
	
	// attaquants
	for(int i = 0; i < 2; i++)
		attaquer(i);
	
	// defenseurs
	for(int i = 2; i < 4; i++)
		defendre(i);
	
	TOUR++;
}*/

void jouer_tour() {
	actualiser();
	
	for(int i = 0; i < 4; i++)
		attaquerDefendre(i);
	
	TOUR++;
}

//appelee a la fin de la partie
void partie_fin() {
	
}

int main() {
	cout << 42 << endl;
	
	return 0;
}

















































