# coding: utf-8
"""Voici 'yagi', mon champion pour le sujet finale de prologin 2018, 'Penguin in Black'.

Le principe du jeu est de gagner le plus possible des points de capture.
On peut atteindre ce but en
- capturant des alienes, duh
    - en fait il faut faire attention a la signe du point de capture,
      parce que il peut y avoir des alienes avec un point de capture negatif :D
- defendant des agents allies qui sont en train de capturer des alienes
- empechant l'adversaier de capturer des alienes

J'ai donc cree 3 modes pour les actions des agents:
- capture -> drapeau vert
- defense -> drapeau bleu
- attaque -> drapeau rouge
// nice alignment

Dans le mode capture, pour chaque agent on itere sur tous les cible alienes possibles,
et on associe un score a chaque cible qui prend en compte la distance et les points rapportes.

Le mode defense cherche des points faibles, c'est-a-dire des directions non-proteges dans
lesquelles les agents sont risquee d'etre pousses. Nous cherchons doncs d'abord des cases
adjacents libres (ou occupees par l'adversaier) des agents allies qui sont en train de capturer,
et associe a chaqu'une un score en prenant compte de la distance et le point de capture protege d'aliene.

Le mode attaque cherche des points faibles de l'adversaire et essaie d'empecher le capture,
ou bien simplement interrompre son trajectoire.

Pour trouver la meilleure action pour chaque agent a chaque tour, on itere sur tous les actions possibles
et compare leurs scores: il s'agit d'un algorithme glouton, c.f. find_target.

J'ai entendu des autres implementer un algorithme de Dijkstra pour utiliser les glissades,
par contre je n'arrivais pas a realiser une version assez rapide qui ne depasse pas la limite du temps.
J'avais essaye d'implementer un BFS avec un profondeur limite, par contre ca a l'air d'etre moins performant.

En se rendant compte que le glissade n'est pas a ma disposition, j'ai essaye d'utiliser l'action pousser tres tot.
(D'ailleurs c'est pour ca que je suis arrive 17eme dans le 2eme tounois)
Par contre, mon mecanisme d'attaque et de defense en utilisant l'action pousser est assez arbitrarire,
c'est-a-dire les agents essaient de pousser dans toutes les directions des possible.
J'ai essaye de realiser un mecanisme plus systematique mais c'etait trop bugge.

Puisque c'est ma premiere finale, cette fois-ci je trouve j'aurais pu faire beaucoup plus de choses mieux.
Si j'avais le temps, j'aurais aime
- ressayer de mettre en place l'action glisser avec l'algorithme de dijkstra
- utiliser les drapeaux pour mieux comprendre comment fonction mon champion (= debugger)
- communiquer avec d'autres participants pour connaitre mieux leurs strategies
- analyser d'une maniere plus detaille pourquoi mon code devient de moins en moins performant avec des nouveaux
  strategies
- utiliser git plus efficacement, committer plus frequemment afin que je puisse retourner aux versions precedentes
"""

from api import *
from collections import defaultdict
from time import process_time
from random import choice

# Global constants
aliens_on_wave = defaultdict(list)

NUMBER_WAVES_AHEAD = 1
DISTANCE_COEFFICIENT = 0.9
AGGRESSION_BIAS = 2

SAFETY_COEFFICIENT = 0.9

agent_targets = {agent_id: None for agent_id in range(4)}
agent_modes = {agent_id: None for agent_id in range(4)}
prev_agent_positions = {agent_id: None for agent_id in range(4)}


def init_aliens_on_wave():
    for alien in liste_aliens():
        # Discard aliens with negative awards
        if alien.points_capture <= 0:
            continue
        # TODO avoid them
        for wave in range(alien.tour_invasion - NUMBER_WAVES_AHEAD, alien.tour_invasion + alien.duree_invasion):
            aliens_on_wave[wave].append(alien)


def is_case_empty(pos):
    return type_case(pos) == case_type.LIBRE and agent_sur_case(pos) == -1


def get_shortest_path(start_pos, end_pos):
    return chemin(start_pos, end_pos)


def vulnerabilities_of(pos):
    r, c = pos

    hor_adjs = [(r, c - 1), (r, c + 1)]
    ver_adjs = [(r - 1, c), (r + 1, c)]

    vulnerabilities = []

    # This is used for target selection only.
    # Therefore, no need to take into account ally agents adjacent to the target.
    if all([is_case_empty(pos) for pos in hor_adjs]):
        vulnerabilities += hor_adjs
    if all([is_case_empty(pos) for pos in ver_adjs]):
        vulnerabilities += ver_adjs

    return vulnerabilities


def glide_dist_dest(start_pos, dir_, return_obstacle_pos=True):
    r, c = start_pos
    distance = -1
    # Get obstacle position
    while is_case_empty((r, c)) or distance == -1:
        distance += 1
        if dir_ == direction.NORD:
            r -= 1
        if dir_ == direction.SUD:
            r += 1
        if dir_ == direction.OUEST:
            c -= 1
        if dir_ == direction.EST:
            c += 1
    if return_obstacle_pos:
        return distance, (r, c)

    # Shift by 1 to get destination position
    if dir_ == direction.NORD:
        r += 1
    if dir_ == direction.SUD:
        r -= 1
    if dir_ == direction.OUEST:
        c += 1
    if dir_ == direction.EST:
        c -= 1
    return distance, (r, c)


def dist(start_pos, end_pos):
    path = chemin(start_pos, end_pos)
    # TODO implement gliding
    # prev_dir = None
    # prev_dir_cnt = 0
    # for dir_ in path:
    #     prev_dir
    if path:
        return len(path)
    else:
        return float('inf')


def find_target(agent_id):
    start_pos = position_agent(moi(), agent_id)
    start = process_time()

    best_score = -float('inf')
    best_target = None
    best_mode = debug_drapeau.AUCUN_DRAPEAU

    best_alien = None

    # Alien target
    for alien in aliens_on_wave[tour_actuel()]:
        # --DEBUG
        debug_afficher_drapeau(alien.pos, debug_drapeau.DRAPEAU_VERT)
        vulnerabilities_cnt = len(vulnerabilities_of(alien.pos))
        score = alien.points_capture \
                * (DISTANCE_COEFFICIENT ** (dist(start_pos, alien.pos) - 8)) \
                * (SAFETY_COEFFICIENT ** (3 - vulnerabilities_cnt))
        if best_score < score:
            best_score = score
            best_target = alien.pos
            best_mode = debug_drapeau.DRAPEAU_VERT
            best_alien = alien

    if process_time() - start > 0.24:
        print("TIME OUT")
        return best_target, best_mode

    # Enemy agent target
    for enemy_agent_id in range(4):
        enemy_agent_pos = position_agent(adversaire(), enemy_agent_id)
        for vulnerability in vulnerabilities_of(enemy_agent_pos):
            # --DEBUG
            debug_afficher_drapeau(vulnerability, debug_drapeau.DRAPEAU_ROUGE)
            saved_points = 0
            if alien_sur_case(enemy_agent_pos):
                saved_points = \
                    info_alien(enemy_agent_pos).points_capture \
                    * (DISTANCE_COEFFICIENT ** (dist(start_pos, vulnerability) - (NB_POINTS_ACTION - COUT_POUSSER)))

            score = saved_points + AGGRESSION_BIAS
            if best_score < score:
                best_score = score
                best_target = vulnerability
                best_mode = debug_drapeau.DRAPEAU_ROUGE

                best_alien = None

    if process_time() - start > 0.24:
        print("TIME OUT")
        return best_target, best_mode

    # Protect ally
    self_vulnerabilities = get_team_vulnerabilities()  # Quite some bugs here
    for vulnerabilities in self_vulnerabilities.values():
        for vulnerability in vulnerabilities:
            # --DEBUG
            debug_afficher_drapeau(vulnerability, debug_drapeau.DRAPEAU_BLEU)
    for agent2_id in range(4):
        if agent_id == agent2_id:
            continue
        agent2_pos = position_agent(moi(), agent2_id)
        if not alien_sur_case(agent2_pos):
            continue
        alien = info_alien(agent2_pos)
        for vulnerability in self_vulnerabilities[agent2_id]:
            score = alien.points_capture \
                    * (DISTANCE_COEFFICIENT ** (dist(start_pos, vulnerability) - 0)) \
                    * (SAFETY_COEFFICIENT ** (3 - len(self_vulnerabilities[agent2_id]) - 2))
            if best_score < score:
                best_score = score
                best_target = vulnerability
                best_mode = debug_drapeau.DRAPEAU_BLEU
                best_alien = None

    if process_time() - start > 0.24:
        print("TIME OUT")
        return best_target, best_mode

    if best_alien is not None:
        for wave in range(best_alien.tour_invasion - NUMBER_WAVES_AHEAD,
                          best_alien.tour_invasion + best_alien.duree_invasion):
            aliens_on_wave[wave].remove(best_alien)
    return best_target, best_mode


def get_opposite_direction(dir_):
    return {
        direction.NORD: direction.SUD,
        direction.SUD: direction.NORD,
        direction.OUEST: direction.EST,
        direction.EST: direction.OUEST,
    }[dir_]


def counter_attack():
    global SAFETY_COEFFICIENT
    # Reset target and mode if kicked
    for agent_id in range(4):
        if prev_agent_positions[agent_id] != position_agent(moi(), agent_id):
            agent_modes[agent_id] = None
            agent_targets[agent_id] = None

    for action in historique():
        if action.atype == action_type.ACTION_POUSSER:
            # Emphasize safety
            # if SAFETY_COEFFICIENT >= .9:
            #     SAFETY_COEFFICIENT *= .99
            target_pos = position_agent(adversaire(), action.id_agent)
            target_capturing = alien_sur_case(target_pos)

            # Victim will be regarded as an obstacle
            distance, victim_pos = glide_dist_dest(target_pos, action.dir, return_obstacle_pos=True)
            direction_counterattack = get_opposite_direction(action.dir)

            # Check if attacker is still in range
            if agent_sur_case(victim_pos) == moi():
                for agent_id in range(4):
                    if position_agent(moi(), agent_id) == victim_pos:
                        if distance * COUT_DEPLACEMENT >= COUT_GLISSADE:
                            glisser(agent_id, direction_counterattack)
                            # doesn't glide back when opponent moves ...
                        else:
                            [deplacer(agent_id, direction_counterattack)] * distance
                        if target_capturing:
                            pousser(agent_id, direction_counterattack)
                        break


def get_team_vulnerabilities():
    self_vulnerabilities = {agent_id: [] for agent_id in range(4)}
    for agent_id in range(4):
        agent_pos = position_agent(moi(), agent_id)
        if alien_sur_case(agent_pos):
            self_vulnerabilities[agent_id] = vulnerabilities_of(agent_pos)
    return self_vulnerabilities


def clear_flags():
    for r in range(TAILLE_BANQUISE):
        for c in range(TAILLE_BANQUISE):
            debug_afficher_drapeau((r, c), debug_drapeau.AUCUN_DRAPEAU)


########################################################################################################################
def partie_init():
    """Fonction appelée au début de la partie.

    """
    init_aliens_on_wave()


########################################################################################################################
def jouer_tour():
    """Fonction applee a chaque tour

    """
    start = process_time()
    clear_flags()

    if process_time() - start > 0.9:
        return

    # Attacks
    counter_attack()
    for agent_id in range(4):
        i, j = position_agent(moi(), agent_id)
        if True:  # if agent_modes[agent_id] == debug_drapeau.DRAPEAU_ROUGE:
            # Randomly pushing opponents seems to be a good strategy
            for direction_, adj_pos in [(direction.NORD, (i - 1, j)), (direction.SUD, (i + 1, j)),
                                        (direction.OUEST, (i, j - 1)), (direction.EST, (i, j + 1))]:
                id_player = agent_sur_case(adj_pos)
                if id_player == adversaire():
                    if pousser(agent_id, direction_) == erreur.OK:
                        break

        # Capturing / Protecting
        # Although (i, j) == agent_targets[agent_id] is supposed to be checked,
        # it leads to weird behaviour and not checking it seems to be more effective
        if alien_sur_case((i, j)):
            continue
        if any([alien_sur_case(adj_pos) and agent_sur_case(adj_pos) == moi() for adj_pos in
                [(i - 1, j), (i + 1, j), (i, j - 1), (i, j + 1)]]):
            continue
        if agent_modes[agent_id] in (debug_drapeau.DRAPEAU_ROUGE, debug_drapeau.DRAPEAU_VERT):
            agent_targets[agent_id] = None
            agent_modes[agent_id] = None

        # Find alien / enemy agent / ally agent target
        if agent_targets[agent_id] is None:
            agent_targets[agent_id], agent_modes[agent_id] = find_target(agent_id)

        # Idle
        if agent_targets[agent_id] is None:
            print("IDLE!")
            choice([
                action(agent_id, dir_)
                for action, dir_ in zip(
                    (glisser, deplacer),
                    (direction.NORD, direction.SUD, direction.OUEST, direction.EST)
                )
            ])()
            continue
        path = get_shortest_path((i, j), agent_targets[agent_id])
        while points_action_agent(agent_id):
            if not path:
                # if agent_modes[agent_id] == debug_drapeau.DRAPEAU_ROUGE:
                if True:
                    i, j = position_agent(moi(), agent_id)
                    for direction_, adj_pos in [(direction.NORD, (i - 1, j)), (direction.SUD, (i + 1, j)),
                                                (direction.OUEST, (i, j - 1)), (direction.EST, (i, j + 1))]:
                        if agent_sur_case(adj_pos) == adversaire():
                            if pousser(agent_id, direction_) == erreur.OK:
                                break
                    agent_targets[agent_id] = None
                    agent_modes[agent_id] = None
                break
            deplacer(agent_id, path.pop(0))

    global prev_agent_positions
    prev_agent_positions = {agent_id: position_agent(moi(), agent_id) for agent_id in range(4)}


########################################################################################################################
def partie_fin():
    pass
