{-# LANGUAGE ForeignFunctionInterface #-}
{-# LANGUAGE TypeFamilies #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE UndecidableInstances #-}

{-# OPTIONS_HADDOCK hide #-}

-- This file has been generated, if you wish to
-- modify it in a permanent way, please refer
-- to the script file : gen/generator_haskell.rb

module CApi where

import Data.List (foldl')
import Foreign
import Foreign.C.Types

import Foreign.Marshal.Array

#include "interface_c.hh"

class ApiStorable a where
  type ApiStorableType a
  toStorable :: a -> (ApiStorableType a -> IO b) -> IO b
  unStorable :: ApiStorableType a -> IO a
  type ApiStorableBaseType a
  toStorableBase :: a -> (ApiStorableBaseType a -> IO b) -> IO b
  unStorableBase :: ApiStorableBaseType a -> IO a

instance ApiStorable () where
  type ApiStorableType () = ()
  toStorable () f = f ()
  {-# INLINE toStorable #-}
  unStorable _ = return ()
  {-# INLINE unStorable #-}
  type ApiStorableBaseType () = ()
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Int where
  type ApiStorableType Int = CInt
  toStorable x f = f (fromIntegral x)
  {-# INLINE toStorable #-}
  unStorable = return . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Int = ApiStorableType Int
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Bool where
  type ApiStorableType Bool = CBool
  toStorable x f = f ((\bx -> if bx then 1 else 0) x)
  {-# INLINE toStorable #-}
  unStorable = return . (/= 0)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Bool = ApiStorableType Bool
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Double where
  type ApiStorableType Double = CDouble
  toStorable x f = f (CDouble x)
  {-# INLINE toStorable #-}
  unStorable = return . (\(CDouble x) -> x)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Double = ApiStorableType Double
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types de cases
data Case_type =
    Libre -- ^ Case libre, qui peut abriter une corde et des nains (standard) 
  | Granite -- ^ Granite (standard), qui peut cacher du minerai 
  | Obsidienne -- ^ Obsidienne 
  | Erreur_case -- ^ Erreur 
  deriving(Show, Eq, Enum)
type CCase_type = CInt

instance ApiStorable Case_type where
  type ApiStorableType Case_type = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Case_type = ApiStorableType Case_type
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Direction
data Direction =
    Haut -- ^ Direction : haut 
  | Bas -- ^ Direction : bas 
  | Gauche -- ^ Direction : gauche 
  | Droite -- ^ Direction : droite 
  | Erreur_direction -- ^ Erreur 
  deriving(Show, Eq, Enum)
type CDirection = CInt

instance ApiStorable Direction where
  type ApiStorableType Direction = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Direction = ApiStorableType Direction
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Erreurs possibles
data Erreur =
    Ok -- ^ L'action s'est effectuée avec succès. 
  | Pa_insuffisants -- ^ Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action. 
  | Pm_insuffisants -- ^ Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement. 
  | Hors_limites -- ^ L'action est en dehors des limites de la mine. 
  | Direction_invalide -- ^ La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action. 
  | Id_nain_invalide -- ^ Le nain (standard) spécifié n'existe pas. 
  | Obstacle_mur -- ^ La position spécifiée est un mur. 
  | Obstacle_nain -- ^ La position spécifiée est un nain (standard) adverse. 
  | Obstacle_corde -- ^ Il y a déjà une corde dans la direction spécifiée. 
  | Pas_de_cible -- ^ Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée. 
  | Nain_mort -- ^ Le nain (standard) spécifié est mort. 
  | Pas_accroche -- ^ Le nain (standard) n'est pas accroché. 
  | Deja_accroche -- ^ Le nain (standard) est déjà accroché. 
  | Pas_de_corde -- ^ Il n'y a pas de corde dans la direction spécifiée. 
  | Drapeau_invalide -- ^ Le drapeau spécifié n'existe pas. 
  deriving(Show, Eq, Enum)
type CErreur = CInt

instance ApiStorable Erreur where
  type ApiStorableType Erreur = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Erreur = ApiStorableType Erreur
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types d'actions
data Action_type =
    Action_deplacer -- ^ Action ``deplacer`` 
  | Action_lacher -- ^ Action ``lacher`` 
  | Action_miner -- ^ Action ``miner`` 
  | Action_poser_corde -- ^ Action ``poser_corde`` 
  | Action_tirer -- ^ Action ``tirer`` 
  | Action_agripper -- ^ Action ``agripper`` 
  deriving(Show, Eq, Enum)
type CAction_type = CInt

instance ApiStorable Action_type where
  type ApiStorableType Action_type = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Action_type = ApiStorableType Action_type
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types de drapeaux de débug
data Debug_drapeau =
    Aucun_drapeau -- ^ Aucun drapeau, enlève le drapeau présent 
  | Drapeau_bleu -- ^ Drapeau bleu 
  | Drapeau_vert -- ^ Drapeau vert 
  | Drapeau_rouge -- ^ Drapeau rouge 
  deriving(Show, Eq, Enum)
type CDebug_drapeau = CInt

instance ApiStorable Debug_drapeau where
  type ApiStorableType Debug_drapeau = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Debug_drapeau = ApiStorableType Debug_drapeau
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Position dans la mine, donnée par deux coordonnées.
data Position = Position Int Int
  deriving(Show, Eq)
data CPosition = CPosition CInt CInt
instance Storable CPosition where
  sizeOf    _ = (#size position)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aligne <- (#peek position, ligne) ptr
    acolonne <- (#peek position, colonne) ptr
    return $ CPosition aligne acolonne
  {-# INLINE peek #-}
  poke ptr (CPosition aligne acolonne) = do
    (#poke position, ligne) ptr aligne
    (#poke position, colonne) ptr acolonne
  {-# INLINE poke #-}
instance ApiStorable Position where
  type ApiStorableType Position = Ptr CPosition
  toStorable (Position aligne acolonne) f = toStorableBase aligne $ \aligne' ->  toStorableBase acolonne $ \acolonne' ->  do
    alloca $ \ptr -> do
      poke ptr $ CPosition aligne' acolonne'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CPosition aligne' acolonne') <- peek ptr
    aligne <- unStorableBase aligne'
    acolonne <- unStorableBase acolonne'
    return $ Position aligne acolonne
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Position = CPosition
  toStorableBase (Position aligne acolonne) f =
    toStorableBase aligne $ \aligne' ->  toStorableBase acolonne $ \acolonne' ->  f (CPosition aligne' acolonne')
  {-# INLINE toStorableBase #-}
  unStorableBase (CPosition aligne' acolonne') = do
    aligne <- unStorableBase aligne'
    acolonne <- unStorableBase acolonne'
    return $ Position aligne acolonne
  {-# INLINE unStorableBase #-}
-- | Minerai à récolter
data Minerai = Minerai {
      resistance :: Int -- ^ Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse
  ,   rendement :: Int -- ^ Valeur marchande du bloc de minerai
}
  deriving(Show, Eq)
data CMinerai = CMinerai {
      cresistance :: CInt -- ^ Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse
  ,   crendement :: CInt -- ^ Valeur marchande du bloc de minerai
}
instance Storable CMinerai where
  sizeOf    _ = (#size minerai)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aresistance <- (#peek minerai, resistance) ptr
    arendement <- (#peek minerai, rendement) ptr
    return $ CMinerai aresistance arendement
  {-# INLINE peek #-}
  poke ptr (CMinerai aresistance arendement) = do
    (#poke minerai, resistance) ptr aresistance
    (#poke minerai, rendement) ptr arendement
  {-# INLINE poke #-}
instance ApiStorable Minerai where
  type ApiStorableType Minerai = Ptr CMinerai
  toStorable (Minerai aresistance arendement) f = toStorableBase aresistance $ \aresistance' ->  toStorableBase arendement $ \arendement' ->  do
    alloca $ \ptr -> do
      poke ptr $ CMinerai aresistance' arendement'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CMinerai aresistance' arendement') <- peek ptr
    aresistance <- unStorableBase aresistance'
    arendement <- unStorableBase arendement'
    return $ Minerai aresistance arendement
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Minerai = CMinerai
  toStorableBase (Minerai aresistance arendement) f =
    toStorableBase aresistance $ \aresistance' ->  toStorableBase arendement $ \arendement' ->  f (CMinerai aresistance' arendement')
  {-# INLINE toStorableBase #-}
  unStorableBase (CMinerai aresistance' arendement') = do
    aresistance <- unStorableBase aresistance'
    arendement <- unStorableBase arendement'
    return $ Minerai aresistance arendement
  {-# INLINE unStorableBase #-}
-- | Nain (standard)
data Nain = Nain {
      pos :: Position -- ^ Position actuelle du nain (standard)
  ,   vie :: Int -- ^ Point(s) de vie restant du nain (standard)
  ,   pa :: Int -- ^ Point(s) d'action restant du nain (standard)
  ,   pm :: Int -- ^ Point(s) de déplacement restant du nain (standard)
  ,   accroche :: Bool -- ^ Le nain (standard) est accroché à la paroi ou à une corde
  ,   butin :: Int -- ^ Valeur marchande totale que le nain (standard) possède
}
  deriving(Show, Eq)
data CNain = CNain {
      cpos :: CPosition -- ^ Position actuelle du nain (standard)
  ,   cvie :: CInt -- ^ Point(s) de vie restant du nain (standard)
  ,   cpa :: CInt -- ^ Point(s) d'action restant du nain (standard)
  ,   cpm :: CInt -- ^ Point(s) de déplacement restant du nain (standard)
  ,   caccroche :: CBool -- ^ Le nain (standard) est accroché à la paroi ou à une corde
  ,   cbutin :: CInt -- ^ Valeur marchande totale que le nain (standard) possède
}
instance Storable CNain where
  sizeOf    _ = (#size nain)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    apos <- (#peek nain, pos) ptr
    avie <- (#peek nain, vie) ptr
    apa <- (#peek nain, pa) ptr
    apm <- (#peek nain, pm) ptr
    aaccroche <- (#peek nain, accroche) ptr
    abutin <- (#peek nain, butin) ptr
    return $ CNain apos avie apa apm aaccroche abutin
  {-# INLINE peek #-}
  poke ptr (CNain apos avie apa apm aaccroche abutin) = do
    (#poke nain, pos) ptr apos
    (#poke nain, vie) ptr avie
    (#poke nain, pa) ptr apa
    (#poke nain, pm) ptr apm
    (#poke nain, accroche) ptr aaccroche
    (#poke nain, butin) ptr abutin
  {-# INLINE poke #-}
instance ApiStorable Nain where
  type ApiStorableType Nain = Ptr CNain
  toStorable (Nain apos avie apa apm aaccroche abutin) f = toStorableBase apos $ \apos' ->  toStorableBase avie $ \avie' ->  toStorableBase apa $ \apa' ->  toStorableBase apm $ \apm' ->  toStorableBase aaccroche $ \aaccroche' ->  toStorableBase abutin $ \abutin' ->  do
    alloca $ \ptr -> do
      poke ptr $ CNain apos' avie' apa' apm' aaccroche' abutin'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CNain apos' avie' apa' apm' aaccroche' abutin') <- peek ptr
    apos <- unStorableBase apos'
    avie <- unStorableBase avie'
    apa <- unStorableBase apa'
    apm <- unStorableBase apm'
    aaccroche <- unStorableBase aaccroche'
    abutin <- unStorableBase abutin'
    return $ Nain apos avie apa apm aaccroche abutin
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Nain = CNain
  toStorableBase (Nain apos avie apa apm aaccroche abutin) f =
    toStorableBase apos $ \apos' ->  toStorableBase avie $ \avie' ->  toStorableBase apa $ \apa' ->  toStorableBase apm $ \apm' ->  toStorableBase aaccroche $ \aaccroche' ->  toStorableBase abutin $ \abutin' ->  f (CNain apos' avie' apa' apm' aaccroche' abutin')
  {-# INLINE toStorableBase #-}
  unStorableBase (CNain apos' avie' apa' apm' aaccroche' abutin') = do
    apos <- unStorableBase apos'
    avie <- unStorableBase avie'
    apa <- unStorableBase apa'
    apm <- unStorableBase apm'
    aaccroche <- unStorableBase aaccroche'
    abutin <- unStorableBase abutin'
    return $ Nain apos avie apa apm aaccroche abutin
  {-# INLINE unStorableBase #-}
-- | Action de déplacement représentée dans l'historique.
data Action_hist = Action_hist {
      atype :: Action_type -- ^ Type de l'action
  ,   id_nain :: Int -- ^ Numéro du nain (standard) concerné par l'action
  ,   dir :: Direction -- ^ Direction visée par le nain (standard) durant le déplacement
  ,   sens :: Direction -- ^ Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche.
}
  deriving(Show, Eq)
data CAction_hist = CAction_hist {
      catype :: CAction_type -- ^ Type de l'action
  ,   cid_nain :: CInt -- ^ Numéro du nain (standard) concerné par l'action
  ,   cdir :: CDirection -- ^ Direction visée par le nain (standard) durant le déplacement
  ,   csens :: CDirection -- ^ Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche.
}
instance Storable CAction_hist where
  sizeOf    _ = (#size action_hist)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aatype <- (#peek action_hist, atype) ptr
    aid_nain <- (#peek action_hist, id_nain) ptr
    adir <- (#peek action_hist, dir) ptr
    asens <- (#peek action_hist, sens) ptr
    return $ CAction_hist aatype aid_nain adir asens
  {-# INLINE peek #-}
  poke ptr (CAction_hist aatype aid_nain adir asens) = do
    (#poke action_hist, atype) ptr aatype
    (#poke action_hist, id_nain) ptr aid_nain
    (#poke action_hist, dir) ptr adir
    (#poke action_hist, sens) ptr asens
  {-# INLINE poke #-}
instance ApiStorable Action_hist where
  type ApiStorableType Action_hist = Ptr CAction_hist
  toStorable (Action_hist aatype aid_nain adir asens) f = toStorableBase aatype $ \aatype' ->  toStorableBase aid_nain $ \aid_nain' ->  toStorableBase adir $ \adir' ->  toStorableBase asens $ \asens' ->  do
    alloca $ \ptr -> do
      poke ptr $ CAction_hist aatype' aid_nain' adir' asens'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CAction_hist aatype' aid_nain' adir' asens') <- peek ptr
    aatype <- unStorableBase aatype'
    aid_nain <- unStorableBase aid_nain'
    adir <- unStorableBase adir'
    asens <- unStorableBase asens'
    return $ Action_hist aatype aid_nain adir asens
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Action_hist = CAction_hist
  toStorableBase (Action_hist aatype aid_nain adir asens) f =
    toStorableBase aatype $ \aatype' ->  toStorableBase aid_nain $ \aid_nain' ->  toStorableBase adir $ \adir' ->  toStorableBase asens $ \asens' ->  f (CAction_hist aatype' aid_nain' adir' asens')
  {-# INLINE toStorableBase #-}
  unStorableBase (CAction_hist aatype' aid_nain' adir' asens') = do
    aatype <- unStorableBase aatype'
    aid_nain <- unStorableBase aid_nain'
    adir <- unStorableBase adir'
    asens <- unStorableBase asens'
    return $ Action_hist aatype aid_nain adir asens
  {-# INLINE unStorableBase #-}
data CDirection_array = CDirection_array { cDirection_arrayPtr :: Ptr CDirection, cDirection_arraySize :: CSize }

instance Storable CDirection_array where
  sizeOf    _ = (#size direction_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek direction_array, length) ptr
    datas <- (#peek direction_array, datas) ptr
    return $ CDirection_array datas length
  {-# INLINE peek #-}
  poke ptr (CDirection_array datas length) = do
    (#poke direction_array, length) ptr length
    (#poke direction_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Direction] where
  type ApiStorableType [Direction] = Ptr CDirection_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CDirection_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Direction] = CDirection_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CDirection_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CDirection_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
data CPosition_array = CPosition_array { cPosition_arrayPtr :: Ptr CPosition, cPosition_arraySize :: CSize }

instance Storable CPosition_array where
  sizeOf    _ = (#size position_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek position_array, length) ptr
    datas <- (#peek position_array, datas) ptr
    return $ CPosition_array datas length
  {-# INLINE peek #-}
  poke ptr (CPosition_array datas length) = do
    (#poke position_array, length) ptr length
    (#poke position_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Position] where
  type ApiStorableType [Position] = Ptr CPosition_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CPosition_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Position] = CPosition_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CPosition_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CPosition_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
data CAction_hist_array = CAction_hist_array { cAction_hist_arrayPtr :: Ptr CAction_hist, cAction_hist_arraySize :: CSize }

instance Storable CAction_hist_array where
  sizeOf    _ = (#size action_hist_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek action_hist_array, length) ptr
    datas <- (#peek action_hist_array, datas) ptr
    return $ CAction_hist_array datas length
  {-# INLINE peek #-}
  poke ptr (CAction_hist_array datas length) = do
    (#poke action_hist_array, length) ptr length
    (#poke action_hist_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Action_hist] where
  type ApiStorableType [Action_hist] = Ptr CAction_hist_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CAction_hist_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Action_hist] = CAction_hist_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CAction_hist_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CAction_hist_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
-- | Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
chemin :: Position ->  Position -> IO [Direction]
chemin pos1 pos2 = toStorable pos1 $ \pos1' ->  toStorable pos2 $ \pos2' ->  (hs_chemin pos1' pos2') >>= unStorable

foreign import ccall
  hs_chemin :: (ApiStorableType Position) -> (ApiStorableType Position) ->  IO (ApiStorableType [Direction])
-- | Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
deplacer :: Int ->  Direction -> IO Erreur
deplacer id_nain dir = toStorable id_nain $ \id_nain' ->  toStorable dir $ \dir' ->  (hs_deplacer id_nain' dir') >>= unStorable

foreign import ccall
  hs_deplacer :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Le nain (standard) ``id_nain`` lâche la paroi.
lacher :: Int -> IO Erreur
lacher id_nain = toStorable id_nain $ \id_nain' ->  (hs_lacher id_nain') >>= unStorable

foreign import ccall
  hs_lacher :: (ApiStorableType Int) ->  IO (ApiStorableType Erreur)
-- | Le nain (standard) ``id_nain`` s'agrippe à la paroi.
agripper :: Int -> IO Erreur
agripper id_nain = toStorable id_nain $ \id_nain' ->  (hs_agripper id_nain') >>= unStorable

foreign import ccall
  hs_agripper :: (ApiStorableType Int) ->  IO (ApiStorableType Erreur)
-- | Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
miner :: Int ->  Direction -> IO Erreur
miner id_nain dir = toStorable id_nain $ \id_nain' ->  toStorable dir $ \dir' ->  (hs_miner id_nain' dir') >>= unStorable

foreign import ccall
  hs_miner :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
tirer :: Int ->  Direction ->  Direction -> IO Erreur
tirer id_nain dir_corde sens = toStorable id_nain $ \id_nain' ->  toStorable dir_corde $ \dir_corde' ->  toStorable sens $ \sens' ->  (hs_tirer id_nain' dir_corde' sens') >>= unStorable

foreign import ccall
  hs_tirer :: (ApiStorableType Int) -> (ApiStorableType Direction) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
poser_corde :: Int ->  Direction -> IO Erreur
poser_corde id_nain dir = toStorable id_nain $ \id_nain' ->  toStorable dir $ \dir' ->  (hs_poser_corde id_nain' dir') >>= unStorable

foreign import ccall
  hs_poser_corde :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Affiche le drapeau spécifié sur la case indiquée.
debug_afficher_drapeau :: Position ->  Debug_drapeau -> IO Erreur
debug_afficher_drapeau pos drapeau = toStorable pos $ \pos' ->  toStorable drapeau $ \drapeau' ->  (hs_debug_afficher_drapeau pos' drapeau') >>= unStorable

foreign import ccall
  hs_debug_afficher_drapeau :: (ApiStorableType Position) -> (ApiStorableType Debug_drapeau) ->  IO (ApiStorableType Erreur)
-- | Renvoie le type d'une case donnée.
type_case :: Position -> IO Case_type
type_case pos = toStorable pos $ \pos' ->  (hs_type_case pos') >>= unStorable

foreign import ccall
  hs_type_case :: (ApiStorableType Position) ->  IO (ApiStorableType Case_type)
-- | Renvoie la liste de toutes les positions occupées par une corde dans la mine.
liste_cordes :: IO [Position]
liste_cordes  =  (hs_liste_cordes ) >>= unStorable

foreign import ccall
  hs_liste_cordes ::  IO (ApiStorableType [Position])
-- | Indique si une corde se trouve sur une case donnée.
corde_sur_case :: Position -> IO Bool
corde_sur_case pos = toStorable pos $ \pos' ->  (hs_corde_sur_case pos') >>= unStorable

foreign import ccall
  hs_corde_sur_case :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
nain_sur_case :: Position -> IO Int
nain_sur_case pos = toStorable pos $ \pos' ->  (hs_nain_sur_case pos') >>= unStorable

foreign import ccall
  hs_nain_sur_case :: (ApiStorableType Position) ->  IO (ApiStorableType Int)
-- | Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
info_nain :: Int ->  Int -> IO Nain
info_nain id_joueur id_nain = toStorable id_joueur $ \id_joueur' ->  toStorable id_nain $ \id_nain' ->  (hs_info_nain id_joueur' id_nain') >>= unStorable

foreign import ccall
  hs_info_nain :: (ApiStorableType Int) -> (ApiStorableType Int) ->  IO (ApiStorableType Nain)
-- | Renvoie la liste de tous les minerais dans la mine.
liste_minerais :: IO [Position]
liste_minerais  =  (hs_liste_minerais ) >>= unStorable

foreign import ccall
  hs_liste_minerais ::  IO (ApiStorableType [Position])
-- | Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
info_minerai :: Position -> IO Minerai
info_minerai pos = toStorable pos $ \pos' ->  (hs_info_minerai pos') >>= unStorable

foreign import ccall
  hs_info_minerai :: (ApiStorableType Position) ->  IO (ApiStorableType Minerai)
-- | Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
cout_de_deplacement :: Int ->  Direction -> IO Int
cout_de_deplacement id_nain dir = toStorable id_nain $ \id_nain' ->  toStorable dir $ \dir' ->  (hs_cout_de_deplacement id_nain' dir') >>= unStorable

foreign import ccall
  hs_cout_de_deplacement :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Int)
-- | Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
position_taverne :: Int -> IO Position
position_taverne id_joueur = toStorable id_joueur $ \id_joueur' ->  (hs_position_taverne id_joueur') >>= unStorable

foreign import ccall
  hs_position_taverne :: (ApiStorableType Int) ->  IO (ApiStorableType Position)
-- | Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
historique :: IO [Action_hist]
historique  =  (hs_historique ) >>= unStorable

foreign import ccall
  hs_historique ::  IO (ApiStorableType [Action_hist])
-- | Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
score :: Int -> IO Int
score id_joueur = toStorable id_joueur $ \id_joueur' ->  (hs_score id_joueur') >>= unStorable

foreign import ccall
  hs_score :: (ApiStorableType Int) ->  IO (ApiStorableType Int)
-- | Renvoie votre numéro de joueur.
moi :: IO Int
moi  =  (hs_moi ) >>= unStorable

foreign import ccall
  hs_moi ::  IO (ApiStorableType Int)
-- | Renvoie le numéro de joueur de votre adversaire.
adversaire :: IO Int
adversaire  =  (hs_adversaire ) >>= unStorable

foreign import ccall
  hs_adversaire ::  IO (ApiStorableType Int)
-- | Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
annuler :: IO Bool
annuler  =  (hs_annuler ) >>= unStorable

foreign import ccall
  hs_annuler ::  IO (ApiStorableType Bool)
-- | Retourne le numéro du tour actuel.
tour_actuel :: IO Int
tour_actuel  =  (hs_tour_actuel ) >>= unStorable

foreign import ccall
  hs_tour_actuel ::  IO (ApiStorableType Int)
-- | Affiche le contenu d'une valeur de type case_type
afficher_case_type :: Case_type -> IO ()
afficher_case_type v = toStorable v $ \v' ->  (hs_afficher_case_type v') >>= unStorable

foreign import ccall
  hs_afficher_case_type :: (ApiStorableType Case_type) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type direction
afficher_direction :: Direction -> IO ()
afficher_direction v = toStorable v $ \v' ->  (hs_afficher_direction v') >>= unStorable

foreign import ccall
  hs_afficher_direction :: (ApiStorableType Direction) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type erreur
afficher_erreur :: Erreur -> IO ()
afficher_erreur v = toStorable v $ \v' ->  (hs_afficher_erreur v') >>= unStorable

foreign import ccall
  hs_afficher_erreur :: (ApiStorableType Erreur) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type action_type
afficher_action_type :: Action_type -> IO ()
afficher_action_type v = toStorable v $ \v' ->  (hs_afficher_action_type v') >>= unStorable

foreign import ccall
  hs_afficher_action_type :: (ApiStorableType Action_type) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type debug_drapeau
afficher_debug_drapeau :: Debug_drapeau -> IO ()
afficher_debug_drapeau v = toStorable v $ \v' ->  (hs_afficher_debug_drapeau v') >>= unStorable

foreign import ccall
  hs_afficher_debug_drapeau :: (ApiStorableType Debug_drapeau) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type position
afficher_position :: Position -> IO ()
afficher_position v = toStorable v $ \v' ->  (hs_afficher_position v') >>= unStorable

foreign import ccall
  hs_afficher_position :: (ApiStorableType Position) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type minerai
afficher_minerai :: Minerai -> IO ()
afficher_minerai v = toStorable v $ \v' ->  (hs_afficher_minerai v') >>= unStorable

foreign import ccall
  hs_afficher_minerai :: (ApiStorableType Minerai) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type nain
afficher_nain :: Nain -> IO ()
afficher_nain v = toStorable v $ \v' ->  (hs_afficher_nain v') >>= unStorable

foreign import ccall
  hs_afficher_nain :: (ApiStorableType Nain) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type action_hist
afficher_action_hist :: Action_hist -> IO ()
afficher_action_hist v = toStorable v $ \v' ->  (hs_afficher_action_hist v') >>= unStorable

foreign import ccall
  hs_afficher_action_hist :: (ApiStorableType Action_hist) ->  IO (ApiStorableType ())
