import sys,subprocess
from copy import deepcopy

class Coef:
	def __init__(self, typ, nom, valeur, commentaire, mini, maxi):
		self.type = typ
		self.nom = nom
		self.valeur = valeur
		self.commentaire = commentaire
		self.mini = mini
		self.maxi = maxi
	
	def toString(self):
		s = "// " + self.commentaire + "\n"
		s += "const " + self.type + " " + self.nom + " = " + str(self.valeur)
		if self.type == "long long":
			s += "ll" 
		s += ";\n"
		return s

def lireCoefs():
	f = open("coefs.hh","r")
	f.readline()
	l = f.readline()
	while l != "":
		com = l[3:-1]
		l = f.readline()
		tab = l.split()
		typ = tab[1]
		if typ == "long":
			typ = "long long"
			tab.pop(1)
		nom = tab[2]
		valeur = int(tab[4][:-1].replace("ll", ""))
		mini = valeur
		maxi = valeur
		print('    Coef("%s", "%s", %d, "%s", %d, %d),' % (typ, nom, valeur, com.replace('"', '\\"'), mini, maxi))
		l = f.readline()

def ecrireCoefs(coefs, filename = "coefs.hh"):
	f = open(filename, "w")
	f.write("#include \"prologin.hh\"\n")
	for coef in coefs:
		f.write(coef.toString())
	f.close()
		
#lireCoefs()
coefs = [
	Coef("int", "CHUTE_SAFE", 3, "Distance de chute libre tolérée.", 0, 3),
    Coef("int", "COUT_ACTION", 1, "Pondération des points d'action dans le Dijkstra.", 1, 5),
    Coef("int", "COUT_MOUV", 1, "Pondération des points de mouvement dans le Dijkstra.", 1, 5),
    Coef("int", "SCORE_TADV", -10000000, "Score de la case de la taverne adversaire.", -10000000, -10000),
    Coef("int", "SCORE_TAV", 1, "Score de notre taverne.", 1, 25),
    Coef("long long", "COEF_RENDEMENT", 1000000, "Coefficient multiplicatif pour le rendement dans le score d'une situation.", 1, 10000000),
    Coef("long long", "COEF_ATTAQUE", 1000000, "Coefficient multiplicatif pour l'attaque d'un nain ennemi.", 1, 10000000),
    Coef("int", "COEF_DIV_RESISTANCE", 3, "Coefficient de division par la résistance : division du score par (résistance/COEF_DIV_RESISTANCE)", 1, 5),
    Coef("long long", "COEF_COUT", 20, "Coefficient de division par la distance : division du score par (COEF_COUT*distance)", 20, 20),
    Coef("int", "TOUR_RUSH_TAV", 90, "Tour à partir duquel tous les nains regagnent à tout prix la taverne", 90, 90),
    Coef("int", "VIE_RETOUR", 2, "Points de vie en-dessous (incl.) desquels un nain fuit vers sa taverne", 2, 2),
    Coef("int", "BUTIN_RETOUR", 23, "Butin au-dessus (incl.) duquel un nain regagne sa taverne", 23, 23),
    Coef("int", "LG_MIN_CORDE", 11, "Longueur minimale d'une corde à poser", 11, 11),
    Coef("int", "MALUS_SIT_NALLIE", 1000000, "Malus d'une situation où se trouve déjà un nain allié", 100000, 4000000),
    Coef("int", "MALUS_TR_NALLIE", 40, "Malus d'une transition vers une case avec nain allié", 1, 2000),
    Coef("int", "MALUS_TR_NENNEMI", 50, "Malus d'une transition vers une case avec nain ennemi (cf map \"coup de bouteille\")", 50, 50),
    Coef("int", "MALUS_PROX_NENNEMI", 1000, "Malus pour proximité d'un ennemi", 1000, 1000),
    Coef("int", "DIST_PROX_NENNEMI", 4, "Distance de prise en compte", 0, 6),
    Coef("int", "DIST_ATTAQUE_ENNEMI", 5, "Distance d'attaque", 0, 6),
    Coef("int", "NON_ATTAQUE", -1000000000, "Score fixe indiquant l'absence d'attaque", -1000000000, -1000000000),
    Coef("int", "CONSTANTE_ADV", 1, "Constante de prise en compte d'un adversaire vide", 0, 4),
    Coef("int", "MAX_DISTANCE_TADV_ATQ", 4, "Distance minimale de la taverne de l'adversaire pour attaquer", 4, 4)
]

def lancerMatch(champion1, champion2, carte = "../maps/plain.map"):
	fic = open("config.yml", "w")
	fic.write("""rules: libprologin2019.so
verbose: 3
clients:
 - ./""" + champion1 + """
 - ./""" + champion2 + """
names:
 - Player 1
 - Player 2
map: """ + carte)
	fic.close()
	res = str(subprocess.run(["stechec2-run", "config.yml"], capture_output=True).stdout, encoding="utf-8").split("\n")
	#print(res)
	for i in range(len(res)):
		if res[i] == "---":
			score1 = int(res[i+2].split(" ")[1])
			score2 = int(res[i+6].split(" ")[1]) 
			return score1,score2

def reglerCoef(i, maxSteps=20, carte="../maps/plain.map"):
	res = {}
	coef = deepcopy(coefs[i])
	steps = min(coef.maxi-coef.mini+1, maxSteps)
	pas = (coef.maxi-coef.mini)//max(1, steps-1)
	for val in range(coef.mini, coef.maxi+1, max(1,pas)):
		try:
			coef.valeur = val
			nouvCoefs = coefs.copy()
			nouvCoefs[i] = coef
			ecrireCoefs(nouvCoefs)
			print("Compilation pour val=%d" % (val))
			subprocess.run(["make"])
			print("Lancement pour val=%d" % (val))
			res[val] = lancerMatch("champion.so", "champion-orig.so", carte=carte)
			print(res[val])
		except KeyboardInterrupt:
			break
		except:
			print("ERREUR !!!!")
	return res

print(reglerCoef(int(sys.argv[1]), carte=sys.argv[2]))
