#ifndef STRUCTURES_HH
#define STRUCTURES_HH
#include "prologin.hh"
using namespace std;


const int NON_VISITE = 2*1000*1000*1000+100*1000*1000;
const int INFINI = 2*1000*1000*1000;

bool posEgales(position p1, position p2) {
	return p1.ligne == p2.ligne && p1.colonne == p2.colonne;
}

/**
 * Structure de situation, définie par la position et si l'on est accroché ou non.
 * Stocke quelques infos supplémentaires pour pouvoir remonter le chemin.
 */
struct Situation {
	position pos;
	bool accroche;
	// Coût minimal pour atteindre cette situation dans un Dijkstra.
	int cost;
	// Dernière action effectuée (sauf minage).
	action_hist action;
	// Nombre de minages nécessaires avant le déplacement.
	int nMine;
	
	// Etat précédent.
	position posPrec;
	bool accPrec;
	// Points d'action utilisés. Peut être supérieur à 6.
	int pa;
	
	// Comparaison inversée, en raison du fonctionnement d'une priority_queue.
	bool operator<(const Situation &autre) const {
		return cost > autre.cost;
	}
};
#endif
