#ifndef DEBUG_HH
#define DEBUG_HH
#include <string>
#include <iostream>
#include "prologin.hh"
#include "structures.hh"
using namespace std;

string cost_str(int cost) {
	return cost == INFINI ? "." : to_string(cost);
}

string dir_str(direction dir) {
	if(dir == DROITE)
		return "D";
	else if(dir == GAUCHE)
		return "G";
	else if(dir == HAUT)
		return "H";
	else
		return "B";
}

string act_str(action_hist act) {
	string ret = "";
	if(act.atype == ACTION_DEPLACER)
		ret += "d";
	else if(act.atype == ACTION_LACHER)
		ret += "l";
	else if(act.atype == ACTION_MINER)
		ret += "m";
	else if(act.atype == ACTION_POSER_CORDE)
		ret += "c";
	else if(act.atype == ACTION_TIRER)
		ret += "t";
	else
		ret += "a";
	if(act.atype == ACTION_DEPLACER || act.atype == ACTION_MINER || act.atype == ACTION_POSER_CORDE || act.atype == ACTION_TIRER) {
		ret += dir_str(act.dir);
	}
	if(act.atype == ACTION_TIRER) {
		ret += dir_str(act.sens);
	}
	return ret;
}

string str_sit(Situation sit) {
	string ret = cost_str(sit.cost);
	/*if(sit.cost == INFINI)
		return ret;
	ret += ",";
	ret += act_str(sit.action);
	if(sit.nMine != 0) {
		ret += "m";
		ret += to_string(sit.nMine);
	}*/
	return ret;
}

string couleurScore(long long score, long long maxi, long long mini) {
	score = max(mini, score);
	int rouge = (maxi-score)*255/max(1ll, maxi-mini);
	int vert = (score-mini)*255/max(1ll, maxi-mini);
	char resultat[70];
	sprintf(resultat, "%02X%02X%02X", rouge, vert, 0);
	return string(resultat);
}

void init_debug() {
	freopen(("debug-" + to_string(moi()) + ".html").c_str(), "w", stdout);
	cout << "<!DOCTYPE html>\n";
	cout << "<html><head><title>DEBUG</title><style type=\"text/css\">table, tr, td{border:1px solid black;border-collapse: collapse;font-size: 11px}td{min-width:15px}</style></head><body>\n";
}

void finish_debug() {
	cout << "</body></html>\n";
}

const string COULEUR_OBSI = "#111111";
const string COULEUR_GRANITE = "#999999";
const string COULEUR_TAVERNE = "#00FFFF";
const string COULEUR_MINERAI = "#FF55FF";

void afficherMap() {
	cout << "<h3>Carte :</h3>\n";
	cout << "<table>";
	for(int lig = 0; lig < TAILLE_MINE; lig++) {
		cout << "<tr>";
		for(int col = 0; col < TAILLE_MINE; col++) {
			case_type type = type_case({lig, col});
			if(posEgales(position_taverne(moi()), {lig, col}) || posEgales(position_taverne(adversaire()), {lig, col}))
				cout << "<td style=\"background-color: " << COULEUR_TAVERNE << "\">&nbsp;</td>";
			else if(type == LIBRE)
				cout << "<td>&nbsp;</td>";
			else if(type == GRANITE) {
				minerai mine = info_minerai({lig, col});
				if(mine.resistance < 0)
					cout << "<td style=\"background-color: " << COULEUR_GRANITE << "\">&nbsp;</td>";
				else {
					cout << "<td style=\"background-color: " << COULEUR_MINERAI << "\">r";
					cout << mine.rendement;
					cout << "h";
					cout << mine.resistance;
					cout << "</td>";
				}
			}
			else if(type == OBSIDIENNE)
				cout << "<td style=\"background-color: " << COULEUR_OBSI << "\">&nbsp;</td>";
		}
		cout << "</tr>\n";
	}
	cout << "</table>\n";
}

void afficherGrille(vector<vector<vector<Situation> > > mat, vector<vector<vector<long long> > > scores, int iNain, long long maxi, long long mini) {
	position posAct = info_nain(moi(), iNain).pos;
	cout << "<h3>Grille de jeu :</h3>\n";
	cout << "<p>Identifiant : t" << tour_actuel() << "n" << iNain << "</p>\n";
	cout << "<table>\n";
	for(int lig = 0; lig < TAILLE_MINE; lig++) {
		cout << "<tr>";
		for(int col = 0; col < TAILLE_MINE; col++) {
			long long score = scores[lig][col][false];
			string coul = couleurScore(score, maxi, mini);
			if(lig == posAct.ligne && col == posAct.colonne)
				coul = "5555FF";
			cout << "<td style=\"background-color: #" << coul << "\">("/*"(" << str_sit(mat[lig][col][0]) << " | " << str_sit(mat[lig][col][1]) << "), (" << scoreSit(mat, enCompte, iNain, {lig, col}, false) << " | "*/ << scores[lig][col][false] << ")</td>\n" << flush;
		}
		cout << "</tr>\n";
	}
	cout << "</table>\n" << flush;
}
#endif
