#!/usr/bin/python
import requests
import sys

API_BASE = 'http://concours/api'
base = 'http://concours'


def champion_upload(base, tarball, name, comment):
    s = requests.session()
    # acquire CSRF token
    s.get(base + "/champions")
    try:
        token = s.cookies['csrftoken']
    except KeyError:
        print("Error: could not retrieve CSRF token (no SSO?)", file=sys.stderr)
        return 1
    res = s.post(base + "/champions/",
                 data={'name': name, 'comment': comment, 'csrfmiddlewaretoken': token},
                 files={'sources': tarball})
    if not res.ok:
        print("Error", res.text, file=sys.stderr)
        return 1
    res = res.json()
    print("Your champion {} was uploaded to {} ({})".format(
        res['id'], res['url'], res['status_human'].lower()))
    return 0

def begin_match(champion1, champion2, mape):
    s = requests.session()
    s.get(base + "/matches/")
    try:
        token = s.cookies['csrftoken']
    except KeyError:
        print("Error: could not retrieve CSRF token (no SSO?)", file=sys.stderr)
        return 1
    res = s.post(base + "/matches/new/", data={"champion_1": champion1, "champion_2": champion2, "map": mape, 'csrfmiddlewaretoken': token})
    if not res.ok:
        print("Error", res.text, file=sys.stderr)
        return 1


if __name__ == '__main__':
    begin_match(int(sys.argv[1]), int(sys.argv[2]), int(sys.argv[3]))
