#include "prologin.hh"
#include "debug.hh"
#include "structures.hh"
#include "coefs.hh"
#include <vector>
#include <queue>
#include <iostream>
#include <algorithm>
#include <string>
#include <chrono>
#include <ctime>
#include <cstdio>
#include <deque>
#include <cstdio>
using namespace std;



#ifdef LOCAL
bool afficher = true;
#else
bool afficher = false;
#endif

void partie_init() {}


position caseSuiv(position pos, direction dir) {
	switch (dir) {
	case HAUT:
		return {pos.ligne-1, pos.colonne};
	case DROITE:
		return {pos.ligne, pos.colonne+1};
	case BAS:
		return {pos.ligne+1, pos.colonne};
	case GAUCHE:
		return {pos.ligne, pos.colonne-1};
	default:
		return {-1,-1};
	}
}

int distanceMan(position p1, position p2) {
	return abs(p1.ligne-p2.ligne) + abs(p1.colonne-p2.colonne);
}

bool valide(position pos) {
	return pos.ligne >= 0 && pos.ligne < TAILLE_MINE && pos.colonne >= 0 && pos.colonne < TAILLE_MINE;
}

bool estSol(position pos) {
	if(pos.ligne == TAILLE_MINE-1)
		return true;
	position dessous = caseSuiv(pos, BAS);
	return type_case(dessous) != LIBRE;
}

int descente(position pos) {
	int ret = 0;
	while(!estSol(pos)) {
		pos.ligne++;
		ret++;
	}
	return ret;
}

int coupsPioche(position pos) {
	if(type_case(pos) == LIBRE)
		return 0;
	else if(type_case(pos) == OBSIDIENNE)
		return INFINI;
	minerai mine = info_minerai(pos);
	return max(1, mine.resistance);
}

int malusProximite(position pos) {
	int total = 0;
	for(int iNain = 0; iNain < NB_NAINS; iNain++) {
		nain info = info_nain(adversaire(), iNain);
		int d = distanceMan(info.pos, pos);
		if(d <= DIST_PROX_NENNEMI)
			total += (DIST_PROX_NENNEMI-d)*MALUS_PROX_NENNEMI;
	}
	return total;
}

int coutDepl(position pos, bool accroche, direction dir, bool limiter = false) {
	position suiv = caseSuiv(pos, dir);
	position pos_tadv = position_taverne(adversaire());
	// Situations que l'on ne veut absolument pas atteindre
	// (reconsidérer peut-être le cas de la taverne adverse avec butin négatif)
	if(	!valide(suiv) || 
		(!accroche && descente(suiv) > CHUTE_SAFE) ||
		(limiter && type_case(suiv) != LIBRE) ||
		type_case(suiv) == OBSIDIENNE ||
		posEgales(suiv, pos_tadv) )
		return INFINI;
	int malus = 0;
	if(nain_sur_case(suiv) == moi())
		malus = MALUS_TR_NALLIE;
	if(nain_sur_case(suiv) == adversaire())
		malus = MALUS_TR_NENNEMI;
	if(type_case(suiv) == LIBRE) {
		if(accroche) {
			if(corde_sur_case(pos) && corde_sur_case(suiv))
				return COUT_MOUV;
			else
				return 2*COUT_MOUV;
		}
		else
			return COUT_MOUV;
	}
	return malus + max(0, coupsPioche(suiv)*COUT_MINER*COUT_ACTION + (!accroche && dir == BAS ? 0 : COUT_MOUV));
}

vector<Situation> sitsSuivantes(Situation sit, bool limiter = false) {
	position pos_tadv = position_taverne(adversaire());
	vector<Situation> ret;
	for(direction dir : {HAUT, BAS, GAUCHE, DROITE}) {
		if(!sit.accroche && dir == HAUT)
			continue;
		int cost = coutDepl(sit.pos, sit.accroche, dir, limiter);
		if(cost != INFINI) {
			position suiv = caseSuiv(sit.pos, dir);
			if(!sit.accroche)
				suiv.ligne += descente(suiv);
			if(posEgales(suiv, pos_tadv))
				continue;
			ret.push_back({suiv, sit.accroche, sit.cost+cost, {ACTION_DEPLACER, -1, dir, dir}, coupsPioche(caseSuiv(sit.pos, dir)), sit.pos, sit.accroche});
		}
	}
	int desc = descente(sit.pos);
	if(sit.accroche && desc <= CHUTE_SAFE && (sit.pos.ligne+desc != pos_tadv.ligne || sit.pos.colonne != pos_tadv.colonne)) {
		position suiv = {sit.pos.ligne+desc, sit.pos.colonne};
		ret.push_back({suiv, false, sit.cost+COUT_LACHER*COUT_ACTION, {ACTION_LACHER, -1, HAUT, HAUT}, 0, sit.pos, sit.accroche});
	}
	if(!sit.accroche)
		ret.push_back({sit.pos, true, sit.cost+COUT_AGRIPPER*COUT_ACTION, {ACTION_AGRIPPER, -1, HAUT, HAUT}, 0, sit.pos, sit.accroche});
	return ret;
}

// Dijkstra : détermination d'un chemin vers chaque case atteignable
vector<vector<vector<Situation> > > coutsDepl(int idnain, bool limiter = false) {
	priority_queue<Situation> sits;
	nain init = info_nain(moi(), idnain);
	Situation sitInit = {init.pos, init.accroche, 0, {ACTION_LACHER, -1, HAUT, HAUT}, 0, {-1, -1}, false};
	vector<vector<vector<Situation> > > ret(TAILLE_MINE, vector<vector<Situation>> (TAILLE_MINE, vector<Situation> (2, {init.pos, false, NON_VISITE, {ACTION_LACHER, -1, HAUT, HAUT}, 0, {-1, -1}, false})));
	sits.push(sitInit);
	while(!sits.empty()) {
		Situation sit = sits.top();
		sits.pop();
		if(ret[sit.pos.ligne][sit.pos.colonne][sit.accroche].cost < NON_VISITE)
			continue;
		ret[sit.pos.ligne][sit.pos.colonne][sit.accroche] = sit;
		vector<Situation> suivs = sitsSuivantes(sit, limiter);
		for(Situation suiv : suivs)
			sits.push(suiv);
	}
	return ret;
}

long long scoreSit(vector<vector<vector<Situation> > > & sits, vector<vector<bool> > & compte, int inain, position pos, bool accroche) {
	long long total = 0;
	long long dist = sits[pos.ligne][pos.colonne][accroche].cost;
	nain info = info_nain(moi(), inain);
	position pos_tav = position_taverne(moi());
	position pos_tavadv = position_taverne(adversaire());
	if(pos.ligne == pos_tavadv.ligne && pos.colonne == pos_tavadv.colonne)
		return SCORE_TADV;
	if(nain_sur_case(pos) == moi() && !posEgales(pos, info.pos))
		total -= MALUS_SIT_NALLIE;
	if(dist <= DIST_PROX_NENNEMI)
		total -= malusProximite(pos);
	if(info.vie <= VIE_RETOUR || info.butin >= BUTIN_RETOUR || tour_actuel() >= TOUR_RUSH_TAV) {
		if(pos_tav.ligne == pos.ligne && pos_tav.colonne == pos.colonne)
			return INFINI;
		else
			return -INFINI;
	}
	if(compte[pos.ligne][pos.colonne])
		total -= 1000;
	for(direction dir : {HAUT, GAUCHE, BAS, DROITE}) {
		position suiv = caseSuiv(pos, dir);
		if(!valide(suiv) || type_case(suiv) != GRANITE || (!accroche && dir == BAS && descente(suiv) >= CHUTE_SAFE-1))
			continue;
		minerai mine = info_minerai(suiv);
		if(mine.resistance < 0)
			continue;
		total += min(BUTIN_MAX-info.butin, mine.rendement) * COEF_RENDEMENT / max(1, (mine.resistance/COEF_DIV_RESISTANCE)) / max(1ll, COEF_COUT*dist); 
	}
	if(pos.ligne == pos_tav.ligne && pos.colonne == pos_tav.colonne)
		total = SCORE_TAV;
	//cerr << "Fin dét.score\n";
	return total;
}

deque<action_hist> listeInstr(vector<vector<vector<Situation> > > &mat, int iNain, position arrivee, bool accroche) {
	if(afficher)
		cout << "Vers " << arrivee.ligne << " " << arrivee.colonne << " " << (accroche ? "acc" : "noacc") << "<br>\n" << flush;
	nain info = info_nain(moi(), iNain);
	deque<action_hist> ret;
	Situation actuel = mat[arrivee.ligne][arrivee.colonne][accroche];
	while(actuel.pos.ligne != info.pos.ligne || actuel.pos.colonne != info.pos.colonne || actuel.accroche != info.accroche) {
		if(actuel.accroche || actuel.action.atype != ACTION_DEPLACER || actuel.action.dir != BAS)
			ret.push_front(actuel.action);
		for(int i = 0; i < actuel.nMine; i++)
			ret.push_front({ACTION_MINER, iNain, actuel.action.dir, actuel.action.dir});
		if(afficher)
			cout << "Etape : " << actuel.posPrec.ligne << " " << actuel.posPrec.colonne << " " << (actuel.accPrec ? "acc" : "noacc") << "<br>\n" << flush;
		actuel = mat[actuel.posPrec.ligne][actuel.posPrec.colonne][actuel.accPrec];
	}
	return ret;
}

void clearFlags() {
	for(int l = 0; l < TAILLE_MINE; l++)
		for(int c = 0; c < TAILLE_MINE; c++)
			debug_afficher_drapeau({l, c}, AUCUN_DRAPEAU);
}

int sommeNainAdverse(position pos) {
	int s = 0;
	for(int iNain = 0; iNain < NB_NAINS; iNain++) {
		nain ret = info_nain(adversaire(), iNain);
		if(ret.pos.ligne == pos.ligne && ret.pos.colonne == pos.colonne)
			s += ret.butin;
	}
	return s;
}

bool cordePosee = false;
bool poserCorde(int iNain = 0) {
	vector<vector<vector<Situation> > > atteignables = coutsDepl(iNain, true);
	int lgMax = 0;
	position corres = {0, 0};
	direction dirMax = HAUT;
	bool accrocheMax = false;
	for(int lig = 0; lig < TAILLE_MINE; lig++)
		for(int col = 0; col < TAILLE_MINE; col++)
			for(bool accroche : {false, true})
				if(atteignables[lig][col][accroche].cost != NON_VISITE && atteignables[lig][col][accroche].cost <= NB_POINTS_DEPLACEMENT)
					for(direction dir : {HAUT, GAUCHE, BAS, DROITE}) {
						position suiv = caseSuiv({lig, col}, dir);
						if(!valide(suiv) || type_case(suiv) != LIBRE)
							continue;
						int desc = descente(suiv)+1;
						if(desc >= lgMax) {
							lgMax = desc;
							corres = {lig, col};
							dirMax = dir;
							accrocheMax = accroche;
						}
					}
	if(lgMax <= LG_MIN_CORDE)
		return false;
	if(afficher)
		cout << "<p>On peut placer une corde ! Détermination instructions...<br>\n" << flush;
	deque<action_hist> actions = listeInstr(atteignables, iNain, corres, accrocheMax);
	if(afficher)
		cout << "</p>\n" << flush;
	if(afficher) {
		cout << "<p>Actions d&eacute;cid&eacute;es : ";
		for(action_hist act : actions)
			cout << act_str(act) << " ";
		cout << "</p>\n" << flush;
	}
	for(action_hist act : actions) {
		erreur err;
		if(act.atype == ACTION_DEPLACER)
			err = deplacer(iNain, act.dir);
		else if(act.atype == ACTION_MINER || act.atype == ACTION_POSER_CORDE || act.atype == ACTION_TIRER) {
			cout << "<p style=\"color: red\">Action interdite !</p>\n" << flush;
			break;
		}
		else if(act.atype == ACTION_AGRIPPER)
			err = agripper(iNain);
		else if(act.atype == ACTION_LACHER)
			err = lacher(iNain);
		if(err != OK)
			break;
	}
	poser_corde(iNain, dirMax);
	return true;
}

void jouer_tour() {
	if(afficher) {
		init_debug();
		cout << "<h1>Tour n° " << tour_actuel() << "\t</h1>\n" << flush;
		afficherMap();
	}
	vector<vector<bool> > enCompte(TAILLE_MINE, vector<bool> (TAILLE_MINE, false));
	for(int iNain = 0; iNain < NB_NAINS; iNain++) {
		if(afficher)
			cout << "<h2>-&gt; Traitement nain " << iNain << "</h2>\n" << flush;
		position posAct = info_nain(moi(), iNain).pos;
		if(posAct.ligne == -1) {
			if(afficher)
				cout << "<p>Nain mort, on passe</p>";
			continue;
		}
		if(!cordePosee && iNain == 0) {
			if(afficher)
				cout << "<p>Essai de dépôt de corde...</p>\n" << flush;
			if(poserCorde()) {
				if(afficher)
					cout << "<p>Réussi !</p>\n" << flush;
				cordePosee = true;
				continue;
			}
		}
		if(afficher)
			cout << "<p>Lancement Dijkstra...<br>\n" << flush;
		vector<vector<vector<Situation> > > mat = coutsDepl(iNain);
		if(afficher)
			cout << "</p><p>Détermination situation optimale... ";
		vector<vector<vector<long long> > > scores(TAILLE_MINE, vector<vector<long long> > (TAILLE_MINE, vector<long long> (2)));
		long long maxi = -INFINI, mini = INFINI;
		position posCorres = {0, 0};
		bool accCorres = false;
		bool trouve = false;
		for(int lig = 0; lig < TAILLE_MINE; lig++)
			for(int col = 0; col < TAILLE_MINE; col++) {
				for(bool accroche : {false, true}) {
					long long sc = scoreSit(mat, enCompte, iNain, {lig, col}, accroche);
					scores[lig][col][accroche] = sc;
					if(sc > maxi && mat[lig][col][accroche].cost != NON_VISITE) {
						trouve = true;
						maxi = sc;
						posCorres = {lig, col};
						accCorres = accroche;
					}
					if(sc < mini && sc != SCORE_TADV)
						mini = sc;
				}
			}
		if(!trouve) {
			cout << "Aucune situation accessible (!!).</p>\n" << flush;
			continue;
		}
		if(afficher) {
			cout << "Se situe en (" << posCorres.ligne << "," << posCorres.colonne << "," << (accCorres ? "acc" : "nonacc") << "), vaut " << maxi << "\n" << flush;
			afficherGrille(mat, scores, iNain, maxi, mini);
			cout << "<p>Détermination instructions...<br>\n" << flush;
		}
		deque<action_hist> actions = listeInstr(mat, iNain, posCorres, accCorres);
		if(afficher) {
			cout << "</p>\n" << flush;
			cout << "<p>Actions d&eacute;cid&eacute;es : ";
			for(action_hist act : actions)
				cout << act_str(act) << " ";
			cout << "</p>\n" << flush;
		}
		for(action_hist act : actions) {
			erreur err;
			if(act.atype == ACTION_DEPLACER)
				err = deplacer(iNain, act.dir);
			else if(act.atype == ACTION_MINER)
				err = miner(iNain, act.dir);
			else if(act.atype == ACTION_AGRIPPER)
				err = agripper(iNain);
			else if(act.atype == ACTION_LACHER)
				err = lacher(iNain);
			else if(act.atype == ACTION_POSER_CORDE)
				err = poser_corde(iNain, act.dir);
			else if(act.atype == ACTION_TIRER)
				err = tirer(iNain, act.dir, act.sens);
			if(err != OK)
				break;
		}
		nain nn = info_nain(moi(), iNain);
		posAct = nn.pos;
		// Priorité à l'auto-défense/à l'attaque
		for(direction dir : {HAUT, BAS, GAUCHE, DROITE}) {
			position posMine = caseSuiv(posAct, dir);
			if(!valide(posMine))
				continue;
			erreur err = OK;
			while(err == OK && sommeNainAdverse(posMine) >= 0 && nain_sur_case(posMine) == adversaire())
				err = miner(iNain, dir);
		}
		for(direction dir : {HAUT, BAS, GAUCHE, DROITE}) {
			position posMine = caseSuiv(posAct, dir);
			if(!valide(posMine))
				continue;
			minerai mine = info_minerai(posMine);
			erreur err = OK;
			if(!nn.accroche && dir == BAS && descente(posMine) >= CHUTE_SAFE - 1)
				continue;
			//debug_afficher_drapeau(posMine, moi() == 1 ? DRAPEAU_VERT : DRAPEAU_ROUGE);
			while(err == OK && mine.rendement >= 1) {
				err = miner(iNain, dir);
				mine = info_minerai(posMine);
			}
		}
		finish_debug();
	}
}

void partie_fin() {}

