{-# LANGUAGE ForeignFunctionInterface #-}
{-# LANGUAGE TypeFamilies #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE UndecidableInstances #-}

{-# OPTIONS_HADDOCK hide #-}

-- This file has been generated, if you wish to
-- modify it in a permanent way, please refer
-- to the script file : gen/generator_haskell.rb

module CApi where

import Data.List (foldl')
import Foreign
import Foreign.C.Types

import Foreign.Marshal.Array

#include "interface_c.hh"

class ApiStorable a where
  type ApiStorableType a
  toStorable :: a -> (ApiStorableType a -> IO b) -> IO b
  unStorable :: ApiStorableType a -> IO a
  type ApiStorableBaseType a
  toStorableBase :: a -> (ApiStorableBaseType a -> IO b) -> IO b
  unStorableBase :: ApiStorableBaseType a -> IO a

instance ApiStorable () where
  type ApiStorableType () = ()
  toStorable () f = f ()
  {-# INLINE toStorable #-}
  unStorable _ = return ()
  {-# INLINE unStorable #-}
  type ApiStorableBaseType () = ()
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Int where
  type ApiStorableType Int = CInt
  toStorable x f = f (fromIntegral x)
  {-# INLINE toStorable #-}
  unStorable = return . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Int = ApiStorableType Int
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Bool where
  type ApiStorableType Bool = CBool
  toStorable x f = f ((\bx -> if bx then 1 else 0) x)
  {-# INLINE toStorable #-}
  unStorable = return . (/= 0)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Bool = ApiStorableType Bool
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
instance ApiStorable Double where
  type ApiStorableType Double = CDouble
  toStorable x f = f (CDouble x)
  {-# INLINE toStorable #-}
  unStorable = return . (\(CDouble x) -> x)
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Double = ApiStorableType Double
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types de cases
data Case_type =
    Libre -- ^ Case libre 
  | Mur -- ^ Mur 
  | Erreur -- ^ Erreur 
  deriving(Show, Eq, Enum)
type CCase_type = CInt

instance ApiStorable Case_type where
  type ApiStorableType Case_type = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Case_type = ApiStorableType Case_type
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Points cardinaux
data Direction =
    Nord -- ^ Direction : nord 
  | Est -- ^ Direction : est 
  | Sud -- ^ Direction : sud 
  | Ouest -- ^ Direction : ouest 
  deriving(Show, Eq, Enum)
type CDirection = CInt

instance ApiStorable Direction where
  type ApiStorableType Direction = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Direction = ApiStorableType Direction
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Erreurs possibles
data Erreur =
    Ok -- ^ L'action s'est effectuée avec succès. 
  | Pa_insuffisants -- ^ Votre agent ne possède pas assez de points d'action pour réaliser cette action. 
  | Position_invalide -- ^ La position spécifiée n'est pas sur la banquise. 
  | Obstacle_mur -- ^ La position spécifiée est un mur. 
  | Obstacle_agent -- ^ La position spécifiée est un agent. 
  | Deplacement_hors_limites -- ^ Ce déplacement fait sortir un agent des limites de la banquise. 
  | Direction_invalide -- ^ La direction spécifiée n'existe pas. 
  | Id_agent_invalide -- ^ L'agent spécifié n'existe pas. 
  | Rien_a_pousser -- ^ Aucun agent à pousser dans la direction indiquée. 
  | Drapeau_invalide -- ^ Le drapeau spécifié n'existe pas. 
  deriving(Show, Eq, Enum)
type CErreur = CInt

instance ApiStorable Erreur where
  type ApiStorableType Erreur = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Erreur = ApiStorableType Erreur
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types d'actions
data Action_type =
    Action_deplacer -- ^ Action ``deplacer`` 
  | Action_glisser -- ^ Action ``glisser`` 
  | Action_pousser -- ^ Action ``pousser`` 
  deriving(Show, Eq, Enum)
type CAction_type = CInt

instance ApiStorable Action_type where
  type ApiStorableType Action_type = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Action_type = ApiStorableType Action_type
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Types de drapeaux de débug
data Debug_drapeau =
    Aucun_drapeau -- ^ Aucun drapeau, enlève le drapeau présent 
  | Drapeau_bleu -- ^ Drapeau bleu 
  | Drapeau_vert -- ^ Drapeau vert 
  | Drapeau_rouge -- ^ Drapeau rouge 
  deriving(Show, Eq, Enum)
type CDebug_drapeau = CInt

instance ApiStorable Debug_drapeau where
  type ApiStorableType Debug_drapeau = CInt
  toStorable x f = f (fromIntegral (fromEnum x))
  {-# INLINE toStorable #-}
  unStorable = return . toEnum . fromIntegral
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Debug_drapeau = ApiStorableType Debug_drapeau
  toStorableBase = toStorable
  {-# INLINE toStorableBase #-}
  unStorableBase = unStorable
  {-# INLINE unStorableBase #-}
-- | Position sur la banquise, donnée par deux coordonnées.
data Position = Position Int Int
  deriving(Show, Eq)
data CPosition = CPosition CInt CInt
instance Storable CPosition where
  sizeOf    _ = (#size position)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aligne <- (#peek position, ligne) ptr
    acolonne <- (#peek position, colonne) ptr
    return $ CPosition aligne acolonne
  {-# INLINE peek #-}
  poke ptr (CPosition aligne acolonne) = do
    (#poke position, ligne) ptr aligne
    (#poke position, colonne) ptr acolonne
  {-# INLINE poke #-}
instance ApiStorable Position where
  type ApiStorableType Position = Ptr CPosition
  toStorable (Position aligne acolonne) f = toStorableBase aligne $ \aligne' ->  toStorableBase acolonne $ \acolonne' ->  do
    alloca $ \ptr -> do
      poke ptr $ CPosition aligne' acolonne'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CPosition aligne' acolonne') <- peek ptr
    aligne <- unStorableBase aligne'
    acolonne <- unStorableBase acolonne'
    return $ Position aligne acolonne
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Position = CPosition
  toStorableBase (Position aligne acolonne) f =
    toStorableBase aligne $ \aligne' ->  toStorableBase acolonne $ \acolonne' ->  f (CPosition aligne' acolonne')
  {-# INLINE toStorableBase #-}
  unStorableBase (CPosition aligne' acolonne') = do
    aligne <- unStorableBase aligne'
    acolonne <- unStorableBase acolonne'
    return $ Position aligne acolonne
  {-# INLINE unStorableBase #-}
-- | Alien à capturer durant la mission.
data Alien_info = Alien_info {
      pos :: Position -- ^ Position de l'alien
  ,   points_capture :: Int -- ^ Nombre de points obtenus pour la capture de cet alien
  ,   tour_invasion :: Int -- ^ Tour où l'alien débarque sur la banquise
  ,   duree_invasion :: Int -- ^ Nombre de tours où l'alien reste sur la banquise
  ,   capture_en_cours :: Int -- ^ Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE
}
  deriving(Show, Eq)
data CAlien_info = CAlien_info {
      cpos :: CPosition -- ^ Position de l'alien
  ,   cpoints_capture :: CInt -- ^ Nombre de points obtenus pour la capture de cet alien
  ,   ctour_invasion :: CInt -- ^ Tour où l'alien débarque sur la banquise
  ,   cduree_invasion :: CInt -- ^ Nombre de tours où l'alien reste sur la banquise
  ,   ccapture_en_cours :: CInt -- ^ Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE
}
instance Storable CAlien_info where
  sizeOf    _ = (#size alien_info)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    apos <- (#peek alien_info, pos) ptr
    apoints_capture <- (#peek alien_info, points_capture) ptr
    atour_invasion <- (#peek alien_info, tour_invasion) ptr
    aduree_invasion <- (#peek alien_info, duree_invasion) ptr
    acapture_en_cours <- (#peek alien_info, capture_en_cours) ptr
    return $ CAlien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours
  {-# INLINE peek #-}
  poke ptr (CAlien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours) = do
    (#poke alien_info, pos) ptr apos
    (#poke alien_info, points_capture) ptr apoints_capture
    (#poke alien_info, tour_invasion) ptr atour_invasion
    (#poke alien_info, duree_invasion) ptr aduree_invasion
    (#poke alien_info, capture_en_cours) ptr acapture_en_cours
  {-# INLINE poke #-}
instance ApiStorable Alien_info where
  type ApiStorableType Alien_info = Ptr CAlien_info
  toStorable (Alien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours) f = toStorableBase apos $ \apos' ->  toStorableBase apoints_capture $ \apoints_capture' ->  toStorableBase atour_invasion $ \atour_invasion' ->  toStorableBase aduree_invasion $ \aduree_invasion' ->  toStorableBase acapture_en_cours $ \acapture_en_cours' ->  do
    alloca $ \ptr -> do
      poke ptr $ CAlien_info apos' apoints_capture' atour_invasion' aduree_invasion' acapture_en_cours'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CAlien_info apos' apoints_capture' atour_invasion' aduree_invasion' acapture_en_cours') <- peek ptr
    apos <- unStorableBase apos'
    apoints_capture <- unStorableBase apoints_capture'
    atour_invasion <- unStorableBase atour_invasion'
    aduree_invasion <- unStorableBase aduree_invasion'
    acapture_en_cours <- unStorableBase acapture_en_cours'
    return $ Alien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Alien_info = CAlien_info
  toStorableBase (Alien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours) f =
    toStorableBase apos $ \apos' ->  toStorableBase apoints_capture $ \apoints_capture' ->  toStorableBase atour_invasion $ \atour_invasion' ->  toStorableBase aduree_invasion $ \aduree_invasion' ->  toStorableBase acapture_en_cours $ \acapture_en_cours' ->  f (CAlien_info apos' apoints_capture' atour_invasion' aduree_invasion' acapture_en_cours')
  {-# INLINE toStorableBase #-}
  unStorableBase (CAlien_info apos' apoints_capture' atour_invasion' aduree_invasion' acapture_en_cours') = do
    apos <- unStorableBase apos'
    apoints_capture <- unStorableBase apoints_capture'
    atour_invasion <- unStorableBase atour_invasion'
    aduree_invasion <- unStorableBase aduree_invasion'
    acapture_en_cours <- unStorableBase acapture_en_cours'
    return $ Alien_info apos apoints_capture atour_invasion aduree_invasion acapture_en_cours
  {-# INLINE unStorableBase #-}
-- | Action de déplacement représentée dans l'historique.
data Action_hist = Action_hist {
      atype :: Action_type -- ^ Type de l'action
  ,   id_agent :: Int -- ^ Numéro de l'agent concerné par l'action
  ,   dir :: Direction -- ^ Direction visée par l'agent durant le déplacement
}
  deriving(Show, Eq)
data CAction_hist = CAction_hist {
      catype :: CAction_type -- ^ Type de l'action
  ,   cid_agent :: CInt -- ^ Numéro de l'agent concerné par l'action
  ,   cdir :: CDirection -- ^ Direction visée par l'agent durant le déplacement
}
instance Storable CAction_hist where
  sizeOf    _ = (#size action_hist)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    aatype <- (#peek action_hist, atype) ptr
    aid_agent <- (#peek action_hist, id_agent) ptr
    adir <- (#peek action_hist, dir) ptr
    return $ CAction_hist aatype aid_agent adir
  {-# INLINE peek #-}
  poke ptr (CAction_hist aatype aid_agent adir) = do
    (#poke action_hist, atype) ptr aatype
    (#poke action_hist, id_agent) ptr aid_agent
    (#poke action_hist, dir) ptr adir
  {-# INLINE poke #-}
instance ApiStorable Action_hist where
  type ApiStorableType Action_hist = Ptr CAction_hist
  toStorable (Action_hist aatype aid_agent adir) f = toStorableBase aatype $ \aatype' ->  toStorableBase aid_agent $ \aid_agent' ->  toStorableBase adir $ \adir' ->  do
    alloca $ \ptr -> do
      poke ptr $ CAction_hist aatype' aid_agent' adir'
      f ptr
  {-# INLINE toStorable #-}
  unStorable ptr = do
    (CAction_hist aatype' aid_agent' adir') <- peek ptr
    aatype <- unStorableBase aatype'
    aid_agent <- unStorableBase aid_agent'
    adir <- unStorableBase adir'
    return $ Action_hist aatype aid_agent adir
  {-# INLINE unStorable #-}
  type ApiStorableBaseType Action_hist = CAction_hist
  toStorableBase (Action_hist aatype aid_agent adir) f =
    toStorableBase aatype $ \aatype' ->  toStorableBase aid_agent $ \aid_agent' ->  toStorableBase adir $ \adir' ->  f (CAction_hist aatype' aid_agent' adir')
  {-# INLINE toStorableBase #-}
  unStorableBase (CAction_hist aatype' aid_agent' adir') = do
    aatype <- unStorableBase aatype'
    aid_agent <- unStorableBase aid_agent'
    adir <- unStorableBase adir'
    return $ Action_hist aatype aid_agent adir
  {-# INLINE unStorableBase #-}
data CDirection_array = CDirection_array { cDirection_arrayPtr :: Ptr CDirection, cDirection_arraySize :: CSize }

instance Storable CDirection_array where
  sizeOf    _ = (#size direction_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek direction_array, length) ptr
    datas <- (#peek direction_array, datas) ptr
    return $ CDirection_array datas length
  {-# INLINE peek #-}
  poke ptr (CDirection_array datas length) = do
    (#poke direction_array, length) ptr length
    (#poke direction_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Direction] where
  type ApiStorableType [Direction] = Ptr CDirection_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CDirection_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Direction] = CDirection_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CDirection_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CDirection_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
data CAlien_info_array = CAlien_info_array { cAlien_info_arrayPtr :: Ptr CAlien_info, cAlien_info_arraySize :: CSize }

instance Storable CAlien_info_array where
  sizeOf    _ = (#size alien_info_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek alien_info_array, length) ptr
    datas <- (#peek alien_info_array, datas) ptr
    return $ CAlien_info_array datas length
  {-# INLINE peek #-}
  poke ptr (CAlien_info_array datas length) = do
    (#poke alien_info_array, length) ptr length
    (#poke alien_info_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Alien_info] where
  type ApiStorableType [Alien_info] = Ptr CAlien_info_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CAlien_info_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Alien_info] = CAlien_info_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CAlien_info_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CAlien_info_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
data CAction_hist_array = CAction_hist_array { cAction_hist_arrayPtr :: Ptr CAction_hist, cAction_hist_arraySize :: CSize }

instance Storable CAction_hist_array where
  sizeOf    _ = (#size action_hist_array)
  {-# INLINE sizeOf #-}
  alignment _ = alignment (undefined :: CInt)
  {-# INLINE alignment #-}
  peek ptr = do
    length <- (#peek action_hist_array, length) ptr
    datas <- (#peek action_hist_array, datas) ptr
    return $ CAction_hist_array datas length
  {-# INLINE peek #-}
  poke ptr (CAction_hist_array datas length) = do
    (#poke action_hist_array, length) ptr length
    (#poke action_hist_array, datas) ptr datas
  {-# INLINE poke #-}

instance ApiStorable [Action_hist] where
  type ApiStorableType [Action_hist] = Ptr CAction_hist_array
  toStorable xs f = toStorableBase xs $ \a -> alloca $ \ptr -> do
    poke ptr a
    f ptr
  {-# INLINE toStorable #-}
  unStorable xa = do
    (CAction_hist_array xa' xl) <- peek xa
    xs <- peekArray (fromIntegral xl) xa'
    mapM unStorableBase xs
  {-# INLINE unStorable #-}
  type ApiStorableBaseType [Action_hist] = CAction_hist_array

  toStorableBase xs f = do
    let xl = length xs
    allocaArray xl $ \xa ->
      foldl'
        (\acc (i, c) -> toStorableBase c $ \c' -> do
          poke (advancePtr xa i) c'
          acc
        )
        (f $ CAction_hist_array xa (fromIntegral xl))
        (zip [0..] xs)
  {-# INLINE toStorableBase #-}
  unStorableBase (CAction_hist_array xa xl) = do
    xs <- peekArray (fromIntegral xl) xa
    mapM unStorableBase xs
  {-# INLINE unStorableBase #-}
-- | Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
deplacer :: Int ->  Direction -> IO Erreur
deplacer id_agent dir = toStorable id_agent $ \id_agent' ->  toStorable dir $ \dir' ->  (hs_deplacer id_agent' dir') >>= unStorable

foreign import ccall
  hs_deplacer :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
glisser :: Int ->  Direction -> IO Erreur
glisser id_agent dir = toStorable id_agent $ \id_agent' ->  toStorable dir $ \dir' ->  (hs_glisser id_agent' dir') >>= unStorable

foreign import ccall
  hs_glisser :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
pousser :: Int ->  Direction -> IO Erreur
pousser id_agent dir = toStorable id_agent $ \id_agent' ->  toStorable dir $ \dir' ->  (hs_pousser id_agent' dir') >>= unStorable

foreign import ccall
  hs_pousser :: (ApiStorableType Int) -> (ApiStorableType Direction) ->  IO (ApiStorableType Erreur)
-- | Affiche le drapeau spécifié sur la case indiquée.
debug_afficher_drapeau :: Position ->  Debug_drapeau -> IO Erreur
debug_afficher_drapeau pos drapeau = toStorable pos $ \pos' ->  toStorable drapeau $ \drapeau' ->  (hs_debug_afficher_drapeau pos' drapeau') >>= unStorable

foreign import ccall
  hs_debug_afficher_drapeau :: (ApiStorableType Position) -> (ApiStorableType Debug_drapeau) ->  IO (ApiStorableType Erreur)
-- | Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
points_action_agent :: Int -> IO Int
points_action_agent id_agent = toStorable id_agent $ \id_agent' ->  (hs_points_action_agent id_agent') >>= unStorable

foreign import ccall
  hs_points_action_agent :: (ApiStorableType Int) ->  IO (ApiStorableType Int)
-- | Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
chemin :: Position ->  Position -> IO [Direction]
chemin pos1 pos2 = toStorable pos1 $ \pos1' ->  toStorable pos2 $ \pos2' ->  (hs_chemin pos1' pos2') >>= unStorable

foreign import ccall
  hs_chemin :: (ApiStorableType Position) -> (ApiStorableType Position) ->  IO (ApiStorableType [Direction])
-- | Renvoie le type d'une case donnée.
type_case :: Position -> IO Case_type
type_case pos = toStorable pos $ \pos' ->  (hs_type_case pos') >>= unStorable

foreign import ccall
  hs_type_case :: (ApiStorableType Position) ->  IO (ApiStorableType Case_type)
-- | Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
agent_sur_case :: Position -> IO Int
agent_sur_case pos = toStorable pos $ \pos' ->  (hs_agent_sur_case pos') >>= unStorable

foreign import ccall
  hs_agent_sur_case :: (ApiStorableType Position) ->  IO (ApiStorableType Int)
-- | Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
alien_sur_case :: Position -> IO Bool
alien_sur_case pos = toStorable pos $ \pos' ->  (hs_alien_sur_case pos') >>= unStorable

foreign import ccall
  hs_alien_sur_case :: (ApiStorableType Position) ->  IO (ApiStorableType Bool)
-- | Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
position_agent :: Int ->  Int -> IO Position
position_agent id_joueur id_agent = toStorable id_joueur $ \id_joueur' ->  toStorable id_agent $ \id_agent' ->  (hs_position_agent id_joueur' id_agent') >>= unStorable

foreign import ccall
  hs_position_agent :: (ApiStorableType Int) -> (ApiStorableType Int) ->  IO (ApiStorableType Position)
-- | Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
info_alien :: Position -> IO Alien_info
info_alien pos = toStorable pos $ \pos' ->  (hs_info_alien pos') >>= unStorable

foreign import ccall
  hs_info_alien :: (ApiStorableType Position) ->  IO (ApiStorableType Alien_info)
-- | Renvoie la liste de tous les aliens présents durant la partie.
liste_aliens :: IO [Alien_info]
liste_aliens  =  (hs_liste_aliens ) >>= unStorable

foreign import ccall
  hs_liste_aliens ::  IO (ApiStorableType [Alien_info])
-- | Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
historique :: IO [Action_hist]
historique  =  (hs_historique ) >>= unStorable

foreign import ccall
  hs_historique ::  IO (ApiStorableType [Action_hist])
-- | Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
score :: Int -> IO Int
score id_joueur = toStorable id_joueur $ \id_joueur' ->  (hs_score id_joueur') >>= unStorable

foreign import ccall
  hs_score :: (ApiStorableType Int) ->  IO (ApiStorableType Int)
-- | Renvoie votre numéro de joueur.
moi :: IO Int
moi  =  (hs_moi ) >>= unStorable

foreign import ccall
  hs_moi ::  IO (ApiStorableType Int)
-- | Renvoie le numéro de joueur de votre adversaire.
adversaire :: IO Int
adversaire  =  (hs_adversaire ) >>= unStorable

foreign import ccall
  hs_adversaire ::  IO (ApiStorableType Int)
-- | Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
annuler :: IO Bool
annuler  =  (hs_annuler ) >>= unStorable

foreign import ccall
  hs_annuler ::  IO (ApiStorableType Bool)
-- | Retourne le numéro du tour actuel.
tour_actuel :: IO Int
tour_actuel  =  (hs_tour_actuel ) >>= unStorable

foreign import ccall
  hs_tour_actuel ::  IO (ApiStorableType Int)
-- | Affiche le contenu d'une valeur de type case_type
afficher_case_type :: Case_type -> IO ()
afficher_case_type v = toStorable v $ \v' ->  (hs_afficher_case_type v') >>= unStorable

foreign import ccall
  hs_afficher_case_type :: (ApiStorableType Case_type) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type direction
afficher_direction :: Direction -> IO ()
afficher_direction v = toStorable v $ \v' ->  (hs_afficher_direction v') >>= unStorable

foreign import ccall
  hs_afficher_direction :: (ApiStorableType Direction) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type erreur
afficher_erreur :: Erreur -> IO ()
afficher_erreur v = toStorable v $ \v' ->  (hs_afficher_erreur v') >>= unStorable

foreign import ccall
  hs_afficher_erreur :: (ApiStorableType Erreur) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type action_type
afficher_action_type :: Action_type -> IO ()
afficher_action_type v = toStorable v $ \v' ->  (hs_afficher_action_type v') >>= unStorable

foreign import ccall
  hs_afficher_action_type :: (ApiStorableType Action_type) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type debug_drapeau
afficher_debug_drapeau :: Debug_drapeau -> IO ()
afficher_debug_drapeau v = toStorable v $ \v' ->  (hs_afficher_debug_drapeau v') >>= unStorable

foreign import ccall
  hs_afficher_debug_drapeau :: (ApiStorableType Debug_drapeau) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type position
afficher_position :: Position -> IO ()
afficher_position v = toStorable v $ \v' ->  (hs_afficher_position v') >>= unStorable

foreign import ccall
  hs_afficher_position :: (ApiStorableType Position) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type alien_info
afficher_alien_info :: Alien_info -> IO ()
afficher_alien_info v = toStorable v $ \v' ->  (hs_afficher_alien_info v') >>= unStorable

foreign import ccall
  hs_afficher_alien_info :: (ApiStorableType Alien_info) ->  IO (ApiStorableType ())
-- | Affiche le contenu d'une valeur de type action_hist
afficher_action_hist :: Action_hist -> IO ()
afficher_action_hist v = toStorable v $ \v' ->  (hs_afficher_action_hist v') >>= unStorable

foreign import ccall
  hs_afficher_action_hist :: (ApiStorableType Action_hist) ->  IO (ApiStorableType ())
