/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#include "interface.hh"
#include <cstdlib>

template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in;
}

template<>
std::string lang2cxx<char*, std::string>(char* in)
{
  return in;
}

template<typename Lang, typename Lang_array, typename Cxx>
std::vector<Cxx> lang2cxx_array(Lang_array in)
{
  std::vector<Cxx> out(in.length);
  for (size_t i = 0; i < in.length; ++i)
    out[i] = lang2cxx<Lang, Cxx>(in.datas[i]);
  return out;
}

template<typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
  return in;
}

template<>
char* cxx2lang<char*, std::string>(std::string in)
{
  size_t l = in.length();
  char* out = (char *) malloc(l + 1);
  for (int i = 0; i < l; i++) out[i] = in[i];
  out[l] = 0;
  return out;
}

template<typename Lang, typename Lang_array, typename Cxx>
Lang_array cxx2lang_array(const std::vector<Cxx>& in)
{
  Lang_array out = { NULL, in.size() };
  out.datas = (Lang *)malloc((out.length) * sizeof(Lang));
  for (int i = 0; i < out.length; ++i)
    out.datas[i] = cxx2lang<Lang, Cxx>(in[i]);
  return out;
}
/// Position sur la banquise, donnée par deux coordonnées.
template<>
__internal__cxx__position lang2cxx<position, __internal__cxx__position>(position in)
{
  __internal__cxx__position out;
  out.ligne = lang2cxx<int, int >(in.ligne);
  out.colonne = lang2cxx<int, int >(in.colonne);
  return out;
}

template<>
position cxx2lang<position, __internal__cxx__position>(__internal__cxx__position in)
{
  position out;
  out.ligne = cxx2lang<int, int >(in.ligne);
  out.colonne = cxx2lang<int, int >(in.colonne);
  return out;
}


/// Alien à capturer durant la mission.
template<>
__internal__cxx__alien_info lang2cxx<alien_info, __internal__cxx__alien_info>(alien_info in)
{
  __internal__cxx__alien_info out;
  out.pos = lang2cxx<position, __internal__cxx__position >(in.pos);
  out.points_capture = lang2cxx<int, int >(in.points_capture);
  out.tour_invasion = lang2cxx<int, int >(in.tour_invasion);
  out.duree_invasion = lang2cxx<int, int >(in.duree_invasion);
  out.capture_en_cours = lang2cxx<int, int >(in.capture_en_cours);
  return out;
}

template<>
alien_info cxx2lang<alien_info, __internal__cxx__alien_info>(__internal__cxx__alien_info in)
{
  alien_info out;
  out.pos = cxx2lang<position, __internal__cxx__position >(in.pos);
  out.points_capture = cxx2lang<int, int >(in.points_capture);
  out.tour_invasion = cxx2lang<int, int >(in.tour_invasion);
  out.duree_invasion = cxx2lang<int, int >(in.duree_invasion);
  out.capture_en_cours = cxx2lang<int, int >(in.capture_en_cours);
  return out;
}


/// Action de déplacement représentée dans l'historique.
template<>
__internal__cxx__action_hist lang2cxx<action_hist, __internal__cxx__action_hist>(action_hist in)
{
  __internal__cxx__action_hist out;
  out.atype = lang2cxx<action_type, action_type >(in.atype);
  out.id_agent = lang2cxx<int, int >(in.id_agent);
  out.dir = lang2cxx<direction, direction >(in.dir);
  return out;
}

template<>
action_hist cxx2lang<action_hist, __internal__cxx__action_hist>(__internal__cxx__action_hist in)
{
  action_hist out;
  out.atype = cxx2lang<action_type, action_type >(in.atype);
  out.id_agent = cxx2lang<int, int >(in.id_agent);
  out.dir = cxx2lang<direction, direction >(in.dir);
  return out;
}


extern "C" {
/// Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
erreur deplacer(int id_agent, direction dir)
{
  return cxx2lang<erreur, erreur >(api_deplacer(lang2cxx<int, int >(id_agent), lang2cxx<direction, direction >(dir)));
}


/// Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
erreur glisser(int id_agent, direction dir)
{
  return cxx2lang<erreur, erreur >(api_glisser(lang2cxx<int, int >(id_agent), lang2cxx<direction, direction >(dir)));
}


/// L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
erreur pousser(int id_agent, direction dir)
{
  return cxx2lang<erreur, erreur >(api_pousser(lang2cxx<int, int >(id_agent), lang2cxx<direction, direction >(dir)));
}


/// Affiche le drapeau spécifié sur la case indiquée.
erreur debug_afficher_drapeau(position pos, debug_drapeau drapeau)
{
  return cxx2lang<erreur, erreur >(api_debug_afficher_drapeau(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<debug_drapeau, debug_drapeau >(drapeau)));
}


/// Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
int points_action_agent(int id_agent)
{
  return cxx2lang<int, int >(api_points_action_agent(lang2cxx<int, int >(id_agent)));
}


/// Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
direction_array chemin(position pos1, position pos2)
{
  return cxx2lang_array<direction, direction_array, direction >(api_chemin(lang2cxx<position, __internal__cxx__position >(pos1), lang2cxx<position, __internal__cxx__position >(pos2)));
}


/// Renvoie le type d'une case donnée.
case_type type_case(position pos)
{
  return cxx2lang<case_type, case_type >(api_type_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
int agent_sur_case(position pos)
{
  return cxx2lang<int, int >(api_agent_sur_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
bool alien_sur_case(position pos)
{
  return cxx2lang<bool, bool >(api_alien_sur_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
position position_agent(int id_joueur, int id_agent)
{
  return cxx2lang<position, __internal__cxx__position >(api_position_agent(lang2cxx<int, int >(id_joueur), lang2cxx<int, int >(id_agent)));
}


/// Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
alien_info info_alien(position pos)
{
  return cxx2lang<alien_info, __internal__cxx__alien_info >(api_info_alien(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie la liste de tous les aliens présents durant la partie.
alien_info_array liste_aliens(void)
{
  return cxx2lang_array<alien_info, alien_info_array, __internal__cxx__alien_info >(api_liste_aliens());
}


/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
action_hist_array historique(void)
{
  return cxx2lang_array<action_hist, action_hist_array, __internal__cxx__action_hist >(api_historique());
}


/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
int score(int id_joueur)
{
  return cxx2lang<int, int >(api_score(lang2cxx<int, int >(id_joueur)));
}


/// Renvoie votre numéro de joueur.
int moi(void)
{
  return cxx2lang<int, int >(api_moi());
}


/// Renvoie le numéro de joueur de votre adversaire.
int adversaire(void)
{
  return cxx2lang<int, int >(api_adversaire());
}


/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
bool annuler(void)
{
  return cxx2lang<bool, bool >(api_annuler());
}


/// Retourne le numéro du tour actuel.
int tour_actuel(void)
{
  return cxx2lang<int, int >(api_tour_actuel());
}


/// Affiche le contenu d'une valeur de type case_type
void afficher_case_type(case_type v)
{
  api_afficher_case_type(lang2cxx<case_type, case_type >(v));
}


/// Affiche le contenu d'une valeur de type direction
void afficher_direction(direction v)
{
  api_afficher_direction(lang2cxx<direction, direction >(v));
}


/// Affiche le contenu d'une valeur de type erreur
void afficher_erreur(erreur v)
{
  api_afficher_erreur(lang2cxx<erreur, erreur >(v));
}


/// Affiche le contenu d'une valeur de type action_type
void afficher_action_type(action_type v)
{
  api_afficher_action_type(lang2cxx<action_type, action_type >(v));
}


/// Affiche le contenu d'une valeur de type debug_drapeau
void afficher_debug_drapeau(debug_drapeau v)
{
  api_afficher_debug_drapeau(lang2cxx<debug_drapeau, debug_drapeau >(v));
}


/// Affiche le contenu d'une valeur de type position
void afficher_position(position v)
{
  api_afficher_position(lang2cxx<position, __internal__cxx__position >(v));
}


/// Affiche le contenu d'une valeur de type alien_info
void afficher_alien_info(alien_info v)
{
  api_afficher_alien_info(lang2cxx<alien_info, __internal__cxx__alien_info >(v));
}


/// Affiche le contenu d'une valeur de type action_hist
void afficher_action_hist(action_hist v)
{
  api_afficher_action_hist(lang2cxx<action_hist, __internal__cxx__action_hist >(v));
}


}
