/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

/// Position sur la carte, donnée par deux coordonnées
typedef struct __internal__cxx__position {
  int ligne;
  int colonne;
} __internal__cxx__position;

/// Échantillon, défini par deux types d’éléments
typedef struct __internal__cxx__echantillon {
  case_type element1;
  case_type element2;
} __internal__cxx__echantillon;

/// Position d’un échantillon, donnée par deux positions adjacentes
typedef struct __internal__cxx__position_echantillon {
  __internal__cxx__position pos1;
  __internal__cxx__position pos2;
} __internal__cxx__position_echantillon;

/// Action représentée dans l’historique. L’action ``placer_echantillon`` utilise ``pos1`` et ``pos2``. L’action ``transmuter`` utilise ``pos1``. L’action ``catalyser`` utilise ``pos1``, ``id_apprenti`` et ``nouvelle_case``. L’action ``donner_echantillon`` n’est pas représentée dans l’historique, car ``echantillon_tour`` donne l’information.
typedef struct __internal__cxx__action_hist {
  action_type atype;
  __internal__cxx__position pos1;
  __internal__cxx__position pos2;
  int id_apprenti;
  case_type nouvelle_case;
} __internal__cxx__action_hist;

/// Place l’échantillon du tour sur l’établi, avec les coordonnées de deux cases adjacentes.
extern "C" erreur api_placer_echantillon(__internal__cxx__position pos1, __internal__cxx__position pos2);

/// Provoque la transformation chimique de l’élément à la case ciblée, ainsi que tous les éléments adjacents du même type, ceux du même type adjacents à ces derniers, etc. Ils disparaissent alors tous dans leur transmutation en or ou en catalyseur.
extern "C" erreur api_transmuter(__internal__cxx__position pos);

/// Utilise un catalyseur sur la case ciblée de l'apprenti indiqué. Transforme l’ancien élément en l’élément indiqué.
extern "C" erreur api_catalyser(__internal__cxx__position pos, int id_apprenti, case_type terrain);

/// Définit l’échantillon que l’adversaire recevra à son prochain tour.
extern "C" erreur api_donner_echantillon(__internal__cxx__echantillon echantillon_donne);

/// Renvoie le type d’une case donnée, ou 0 si la case est invaide.
extern "C" case_type api_type_case(__internal__cxx__position pos, int id_apprenti);

/// Indique si une case donnée est vide ou contient un élément. Renvoie faux en cas d'erreur.
extern "C" bool api_est_vide(__internal__cxx__position pos, int id_apprenti);

/// Renvoie la propriété de l’élément sur une case donnée. Un élément invalide n'a pas de propriété.
extern "C" element_propriete api_propriete_case(__internal__cxx__position pos, int id_apprenti);

/// Renvoie la propriété d’un type de case donné.
extern "C" element_propriete api_propriete_case_type(case_type ctype);

/// Renvoie la taille de la région à laquelle appartient un élément. Renvoie -1 si la position est invalide.
extern "C" int api_taille_region(__internal__cxx__position pos, int id_apprenti);

/// Renvoie la liste des positions des cases composant la région à laquelle appartient un élément donné. Renvoie une liste vide en cas d'erreur.
extern "C" std::vector<__internal__cxx__position> api_positions_region(__internal__cxx__position pos, int id_apprenti);

/// Détermine si le placement d’un échantillon est valide.
extern "C" bool api_placement_possible_echantillon(__internal__cxx__echantillon echantillon_a_placer, __internal__cxx__position pos1, __internal__cxx__position pos2, int id_apprenti);

/// Renvoie la liste des placements possibles pour un échantillon donné sur l’établi d’un apprenti donné. Renvoie une liste vide en cas d'erreur.
extern "C" std::vector<__internal__cxx__position_echantillon> api_placements_possible_echantillon(__internal__cxx__echantillon echantillon_a_placer, int id_apprenti);

/// Renvoie la liste des actions jouées par l’adversaire pendant son tour, dans l’ordre chronologique.
extern "C" std::vector<__internal__cxx__action_hist> api_historique(void);

/// Renvoie votre numéro d’apprenti.
extern "C" int api_moi(void);

/// Renvoie le numéro d’apprenti de votre adversaire.
extern "C" int api_adversaire(void);

/// Renvoie la quantité d’or amassée par l’apprenti désigné par le numéro ``id_apprenti``. Renvoie 0 si ``id_apprenti`` est invalide (attention, le score d’un apprenti valide peut aussi être 0).
extern "C" int api_score(int id_apprenti);

/// Renvoie le numéro du tour actuel.
extern "C" int api_tour_actuel(void);

/// Annule la dernière action. Renvoie ``false`` quand il n’y a pas d’action à annuler ce tour-ci.
extern "C" bool api_annuler(void);

/// Indique le nombre de catalyseurs en votre possession.
extern "C" int api_nombre_catalyseurs(void);

/// Indique l’échantillon reçu pour ce tour.
extern "C" __internal__cxx__echantillon api_echantillon_tour(void);

/// Indique si l’échantillon reçu pour ce tour a déjà été posé.
extern "C" bool api_a_pose_echantillon(void);

/// Indique si un échantillon a déjà été donné ce tour.
extern "C" bool api_a_donne_echantillon(void);

/// Renvoie la quantité d’or (et donc le score) obtenue par la transmutation de ``taille_region`` éléments transmutables en or.
extern "C" int api_quantite_transmutation_or(int taille_region);

/// Renvoie la quantité de catalyseurs obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
extern "C" int api_quantite_transmutation_catalyseur(int taille_region);

/// Renvoie la quantité d’or obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
extern "C" int api_quantite_transmutation_catalyseur_or(int taille_region);

/// Indique l’échantillon par défaut lors du premier tour
extern "C" __internal__cxx__echantillon api_echantillon_defaut_premier_tour(void);

/// Affiche l'état actuel des deux établis dans la console.
extern "C" void api_afficher_etablis(void);

/// Affiche le contenu d'une valeur de type case_type
extern "C" void api_afficher_case_type(case_type v);

/// Affiche le contenu d'une valeur de type element_propriete
extern "C" void api_afficher_element_propriete(element_propriete v);

/// Affiche le contenu d'une valeur de type erreur
extern "C" void api_afficher_erreur(erreur v);

/// Affiche le contenu d'une valeur de type action_type
extern "C" void api_afficher_action_type(action_type v);

/// Affiche le contenu d'une valeur de type position
extern "C" void api_afficher_position(__internal__cxx__position v);

/// Affiche le contenu d'une valeur de type echantillon
extern "C" void api_afficher_echantillon(__internal__cxx__echantillon v);

/// Affiche le contenu d'une valeur de type position_echantillon
extern "C" void api_afficher_position_echantillon(__internal__cxx__position_echantillon v);

/// Affiche le contenu d'une valeur de type action_hist
extern "C" void api_afficher_action_hist(__internal__cxx__action_hist v);

#endif
