import api

DOWN = (1, 0)
RIGHT = (0, 1)
LEFT = (0, -1)
UP = (-1, 0)

DIR_FROM_API = {
    api.direction.HAUT: UP,
    api.direction.DROITE: RIGHT,
    api.direction.GAUCHE: LEFT,
    api.direction.BAS: DOWN,
}
DIR_TO_API = {value: key for (key, value) in DIR_FROM_API.items()}
DIRECTIONS = tuple(DIR_FROM_API.values())

MOI = api.moi()
ENEMI = api.adversaire()

def debug(*args, **kwargs):
    if MOI == 1:
        print(*args, **kwargs)


def flag_debug(start, path):
    if MOI == 1:
        for dir, grip, *jump in path:
            start = add(start, dir)
            if grip:
                api.debug_afficher_drapeau(start, api.debug_drapeau.DRAPEAU_ROUGE)
            else:
                api.debug_afficher_drapeau(start, api.debug_drapeau.DRAPEAU_VERT)


def ddebug(f):
    def wrapper(*args):
        debug(args)
        r = f(*args)
        print(r)
        return r
    return wrapper

def add(a, b):
    return (a[0] + b[0], a[1] + b[1])

def sub(a, b):
    return (a[0] - b[0], a[1] - b[1])