from collections import defaultdict
from heapq import heappop, heappush
from game import *


class BasicBot:
    game: Game

    def __init__(self, game):
        self.game = game

    def _better_than(self, c1, c2):
        """Return wether c1 is smaller than c2."""

        for a, b in zip(c1, c2):
            if a < b:
                return True
            elif a > b:
                return False
        return False

    def chemins(self, nain):
        #                          (PM used, A used, turs
        costs = defaultdict(lambda: (4242, 1, 69))
        pred = defaultdict(lambda: None)
        heads = []
        heappush(heads, (0, nain.pos))
        costs[nain.pos] = (0, 0, 0)

        while heads:

            _, head = heappop(heads)
            c = costs[head]

            for dir in (UP, DOWN, LEFT, RIGHT):
                new = add(head, dir)

                cost, grip = self.game.move_cost(head, dir)

                # prevent beein silly
                if cost == INF: continue
                if nain.butin < 0 and new == self.game.my_taverne: continue
                if nain.butin > 0 and new == self.game.enemi_taverne: continue

                t = 0
                a = self.game.turns_to_break(new)
                m, grip = (cost, grip) if cost != -1 else self.game.move_cost(head, dir, CaseType.VIDE)
                if a == INF: continue

                if c[1] + a > 1:
                    t = c[0] + c[1] + a - 1
                    a = 1
                    m = m
                elif c[2] + m > api.NB_POINTS_DEPLACEMENT:
                    t = c[0] + 1
                    a = 0
                    m = m
                else:
                    t += c[0]
                    a += c[1]
                    m += c[2]

                assert t >= 0 and \
                       a in (0, 1) and \
                       m in range(api.NB_POINTS_DEPLACEMENT + 1), (t, a, m, c, head, dir)

                cost = t, a, m
                if self._better_than(cost, costs[new]):
                    costs[new] = cost
                    heappush(heads, (t*100 + a*10 + m, new))
                    pred[new] = (dir, grip)

            # Jump
            i = 1
            l, col = head
            while i < 4 and self.game.turns_to_break((l + i, col)) == 0:
                new = l + i, col

                if self.game.turns_to_break((l + i + 1, col)) > 0:
                    if self._better_than(c, costs[new]):
                        costs[new] = c
                        heappush(heads, (c[0] * 100 + c[1] * 10 + c[2], new))
                        pred[new] = (i, 0), False, "JUMP"

                i += 1


        return costs, pred

    def back_chemin(self, end, pred, start):
        path = []
        while end != start:
            if pred[end]:
                path.append(pred[end])
                end = sub(end, pred[end][0])
            else:
                return []
        return reversed(path)

    def value_minerai(self, costs, minerai, nain):
        c = costs[minerai.pos]
        dist = c[0] + c[1] + c[2] / api.NB_POINTS_DEPLACEMENT

        if minerai.butin * nain.butin < 0:  # oposite signs
            return -2 * abs(minerai.butin) + dist  # negatif
        return abs(minerai.butin / minerai.resi) - dist + 10

    def value_enemi(self, costs, enemi: Nain, nain):
        c = costs[enemi.pos]
        dist = c[0] + c[1] + c[2] / api.NB_POINTS_DEPLACEMENT

        if nain.vie < 4:
            return -100
        if enemi.butin * nain.butin < 0:
            return -100 # avoid

        return abs(enemi.butin) - dist

    def value_rope(self, pos):
        score = 0
        while self.game.map[pos].type == CaseType.VIDE:
            score += 1
            pos = pos[0] + 1, pos[1]

        return score

    def find_goal(self, nain, costs, pred):
        best = -10000
        f = lambda: 0

        def up(b, fun):
            nonlocal best, f
            if b > best:
                best = b
                f = fun

        # minerai
        best_minerai = None
        can_carry = {pos : m for pos, m in self.game.minerais.items() if m.butin + nain.butin <= api.BUTIN_MAX}
        if can_carry and nain.pa >= api.COUT_MINER:
            goal = max(can_carry, key=lambda m: self.value_minerai(costs, can_carry[m], nain))
            best_minerai = self.game.minerais[goal]
            score = self.value_minerai(costs, best_minerai, nain)
            up(score, lambda: self.move_to(nain, goal, pred))

        # ennemis
        score = 0
        targets = [en for en in self.game.enemi
                        if en.butin * nain.butin > 0
                            or en.butin == 0]
        if targets:
            en = max(targets, key=lambda e: self.value_enemi(costs, e, nain))
            score = self.value_enemi(costs, en, nain)

            up(score, lambda: self.move_to(nain, en.pos, pred))

        # maison
        if best_minerai is None:
            up(100, lambda: self.move_to(nain, self.game.my_taverne, pred))
        #
        # # Placer corde first
        # if all(n.pa == api.NB_POINTS_ACTION for n in self.game.nains):
        #     for pos, dir in self.game.voisins(nain.pos, CaseType.VIDE):
        #         score = self.value_rope(pos)
        #         up(score, lambda: self.game.rope(nain, dir) )

        f()

    def update(self):
        for nain in self.game.nains:
            costs, pred = self.chemins(nain)
            # goal = self.find_goal(nain, costs, pred)
            goal = max(self.game.minerais, key=lambda m: self.value_minerai(costs, self.game.minerais[m], nain))
            if nain.butin + self.game.minerais[goal].butin > api.BUTIN_MAX:
                yield self.move_to(nain, self.game.my_taverne, pred)
            elif nain.butin < -142:
                yield self.move_to(nain, self.game.enemi_taverne, pred)
            else:
                yield self.move_to(nain, goal, pred)

        # If no action taken, put a rope the highest we can
        if all(nain.pa == api.NB_POINTS_ACTION for nain in self.game.nains):
            candidats = [(n, p, d) for n in self.game.nains for p, d in self.game.voisins(n.pos, CaseType.VIDE)]
            best = max(candidats, key=lambda m: self.value_rope(m[1]), default=None)
            if best: yield self.game.rope(best[0], best[2])

    def move_to(self, nain: Nain, pos, pred):
        chemin = list(self.back_chemin(pos, pred, nain.pos))

        flag_debug(nain.pos, chemin)

        for dir, grip, *jump in chemin:
            if jump:
                if nain.lacher():
                    return
                nain.grip()
            else:
                cout, _= self.game.move_cost(nain.pos, dir)

                if grip:
                    nain.grip()
                else:
                    if nain.lacher():
                        return

                # supp = api.cout_de_deplacement(nain.id, DIR_TO_API[dir])
                # if cout != supp:
                #     debug("DIFF:", cout, supp, dir, nain.pos)
                #     api.debug_afficher_drapeau(nain.pos, api.debug_drapeau.DRAPEAU_ROUGE)

                if cout == -1:
                    if self.game.mine(nain, dir):
                        return

                if nain.move(dir):
                    return
