#![allow(unused)]
pub mod api;
mod ffi;
fn main() {}
macro_rules! d {
    ($val:expr) => {
        unsafe {
            if true
            //AID == 1
            // && api::tour_actuel() == 0
            {
                dbg!($val)
            } else {
                $val
            }
        }
    };
}
#[derive(Eq, Ord, Hash, Clone, Debug, PartialEq, PartialOrd)]
struct Plateau(Vec<Case>, Vec<Nain>);
trait IdxPos {
    type Res;
    fn idx(&self, pos: Position) -> Option<&Self::Res>;
    fn idx_mut(&mut self, pos: Position) -> Option<&mut Self::Res>;
}
impl<T> IdxPos for Vec<T> {
    type Res = T;
    fn idx(&self, pos: Position) -> Option<&Self::Res> {
        if pos.in_bounds() {
            unsafe {
                Some(
                    self.get_unchecked(pos.i as usize * api::TAILLE_MINE as usize + pos.j as usize),
                )
            }
        } else {
            None
        }
    }
    fn idx_mut(&mut self, pos: Position) -> Option<&mut T> {
        if pos.in_bounds() {
            unsafe {
                Some(
                    self.get_unchecked_mut(
                        pos.i as usize * api::TAILLE_MINE as usize + pos.j as usize,
                    ),
                )
            }
        } else {
            //d!(pos);
            None
        }
    }
}
impl IdxPos for Plateau {
    type Res = Case;
    fn idx(&self, pos: Position) -> Option<&Case> {
        self.0.idx(pos)
    }
    fn idx_mut(&mut self, pos: Position) -> Option<&mut Case> {
        self.0.idx_mut(pos)
    }
}
use api::{CaseType, Direction, Erreur, Nain, Position, INVALID_POSITION};
use std::collections::BinaryHeap;
use std::os::raw::{c_double, c_int, c_void};
static mut AID: i32 = -1;
static mut ATA: Position = INVALID_POSITION;
static mut BID: i32 = -1;
static mut BTA: Position = INVALID_POSITION;
#[derive(Eq, Ord, Hash, Clone, Debug, PartialEq, PartialOrd)]
enum Case {
    Air {
        nains: Vec<usize>,
        /// corde?
        corde: bool,
    },
    Pie {
        /// resistance
        res: i32,
        /// rendement
        pri: i32,
    },
    Obs, // redo
}
impl Case {
    fn is_solid(self) -> bool {
        match self {
            Case::Pie { .. } | Case::Obs =>true,
            _ => false,
        }
    }
}
impl Erreur {
    fn into(self) -> Result<(), Erreur> {
        match self {
            Erreur::Ok => Ok(()),
            _ => Err(self),
        }
    }
}
impl Position {
    fn in_bounds(self) -> bool {
        self.i >= 0 && self.i < api::TAILLE_MINE && self.j >= 0 && self.j < api::TAILLE_MINE
    }
    fn to(mut self, dir: Direction) -> Self {
        if self != INVALID_POSITION {
            match dir {
                Direction::Haut => self.i -= 1,
                Direction::Bas => self.i += 1,
                Direction::Gauche => self.j -= 1,
                Direction::Droite => self.j += 1,
                Direction::ErreurDirection => self = INVALID_POSITION,
            }
        };
        self
    }
    fn minus(self, othe: Position) -> Position {
        Position {
            i: self.i - othe.i,
            j: self.j - othe.j,
        }
    }
    fn norm(self) -> i32 {
        self.i.abs() + self.j.abs()
    }
}
fn respawn(nain: Nain) -> Nain {
    Nain {
        moi: nain.moi,
        pid: nain.pid,
        nid: nain.nid,
        pos: unsafe {
            if nain.moi {
                ATA
            } else {
                BTA
            }
        },
        accroche: false,
        vie: api::VIE_NAIN,
        pm: api::NB_POINTS_DEPLACEMENT,
        pa: api::NB_POINTS_ACTION,
        butin: 0,
    }
}
fn gravity(pla: &mut Plateau, posa: Position) {
    gravity_aux(pla, posa, 1);
    gravity_aux(pla, posa, 2);
    fn gravity_aux(pla: &mut Plateau, posa: Position, pid: i32) {
        let ((non_tombe, tombe), cordet): ((Vec<usize>, _), _) = match pla.idx(posa).cloned() {
            Some(Case::Air { nains, corde }) => (
                nains.iter().partition(|&&nain| {
                    let nain = pla.1[nain];
                    nain.pid != pid || nain.accroche
                }),
                corde,
            ),
            _ => return,
        };
        let mut chu = 0;
        let mut posb = posa;
        while let Some(Case::Air { corde, nains }) = pla.idx(posb.to(Direction::Bas)).cloned() {
            let posc = posb.to(Direction::Bas);
            if nains.iter().any(|&nain| pla.1[nain as usize].pid != pid) {
                break;
            }
            chu += 1;
            if let Case::Air { corde, nains } = pla.idx_mut(posb.to(Direction::Bas)).unwrap() {
                *corde |= cordet;
            }
            posb = posb.to(Direction::Bas);
        }
        let deg = match chu {
            h if h < 4 => 0,
            h => 1 << (h - 4),
        };
        for &i in &tombe {
            let mut nain = pla.1[i];
            nain.vie -= deg;
            if (nain.vie <= 0) {
                nain = respawn(nain);
            }
        }
        match pla.idx_mut(posa) {
            Some(Case::Air { nains, .. }) => {
                *nains = non_tombe;
            }
            _ => panic!(),
        };
        match pla.idx_mut(posb) {
            Some(Case::Air { nains, corde }) => {
                nains.extend(tombe);
                *corde |= cordet;
            }
            _ => panic!(),
        };
    }
}

fn cout_de_deplacement(pla: &Plateau, nain: Nain, dir: Direction) -> i32 {
    if nain.accroche {
        if let Some(Case::Air { corde, .. }) = pla.idx(nain.pos) {
            if *corde {
                return api::COUT_ESCALADER_CORDE;
            }
        }
        api::COUT_ESCALADER
    } else {
        api::COUT_DEPLACEMENT
    }
}
fn accrocher(nain: &mut Nain, accroche: bool) -> Result<(), Erreur> {
    if accroche && !nain.accroche {
        api::agripper(nain.nid).into()?;
        nain.pa -= api::COUT_AGRIPPER;
    } else if !accroche && nain.accroche {
        api::lacher(nain.nid).into()?;
    }
    nain.accroche = accroche;
    Ok(())
}
fn deplacer(nain_id: usize, pla: &mut Plateau, dir: Direction) -> Result<(), Erreur> {
    let nain = pla.1[nain_id];
    let posa = nain.pos;
    let posb = posa.to(dir);
    let cout_pm = cout_de_deplacement(pla, nain, dir);
    {
        let nain = &mut pla.1[nain_id];
        nain.pm -= cout_pm;
        api::deplacer(nain.nid, dir).into()?;
        nain.pos = posb;
    }
    gravity(pla, nain.pos);
    Ok(())
}

fn miner(nain_id: usize, pla: &mut Plateau, dir: Direction) -> Result<(), Erreur> {
    let nain = pla.1[nain_id];
    api::miner(nain.nid, dir).into()?;
    let posb = nain.pos.to(dir);
    if !posb.in_bounds() {
        return Erreur::HorsLimites.into();
    }
    let pri = {
        let case = pla.idx_mut(posb).unwrap();
        let (b, pri) = match case {
            Case::Pie { res, pri } => {
                *res -= 1;
                (*res == 0, *pri)
            }
            _ => (false, 0),
        };
        if b {
            *case = Case::Air {
                nains: Vec::new(),
                corde: false,
            };
        }
        pri
    };
    {
        let nain = &mut pla.1[nain_id];
        nain.butin = std::cmp::min(api::BUTIN_MAX, nain.butin + pri);
        nain.pa -= api::COUT_MINER;
    }
    gravity(pla, nain.pos);
    Ok(())
}
fn deplacer_smart(nain_id: usize, pla: &mut Plateau, dir: Direction) -> Result<(), Erreur> {
    let nain = pla.1[nain_id];
    let posa = nain.pos;
    let posb = posa.to(dir);
    match api::type_case(posb) {
        CaseType::Granite => {
            {
                let nain = &mut pla.1[nain_id];
                accrocher(nain, true)?;
            }
            miner(nain_id, pla, dir)
        }
        CaseType::Libre => {
            {
                let decroche = pla.0.idx(posa.to(Direction::Bas)).cloned().map_or(true, Case::is_solid)
                    && pla.0.idx(posb.to(Direction::Bas)).cloned().map_or(true, Case::is_solid);
                let nain = &mut pla.1[nain_id];
                accrocher(nain, !decroche)?;
            }
            deplacer(nain_id, pla, dir)
        }
        _ => Err(Erreur::ObstacleMur),
    }
}
fn aller_tmp(nain_id: usize, pla: &mut Plateau, arr: Position) {
    let nain = pla.1[nain_id];
    let che = api::chemin(nain.pos, arr); // replace by proper dji
    for dir in che {
        if deplacer_smart(nain_id, pla, dir).is_err() {
            break;
        }
    }
}

fn plateau() -> Plateau {
    let info_nains: Vec<_> = (0..api::NB_NAINS)
        .map(|nid| api::info_nain(api::moi(), nid))
        .chain((0..api::NB_NAINS).map(|nid| api::info_nain(api::adversaire(), nid)))
        .collect();
    let mut res: Plateau = Plateau(
        (0..api::TAILLE_MINE * api::TAILLE_MINE)
            .map(|ij| {
                let pos = Position {
                    i: ij / api::TAILLE_MINE,
                    j: ij % api::TAILLE_MINE,
                };
                match api::type_case(pos) {
                    CaseType::Libre => Case::Air {
                        corde: false, //
                        nains: Vec::new(),
                    },
                    CaseType::Granite => Case::Pie { res: 1, pri: 0 },
                    _ => Case::Obs,
                }
            })
            .collect(),
        info_nains.clone(),
    );
    for pos in api::liste_minerais() {
        let inf = api::info_minerai(pos);
        *res.idx_mut(pos).unwrap() = Case::Pie {
            res: inf.resistance,
            pri: inf.rendement,
        }
    }
    for (i, nain) in info_nains
        .iter()
        .filter(|nain| nain.pos.in_bounds())
        .enumerate()
    {
        if let Case::Air { nains, .. } = res.idx_mut(nain.pos).unwrap() {
            nains.push(i)
        }
    }
    *res.idx_mut(unsafe { BTA }).unwrap() = Case::Obs;
    res
}

// TODO handle gravity
//

fn partie_init() {
    unsafe {
        AID = api::moi();
        BID = api::adversaire();
        ATA = api::position_taverne(AID);
        BTA = api::position_taverne(BID);
    }
}

// Fonction appelée à chaque tour.
fn jouer_tour() {
    let (aid, bid, ata, bta) = unsafe { (AID, BID, ATA, BTA) };
    let tour = api::tour_actuel();
    let asco = api::score(aid);
    let bsco = api::score(bid);
    let mut pla = plateau();
    for i in 0..api::NB_NAINS as usize {
        let nain = pla.1[i];
        let posa = nain.pos;
        let mut poss = api::liste_minerais();
        poss.sort_by_cached_key(|&posb| {
            if let Some(Case::Pie { res, pri }) = pla.idx(posb).clone() {
                if *res == 0 {
                    0
                } else if *pri <= 0 {
                    std::i32::MAX / 8
                } else {
                    75 * posb.minus(posa).norm() - 100 * (*pri - nain.butin) / *res
                }
            } else {
                std::i32::MAX
            }
        });
        if (!poss.is_empty()) {
            let posb = poss[0];
            if let Some(Case::Pie { res, pri }) = pla.idx(posb).cloned() {
                if pri > 0 && tour + res + 4 * nain.butin <= api::NB_TOURS {
                    //d!(posb);
                    aller_tmp(i, &mut pla, posb);
                // api::debug_afficher_drapeau(pos, api::DebugDrapeau::DrapeauBleu);
                } else if nain.butin > 0 {
                    aller_tmp(i, &mut pla, ata);
                }
            }
        }
        let nain = pla.1[i];
        let posa = nain.pos;
        for (dir, posb) in [
            Direction::Bas,
            Direction::Haut,
            Direction::Gauche,
            Direction::Droite,
        ]
        .iter()
        .map(|&dir| (dir, posa.to(dir)))
        {
            if let Some(Case::Air { nains, .. }) = pla.idx(nain.pos) {
                if nains.iter().map(|&j| pla.1[j]).any(|nain| !nain.moi) {
                    d!(nains);
                    d!(tour);
                    api::miner(i as i32, dir); // optimize choice
                }
            }
        }
    }
}

// Fonction appelée à la fin de la partie.
fn partie_fin() {
    // fonction a completer
}

fn djikstra(pla: &Plateau, nain: &Nain) {
    #[derive(Eq, Ord, Hash, Clone, Copy, Debug, PartialEq, PartialOrd)]
    struct Ret {
        tour: i32,
        pa: i32,
        pm: i32,
    };
    #[derive(Eq, Ord, Hash, Clone, Copy, Debug, PartialEq, PartialOrd)]
    struct Sta {
        tour: i32,
        pa: i32,
        pm: i32,
        pos: Position,
    };
    let mut pri = BinaryHeap::<Sta>::new();
    let mut rets = vec![None; (api::TAILLE_MINE * api::TAILLE_MINE) as usize];
    pri.push(Sta {
        tour: 0, // maybe end game logic
        pa: nain.pa,
        pm: nain.pm,
        pos: nain.pos,
    });
    while let Some(Sta {
        tour,
        pa,
        pm,
        pos: posa,
    }) = pri.pop()
    {
        if rets.idx(posa).cloned().map_or(true, |sta| sta.is_some()) {
            continue;
        }
        *rets.idx_mut(posa).unwrap() = Some(Ret { tour, pa, pm });
        for (dir, posb) in [
            Direction::Bas,
            Direction::Haut,
            Direction::Gauche,
            Direction::Droite,
        ]
        .iter()
        .map(|&dir| (dir, posa.to(dir)))
        {
            // logic
            // logic
        }
        //
    }
}

// nain logic: tavern + dead (replace respawn mut nai)