// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Types de cases
enum CaseType {
  LIBRE, // <- Case libre, qui peut abriter une corde et des nains (standard)
  GRANITE, // <- Granite (standard), qui peut cacher du minerai
  OBSIDIENNE, // <- Obsidienne
  ERREUR_CASE, // <- Erreur
}

// Direction
enum Direction {
  HAUT, // <- Direction : haut
  BAS, // <- Direction : bas
  GAUCHE, // <- Direction : gauche
  DROITE, // <- Direction : droite
  ERREUR_DIRECTION, // <- Erreur
}

// Erreurs possibles
enum Erreur {
  OK, // <- L'action s'est effectuée avec succès.
  PA_INSUFFISANTS, // <- Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action.
  PM_INSUFFISANTS, // <- Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement.
  HORS_LIMITES, // <- L'action est en dehors des limites de la mine.
  DIRECTION_INVALIDE, // <- La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action.
  ID_NAIN_INVALIDE, // <- Le nain (standard) spécifié n'existe pas.
  OBSTACLE_MUR, // <- La position spécifiée est un mur.
  OBSTACLE_NAIN, // <- La position spécifiée est un nain (standard) adverse.
  OBSTACLE_CORDE, // <- Il y a déjà une corde dans la direction spécifiée.
  PAS_DE_CIBLE, // <- Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée.
  NAIN_MORT, // <- Le nain (standard) spécifié est mort.
  PAS_ACCROCHE, // <- Le nain (standard) n'est pas accroché.
  DEJA_ACCROCHE, // <- Le nain (standard) est déjà accroché.
  PAS_DE_CORDE, // <- Il n'y a pas de corde dans la direction spécifiée.
  DRAPEAU_INVALIDE, // <- Le drapeau spécifié n'existe pas.
}

// Types d'actions
enum ActionType {
  ACTION_DEPLACER, // <- Action ``deplacer``
  ACTION_LACHER, // <- Action ``lacher``
  ACTION_MINER, // <- Action ``miner``
  ACTION_POSER_CORDE, // <- Action ``poser_corde``
  ACTION_TIRER, // <- Action ``tirer``
  ACTION_AGRIPPER, // <- Action ``agripper``
}

// Types de drapeaux de débug
enum DebugDrapeau {
  AUCUN_DRAPEAU, // <- Aucun drapeau, enlève le drapeau présent
  DRAPEAU_BLEU, // <- Drapeau bleu
  DRAPEAU_VERT, // <- Drapeau vert
  DRAPEAU_ROUGE, // <- Drapeau rouge
}

// Position dans la mine, donnée par deux coordonnées.
class Position {
  public int ligne; // Coordonnée : ligne
  public int colonne; // Coordonnée : colonne
}

// Minerai à récolter
class Minerai {
  public int resistance; // Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse
  public int rendement; // Valeur marchande du bloc de minerai
}

// Nain (standard)
class Nain {
  public Position pos = new Position(); // Position actuelle du nain (standard)
  public int vie; // Point(s) de vie restant du nain (standard)
  public int pa; // Point(s) d'action restant du nain (standard)
  public int pm; // Point(s) de déplacement restant du nain (standard)
  public boolean accroche; // Le nain (standard) est accroché à la paroi ou à une corde
  public int butin; // Valeur marchande totale que le nain (standard) possède
}

// Action de déplacement représentée dans l'historique.
class ActionHist {
  public ActionType atype; // Type de l'action
  public int id_nain; // Numéro du nain (standard) concerné par l'action
  public Direction dir; // Direction visée par le nain (standard) durant le déplacement
  public Direction sens; // Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche.
}

public class Interface
{
  // Taille de la mine (longueur et largeur).
  public static final int TAILLE_MINE = 31;

  // Nombre de tours à jouer avant la fin de la partie.
  public static final int NB_TOURS = 100;

  // Nombre de points de déplacement par tour par nain (standard).
  public static final int NB_POINTS_DEPLACEMENT = 5;

  // Nombre de points d'action par tour par nain (standard).
  public static final int NB_POINTS_ACTION = 6;

  // Nombre de points de vie d'un nain (standard).
  public static final int VIE_NAIN = 10;

  // Nombre de joueurs.
  public static final int NB_JOUEURS = 2;

  // Nombre de nains (standard) par joueur.
  public static final int NB_NAINS = 6;

  // Dégât infligé par un coup de pioche à un nain (standard).
  public static final int DEGAT_PIOCHE = 3;

  // Valeur cumulée maximale des minerais qu'un nain (standard) peut emporter avec lui.
  public static final int BUTIN_MAX = 25;

  // Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case.
  public static final int COUT_DEPLACEMENT = 1;

  // Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case lorsqu'il est agrippé.
  public static final int COUT_ESCALADER = 2;

  // Nombre de points de déplacement pour qu'un nain (standard) se déplace vers une case occupée par une corde lorsqu'il est agrippé.
  public static final int COUT_ESCALADER_CORDE = 1;

  // Nombre de points d'action pour qu'un nain (standard) mine un bloc.
  public static final int COUT_MINER = 6;

  // Nombre de points d'action pour qu'un nain (standard) tire sur une corde.
  public static final int COUT_TIRER = 1;

  // Nombre de points d'action pour qu'un nain (standard) lâche la paroi.
  public static final int COUT_LACHER = 0;

  // Nombre de points d'action pour qu'un nain (standard) s'agrippe à la paroi.
  public static final int COUT_AGRIPPER = 0;

// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
  public static native Direction[] chemin(Position pos1, Position pos2);

// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
  public static native Erreur deplacer(int id_nain, Direction dir);

// Le nain (standard) ``id_nain`` lâche la paroi.
  public static native Erreur lacher(int id_nain);

// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
  public static native Erreur agripper(int id_nain);

// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
  public static native Erreur miner(int id_nain, Direction dir);

// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
  public static native Erreur tirer(int id_nain, Direction dir_corde, Direction sens);

// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
  public static native Erreur poser_corde(int id_nain, Direction dir);

// Affiche le drapeau spécifié sur la case indiquée.
  public static native Erreur debug_afficher_drapeau(Position pos, DebugDrapeau drapeau);

// Renvoie le type d'une case donnée.
  public static native CaseType type_case(Position pos);

// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
  public static native Position[] liste_cordes();

// Indique si une corde se trouve sur une case donnée.
  public static native boolean corde_sur_case(Position pos);

// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
  public static native int nain_sur_case(Position pos);

// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
  public static native Nain info_nain(int id_joueur, int id_nain);

// Renvoie la liste de tous les minerais dans la mine.
  public static native Position[] liste_minerais();

// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
  public static native Minerai info_minerai(Position pos);

// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
  public static native int cout_de_deplacement(int id_nain, Direction dir);

// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
  public static native Position position_taverne(int id_joueur);

// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
  public static native ActionHist[] historique();

// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
  public static native int score(int id_joueur);

// Renvoie votre numéro de joueur.
  public static native int moi();

// Renvoie le numéro de joueur de votre adversaire.
  public static native int adversaire();

// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
  public static native boolean annuler();

// Retourne le numéro du tour actuel.
  public static native int tour_actuel();

// Affiche le contenu d'une valeur de type case_type
  public static native void afficher_case_type(CaseType v);

// Affiche le contenu d'une valeur de type direction
  public static native void afficher_direction(Direction v);

// Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

// Affiche le contenu d'une valeur de type action_type
  public static native void afficher_action_type(ActionType v);

// Affiche le contenu d'une valeur de type debug_drapeau
  public static native void afficher_debug_drapeau(DebugDrapeau v);

// Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

// Affiche le contenu d'une valeur de type minerai
  public static native void afficher_minerai(Minerai v);

// Affiche le contenu d'une valeur de type nain
  public static native void afficher_nain(Nain v);

// Affiche le contenu d'une valeur de type action_hist
  public static native void afficher_action_hist(ActionHist v);

}
