use api::*;
use state::*;
use plateau::{Case, Mov, Plateau};

use std::collections::BinaryHeap;
use std::cmp::Reverse;

macro_rules! d{()=>{println!("I AM HERE")};($f:expr)=>{println!("{:?}",$f)};}

impl Case {
  pub fn is_interesting(self, agent: Agent, tour: i32) -> bool {
    if self.mur { return false; }
    if let Some(alien) = self.alien {
      if tour + 3 < alien.tour_invasion {
        // en avance
        return false;
      }
      if
        tour > alien.tour_invasion + alien.duree_invasion
          - (NB_TOURS_CAPTURE - alien.capture_en_cours)
      {
        // en retard
        return false;
      }
      if let Some(agent_case) = self.agent {
        return agent == agent_case;
      }
      return true;
    }
    false
  }
}

/// Returns interesting positions
pub fn dijkstra(agent_id: Agent, current: &CurrentInfo)
  -> (Vec<(Position, i32)>, Plateau<Option<(Position, Mov)>>) {
  let agent = current.agents[agent_id.player][agent_id];
  let plateau = &current.plateau;
  let mut visited = Plateau::fill(|_| false, true);
  let mut pred = Plateau::fill(|_| None, None);
  let mut aliens = Vec::new();
  let mut heap = BinaryHeap::new();

  heap.push(Reverse((current.tour, 0, None, agent.pos)));

  while let Some(Reverse((tour, cost_in_tour, pred_mov, pos))) =
    heap.pop()
  {
    if visited[pos] { continue; }
    visited[pos] = true;
    pred[pos] = pred_mov;
    for (new_pos, mov) in current.plateau.moves(pos) {
      if !visited[new_pos] {
        let (tour, cost_in_tour) =
          if cost_in_tour + mov.cost() > NB_POINTS_ACTION
          {
            (tour + 1, 0)
          } else {
            (tour, cost_in_tour + mov.cost())
          }
        ;
        heap.push(
          Reverse((tour, cost_in_tour, Some((pos, mov)), new_pos))
        );
      }
    }
    if plateau[pos].is_interesting(agent_id, tour) {
      aliens.push((pos, tour));
    }
  }
  (aliens, pred)
}
