#![allow(unused_macros)]
pub mod api;
mod ffi;
pub mod state;
pub mod plateau;
pub mod logic;
pub mod order;

use api::*;
use state::*;
use order::Order;
macro_rules! d{()=>{println!("I AM HERE")};($f:expr)=>{println!("{:?}",$f)};}
// Fonction appelée au début de la partie.
fn partie_init() -> State
{
  let ever = EverInfo::get();
  let current = CurrentInfo::get(&ever);
  let state = State {
    ever,
    current,
    agents_strat: AgentLocal([AgentState {}; NB_AGENTS]),
  };
  // if state.ever.id_me == 1 {println!("{:#?}", state.current); }
  // d!(state.current.plateau.moves(Position(17,0)));
  state
}

// Fonction appelée à chaque tour.
fn jouer_tour(state: &mut State)
{
  state.current = CurrentInfo::get(&state.ever);
  //d!(state.current.plateau);
  let mut reserved = Vec::new();
  for &agent in AGENTS {
    let agent = Agent { player: Player::Moi, id: agent };
    // let pos = position_agent(moi(), agent.id);
    let dij = logic::dijkstra(agent, &state.current);
    // d!(dij);
    // d!(state.current.plateau[Position(11, 5)]);
    if let Some(&(obj_pos, _)) = dij.0
      .iter()
      .filter(|&(obj_pos, _)| !reserved.contains(obj_pos))
      .next()
    {
      let mut movs = Vec::new();
      let pred = dij.1;
      // d!(pos);
      let mut pos = obj_pos;
      while let Some((pred_pos, mov)) = pred[pos] {
        pos = pred_pos;
        movs.push(mov);
      }

      debug_afficher_drapeau(obj_pos, DebugDrapeau::DrapeauBleu);
      for &mov in movs.iter().rev().take(NB_POINTS_ACTION as usize) {
        Order::mov(&mut state.current, agent, mov);
      }
      debug_afficher_drapeau(obj_pos, DebugDrapeau::AucunDrapeau);

      reserved.push(obj_pos);
    }
  }
}

// Fonction appelée à la fin de la partie.
fn partie_fin(_state: &mut State)
{
}
