#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Compilez avec -lbsd */
#include <bsd/stdlib.h>
#include <unistd.h>

#define MAX_POINTS    128

char map[25][25+1] = {0};

void usage(void) {
  extern char *__progname;

  fprintf(stderr,
    "%s: [-x blocks] [-n aliens]\n"
    "Generates a random map with the specified amount of ice blocks, and aliens.\n",
    __progname);
  exit(EXIT_FAILURE);
}

int main(int argc, char *argv[]) {
  int opt, x = 128, n = 32;

  while ((opt = getopt(argc, argv, "x:n:")) != -1)
    switch (opt) {
    case 'x':
      if (sscanf(optarg, "%i", &x) != 1)
        usage();
      break;
    case 'n':
      if (sscanf(optarg, "%i", &n) != 1)
        usage();
      break;
    default:
      usage();
    }
  argc -= optind;
  argv += optind;

  for (int x = 0; x < 25; x++)
    for (int y = 0; y < 25; y++)
      map[x][y] = '.';
  while (x > 0) {
    int u, v;

    u = arc4random_uniform(25), v = arc4random_uniform(25);
    if (map[u][v] == '.') {
      map[u][v] = 'X';
      x--;
    }
  }
  for (int x = 0; x < 25; x++)
    puts(map[x]);

  for (int _ = 0; _ < 8; _++)
    while (true) {
      int u, v;

      u = arc4random_uniform(25), v = arc4random_uniform(25);
      if (map[u][v] == '.') {
        printf("%d %d\n", u, v);
        map[u][v] = 'X';
        break;
      }
    }

  printf("%d\n", n);
  while (n > 0) {
    int u, v;

    u = arc4random_uniform(25), v = arc4random_uniform(25);
    if (map[u][v] == '.') {
      int t = arc4random_uniform(100), d = arc4random_uniform(100 - t + 1);
      printf("%d %d %d %d %d\n", u, v, (int)arc4random_uniform(MAX_POINTS), t, d);
      map[u][v] = 'X';
      n--;
    }
  }
  return 0;
}
