//! Clafoutis rouillé:
//!
//! Comme chacun sait, un vieux clafoutis ne peut pas pousser, car il ne sait que glisser
//! et marcher (son déambulateur est rouillé).
//! Cette IA utilise donc le cerveau très développé d'un clafoutis pour aider les PIB à
//! capturer les aliens.
//! De plus, ce clafoutis utilise ses talents de clairvoyance pour dépêcher à l'avance
//! ses agents sur le lieu d'apparition des aliens
//!
//! Pour cela, le clafoutis utilise un algorithme de plus court chemin (Dijkstra) pour
//! calculer, pour chaque agent double de clafoutis, le plus court chemin pour atteindre
//! un alien hostile à la cause des clafoutis/
//! Il évite aussi d'envoyer inutilement deux agents pour aller chercher le même voleur
//! de clafoutis extraterrestre.
//!
//! Cependant, ce clafoutis se refuse encore à la discrimination, il ne distingue pas
//! les aliens en fonction de leur hostilité, et ne souhaite enlever que l'alien le plus
//! proche de chaque agent, sans tenir compte des agents du clafoutis adverse.
//!
//! Bien évidemment, ne pas pousser est un désavantage pour le clafoutis, mais au moins il
//! ne perd pas de temps à pousser sans cesse pour s'emparer d'un alien convoité par les
//! deux parties, et qui au final, profitera de la lutte acharnée pour s'échapper.

pub mod api;
mod ffi;
pub mod state;
pub mod plateau;
pub mod logic;
pub mod order;

use api::*;
use state::*;
use order::Order;

fn partie_init() -> State
{
  let ever = EverInfo::get();
  let current = CurrentInfo::get(&ever);
  State { ever, current, }
}

fn jouer_tour(state: &mut State)
{
  state.current = CurrentInfo::get(&state.ever);
  let mut reserved = Vec::new();
  for &agent in AGENTS {
    let agent = Agent { player: Player::Moi, id: agent };
    let dij = logic::dijkstra(agent, &state.current);

    if let Some(&(obj_pos, _)) = dij.0
      .iter()
      .filter(|&(obj_pos, _)| !reserved.contains(obj_pos))
      .next()
    {
      let mut movs = Vec::new();
      let pred = dij.1;
      let mut pos = obj_pos;
      while let Some((pred_pos, mov)) = pred[pos] {
        pos = pred_pos;
        movs.push(mov);
      }

      debug_afficher_drapeau(obj_pos, DebugDrapeau::DrapeauBleu);
      for &mov in movs.iter().rev() {
        if Order::mov(&mut state.current, agent, mov).is_err() {
          break;
        }
      }
      debug_afficher_drapeau(obj_pos, DebugDrapeau::AucunDrapeau);

      reserved.push(obj_pos);

    }
  }
}

fn partie_fin(_state: &mut State) {}
