use api::*;
use state::*;
use plateau::Mov;

pub struct Order;

impl Order {
  pub fn mov(state: &mut CurrentInfo, agent: Agent, mov: Mov) -> Result<(),()> {
    let plateau = &mut state.plateau;
    let AgentInfo { pos, pa } = &mut state.agents[Player::Moi][agent];
    if mov.cost() > *pa {
      return Err(())
    }
    let new_pos = plateau.mov(*pos, mov);
    plateau[*pos].agent = None;
    *pos = new_pos;
    *pa -= mov.cost();
    plateau[*pos].agent = Some(agent);

    match mov {
      Mov::One (dir) => deplacer(agent.id, dir),
      Mov::Many(dir) => glisser (agent.id, dir),
      Mov::Push(_)   => unimplemented!(),
    };
    Ok(())
  }
}
