use api::*;
use state::*;
use std::ops::{Index, IndexMut};
use std::cmp::{min, max};
macro_rules! d{()=>{println!("I AM HERE")};($f:expr)=>{println!("{:?}",$f)};}
#[derive(Clone, Debug)]
pub struct Plateau<T>(pub Vec<T>, T);

impl<T> Index<Position> for Plateau<T> {
  type Output = T;
  fn index(&self, pos: Position) -> &T  {
    if pos.is_valid() {
      &self.0[(pos.0 * TAILLE_BANQUISE + pos.1) as usize]
    } else {
      &self.1
    }
  }
}

impl<T> IndexMut<Position> for Plateau<T> {
  fn index_mut (&mut self, pos: Position) -> &mut T  {
    assert!(pos.is_valid());
    &mut self.0[(pos.0 * TAILLE_BANQUISE + pos.1) as usize]
  }
}

impl<T> Plateau<T> {
  pub fn fill(f: impl FnMut(Position) -> T, default: T) -> Self {
    Plateau(Position::every().map(f).collect(), default)
  }
}

impl Plateau<Case> {
  pub fn mov(&self, mut pos: Position, mov: Mov) -> Position {
    match mov {
      Mov::One(dir) => {
        let new_pos = pos.in_dir(dir);
        if new_pos.is_free(&self) {
          pos = new_pos;
        }
      },
      Mov::Many(dir) => {
        while pos.in_dir(dir).is_free(&self) {
          pos = pos.in_dir(dir)
        }
      },
      Mov::Push(_) => unimplemented!(),
    }
    pos
  }

  pub fn moves(&self, pos: Position) -> Vec<(Position, Mov)> {
    Mov::every().into_iter().map(|mov| (self.mov(pos, mov), mov)).collect()
  }

}

#[derive(Clone, Copy, Debug)]
pub struct Case {
  pub agent: Option<Agent>,
  pub alien: Option<AlienInfo>,
  pub mur: bool,
}

impl Case {
  pub fn is_free(self) -> bool {
    !self.mur && self.agent.is_none()
  }
}

#[derive(Clone, Copy, Debug, Eq, Hash, PartialEq, PartialOrd, Ord)]
pub enum Mov {
  One(Direction),
  Many(Direction),
  Push(Direction),
}

impl Mov {
  pub fn cost(self) -> i32 {
    match self {
      Mov::One(_) => COUT_DEPLACEMENT,
      Mov::Many(_) => COUT_GLISSADE,
      Mov::Push(_) => COUT_POUSSER,
    }
  }

  pub fn every() -> Vec<Mov> {
    Direction::every().flat_map(|dir| vec![
      Mov::One(dir),
      Mov::Many(dir),
    ]).collect()
  }
}

impl Position {
  pub fn every() -> impl Iterator<Item = Position> {
    (0..TAILLE_BANQUISE).flat_map(|i| (0..TAILLE_BANQUISE).map(move |j| Position(i, j)))
  }

  fn in_dir(self, dir: Direction) -> Self {
    match dir {
      Direction::Nord  => Position(self.0 - 1, self.1),
      Direction::Sud   => Position(self.0 + 1, self.1),
      Direction::Ouest => Position(self.0, self.1 - 1),
      Direction::Est   => Position(self.0, self.1 + 1),
    }
  }
  pub fn voisins(&self) -> Vec<(Position, Direction)> {
    Direction::every().map(|dir| (self.in_dir(dir), dir)).collect()
  }

  pub fn is_free(self, plateau: &Plateau<Case>) -> bool {
    plateau[self].is_free()
  }

  pub fn is_valid(self) -> bool {
    max(self.0, self.1) < TAILLE_BANQUISE && min(self.0, self.1) >= 0
  }
}

impl Direction{
  pub fn every() -> impl Iterator<Item = Direction> {
    [Direction::Nord, Direction::Sud, Direction::Ouest, Direction::Est].iter().cloned()

  }
}
