use api::*;
use plateau::*;
use std::ops::{Index, IndexMut};
pub static mut STATE: Option<State> = None;

#[derive(Clone, Debug)]
pub struct State {
  pub ever: EverInfo,
  pub current: CurrentInfo,
  pub agents_strat: AgentLocal<AgentState>,
}

#[derive(Clone, Debug)]
pub struct EverInfo {
  pub plateau: Plateau<Case>,
}

impl EverInfo {
  pub fn get() -> Self {
    let mut plateau = Plateau::fill(|pos| {
      let mur = match type_case(pos) {
        CaseType::Libre => false,
        CaseType::Mur => true,
        CaseType::Erreur => panic!("invalid pos"),
      };
      Case {
        alien: None,
        agent: None,
        mur,
      }
    }, Case {
        alien: None,
        agent: None,
        mur: true,
    });
    for alien in liste_aliens() {
      plateau[alien.pos].alien = Some(alien);
    }
    for &player in PLAYERS {
      for &agent in AGENTS {
        let pos = position_agent(player, agent);
        plateau[pos].agent = Some(Agent {
          player: Player::from_id(player),
          id: agent
        });
      }
    }
    EverInfo {
      plateau,
    }
  }
}

#[derive(Clone, Debug)]
pub struct CurrentInfo {
  pub plateau: Plateau<Case>,
  pub tour: i32,
  pub hist: Vec<ActionHist>,
  pub score: PlayerLocal<i32>,
  pub aliens: Vec<AlienInfo>,
  pub agents: PlayerLocal<AgentLocal<AgentInfo>>,
}

impl CurrentInfo {
  pub fn get(info: &EverInfo) -> Self {
    let tour = tour_actuel();
    let mut aliens = Vec::new();
    let mut plateau = Plateau::fill(|pos| {
      Case {
        alien: None,
        agent: None,
        mur: info.plateau[pos].mur,
      }
    }, Case {
        alien: None,
        agent: None,
        mur: true,
    });
    for alien in liste_aliens() {
      let alien = {
        if alien.tour_invasion <= tour {
          if alien_sur_case(alien.pos) {
            info_alien(alien.pos)
          } else {
            None
          }
        } else {
          Some(alien)
        }
      };
      alien.map(|alien| {
        plateau[alien.pos].alien = Some(alien);
        aliens.push(alien)
      });
    }
    for &player in PLAYERS {
      for &agent in AGENTS {
        let pos = position_agent(player, agent);
        plateau[pos].agent = Some(Agent {
          player: Player::from_id(player),
          id: agent,
        });
      }
    }

    CurrentInfo {
      plateau,
      tour,
      aliens,
      hist: historique(),
      score: PlayerLocal(score(moi()), score(toi())),
      agents: AgentLocal::fill(|agent| AgentInfo {
        pos: position_agent(agent.player.to_id(), agent.id),
        pa: NB_POINTS_ACTION
      }),
    }
  }
}

#[derive(Clone, Copy, Debug, Eq, Hash, PartialEq, PartialOrd, Ord)]

pub struct Agent {
  pub player: Player,
  pub id: i32,
}

#[derive(Clone, Copy, Debug, Eq, Hash, PartialEq, PartialOrd, Ord)]
pub enum Player {
  Moi,
  Toi,
}

impl Player {
  pub fn from_id(id: i32) -> Self{
    if id == moi() { Player::Moi } else { Player::Toi }
  }

  pub fn to_id(self) -> i32 {
    match self {
      Player::Moi => moi(),
      Player::Toi => toi(),
    }
  }

}

#[derive(Clone, Debug)]
pub struct PlayerLocal<T>(pub T, pub T);

impl<T> Index<Player> for PlayerLocal<T> {
  type Output = T;
  fn index(&self, player: Player) -> &T  {
    match player {
      Player::Moi => &self.0,
      Player::Toi => &self.1,
    }
  }
}

impl<T> IndexMut<Player> for PlayerLocal<T> {
  fn index_mut (&mut self, player: Player) -> &mut T  {
    match player {
      Player::Moi => &mut self.0,
      Player::Toi => &mut self.1,
    }
  }
}

impl<T> PlayerLocal<T> {
  pub fn fill(mut f: impl FnMut(Player) -> T) -> Self {
    PlayerLocal(f(Player::Moi), f(Player::Toi))
  }
}

#[derive(Clone, Debug)]
pub struct AgentLocal<T>(pub [T; NB_AGENTS as usize]);

impl<T> Index<Agent> for AgentLocal<T> {
  type Output = T;
  fn index(&self, agent: Agent) -> &T  {
    &self.0[agent.id as usize]
  }
}

impl<T> IndexMut<Agent> for AgentLocal<T> {
  fn index_mut (&mut self, agent: Agent) -> &mut T  {
    &mut self.0[agent.id as usize]
  }
}

impl<T> AgentLocal<T> {
  pub fn fill(mut f: impl FnMut(Agent) -> T) -> PlayerLocal<Self> {
    PlayerLocal::fill(|player| {
      AgentLocal([
        f(Agent {player, id: 0}),
        f(Agent {player, id: 1}),
        f(Agent {player, id: 2}),
        f(Agent {player, id: 3}),
      ])
    })
  }
}

#[derive(Clone, Copy, Debug)]
pub struct AgentInfo {
  pub pos: Position,
  pub pa: i32,
}

#[derive(Clone, Copy, Debug)]
pub struct AgentState {
}
