#include <iostream>
#include <random>
#include "prologin.hh"
using namespace std;
default_random_engine gener;
const position directions[] = {{1, 0}, {0, -1}, {-1, 0}, {0, 1}};

int pla_tries;
int me;
int him;
int tour;
int catalysant;
int points[MAX_JOUEURS];
int max_regions[MAX_JOUEURS];
int types_info[MAX_JOUEURS][NB_TYPE_CASES];
position_echantillon ech_bef = {INVALID};

case_type etabli[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
int region[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
region_info regions_info[MAX_JOUEURS][MAX_REGIONS];

echantillon ech_tour;
vector<position_echantillon> ech_tour_pla;
int dfs_region(int region_id, int joueur, position courant)
{
  region[joueur][courant.ligne][courant.colonne] = region_id;
  case_type ty_case = etabli[joueur][courant.ligne][courant.colonne];
  int region_taille = 1;
  for(position dir: directions)
  {
    position next = dir+courant;
    if(next.inbound() && region[joueur][next.ligne][next.colonne] == INVALID && ty_case == etabli[joueur][next.ligne][next.colonne]) {
      region_taille += dfs_region(region_id, joueur, next);
    }
  }
  return region_taille;
}
void get_api()
{
  tour = tour_actuel();
  ech_tour = echantillon_tour();

  for(int joueur = 1; joueur < 3; joueur++)
  {
    points[joueur]=score(joueur);
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        etabli[joueur][i][j] = type_case({i, j}, joueur);
      }
    }
  }
}

void calc_info()
{
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        region[joueur][i][j] = INVALID;
      }
    }
    for(int i = VIDE; i < NB_TYPE_CASES; i++)
    {
      types_info[joueur][i] = 0;
    }
  }
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        types_info[joueur][etabli[joueur][i][j]]++;
      }
    }
    int region_id = 0;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        if(etabli[joueur][i][j] && region[joueur][i][j] == INVALID)
        {
          int taille = dfs_region(region_id, joueur, {i, j});
          regions_info[joueur][region_id] =
          {
            taille,
            {i, j},
            etabli[joueur][i][j],
            propriete_case_type(etabli[joueur][i][j]),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            quantite_transmutation_or(taille) :
            quantite_transmutation_catalyseur_or(taille),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            0 :
            quantite_transmutation_catalyseur(taille)
          };
          region_id++;
        }
      }
    }
    max_regions[joueur] = region_id;
  }
  catalysant = nombre_catalyseurs();
  ech_tour_pla = placements_possible_echantillon(ech_tour, me);
}
void catalyse()
{
  /*while(catalysant&&pla_tries--)
  {
    int maxi = PAS_BEAUCOUP;
    position maxi_m = {};
    case_type maxi_t = VIDE;
    int maxi_r = INVALID;
    int maxi_le = PAS_BEAUCOUP;
    for(int i = 0; i < max_regions[me]; i++)
    {
      if(regions_info[me][i].propriete==TRANSMUTABLE_CATALYSEUR)
      {
        continue;
      }
      if(maxi_le <= regions_info[me][i].taille)
      {
        maxi_le = regions_info[me][i].taille;
        maxi_r = i;
      }
    }
    if(maxi_r == INVALID)
    {
      break;
    }
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        position m = {i, j};
        if(!etabli[me][m.ligne][m.colonne])
        {
          continue;
        }
        for(int k = 0; k < 4; k++)
        {
          position dira = directions[k];
          position a = m + dira;
          int taille = regions_info[me][etabli[me][a.ligne][a.colonne]].taille + 1;
          if(!(a.inbound() &&
               etabli[me][a.ligne][a.colonne]&&
               etabli[me][a.ligne][a.colonne] != etabli[me][m.ligne][m.colonne]) &&
               region[me][a.ligne][a.colonne] == maxi_r)
          {
            continue;
          }
          for(int l = 0; l < 4; l++)
          {
            if(l==k)
            {
              continue;
            }
            position dirb = directions[l];
            position b = m + dirb;
            if(b.inbound() &&
               etabli[me][a.ligne][a.colonne] == etabli[me][b.ligne][b.colonne])
            {
              taille += regions_info[me][etabli[me][b.ligne][b.colonne]].taille;
            }
          }
          if(taille > maxi) {
            maxi = taille;
            maxi_m = m;
            maxi_t = etabli[me][a.ligne][a.colonne];
          }
        }
      }
    }
    catalyser(maxi_m, me, maxi_t);
    etabli[me][maxi_m.ligne][maxi_m.colonne]=maxi_t;
    calc_info();
  }*/
  while(catalysant&&pla_tries--)
  {
    int maxi = PAS_BEAUCOUP;
    position maxi_m = {};
    case_type maxi_t = VIDE;
    case_type rmax = PLOMB;
    int maxir = PAS_BEAUCOUP;
    for(case_type i = PLOMB; i < NB_TYPE_CASES; i=(case_type)(i+1)){
      if(types_info[me][i]>maxir)
      {
        maxir = types_info[me][i];
        rmax = i;
      }
    }
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        position m = {i, j};
        if(!etabli[me][m.ligne][m.colonne])
        {
          continue;
        }
        for(int k = 0; k < 4; k++)
        {
          position dira = directions[k];
          position a = m + dira;
          int taille = regions_info[me][etabli[me][a.ligne][a.colonne]].taille + 1;
          if(!(a.inbound() &&
               etabli[me][a.ligne][a.colonne]&&
               etabli[me][a.ligne][a.colonne]!=etabli[me][m.ligne][m.colonne] &&
             etabli[me][a.ligne][a.colonne]==rmax))
          {
            continue;
          }
          for(int l = 0; l < 4; l++)
          {
            if(l==k)
            {
              continue;
            }
            position dirb = directions[l];
            position b = m + dirb;
            if(b.inbound() &&
               etabli[me][a.ligne][a.colonne] == etabli[me][b.ligne][b.colonne])
            {
              taille += regions_info[me][etabli[me][b.ligne][b.colonne]].taille;
            }
          }
          if(taille > maxi) {
            maxi = taille;
            maxi_m = m;
            maxi_t = etabli[me][a.ligne][a.colonne];
          }
        }
      }
    }
    catalyser(maxi_m, me, maxi_t);
    etabli[me][maxi_m.ligne][maxi_m.colonne]=maxi_t;
    calc_info();
  }
}

void dernier_recours()
{
  for(int i=0; i < max_regions[me]; i++)
  {
    region_info info = regions_info[me][i];
    if(info.gold>0)
    {
      transmuter(info.representant);
    }
  }
}
void placer()
{
  if(!pla_tries)
  {
    return dernier_recours();
  }
  pla_tries--;
  if(ech_tour_pla.empty())
  {
    int mini = BEAUCOUP;
    int min_reg = INVALID;
    for(int i=0; i < max_regions[me]; i++)
    {
      region_info info = regions_info[me][i];
      if(info.gold > 0 && info.gold<mini){
        mini = info.gold;
        min_reg = i;
      }
    }
    if(min_reg!=INVALID)
    {
      transmuter(regions_info[me][min_reg].representant);
      get_api();
      calc_info();
    }
    placer();
  }
  else
  {
    int maxi = PAS_BEAUCOUP;
    position_echantillon max_ech = {INVALID};
    for(position_echantillon ech : ech_tour_pla)
    {
      /*if(ech.pos1 == ech_bef.pos1 || ech.pos2 == ech_bef.pos2 || ech.pos1 == ech_bef.pos2 || ech.pos2 == ech_bef.pos1)
      {
        continue;
      }*/
      int taille1 = 1, taille2 = 1;
      for(position dir: directions)
      {
        position e1 = ech.pos1+dir;
        position e2 = ech.pos2+dir;
        if(etabli[me][e1.ligne][e1.colonne]==etabli[me][ech.pos1.ligne][ech.pos1.colonne])
        {
          taille1 += regions_info[me][etabli[me][e1.ligne][e1.colonne]].taille;
        }
        if(etabli[me][e2.ligne][e2.colonne]==etabli[me][ech.pos2.ligne][ech.pos2.colonne])
        {
          taille2 += regions_info[me][etabli[me][e2.ligne][e2.colonne]].taille;
        }
      }
      int maxim = max(taille1, taille2);
      int ne = maxim*maxim;
      if(ne >= maxi) {
        maxi = ne;
        max_ech = ech;
      }
    }
    placer_echantillon(max_ech.pos1, max_ech.pos2);
    //ech_bef = max_ech;
  }
}

void choisir_echantillon()
{
  uniform_int_distribution<> a(0, 1);
  uniform_int_distribution<> b(1, 5);
  int retries = 20;
  if(a(gener)){
    case_type i = ech_tour.element1;
    case_type j = VIDE;
    do {
      j = (case_type)b(gener);
    } while((!j||i==j)&&retries--);
    donner_echantillon({i, j});
  } else {
      case_type i = ech_tour.element2;
      case_type j = VIDE;
      do {
        j = (case_type)b(gener);
      } while((!j||i==j)&&retries--);
    donner_echantillon({i, j});
  }
}

void transmuter_cata()
{
  int mini = BEAUCOUP;
  int min_reg = INVALID;
  for(int i=0; i < max_regions[me]; i++)
  {
    region_info info = regions_info[me][i];
    if(info.propriete==TRANSMUTABLE_CATALYSEUR&&info.taille>=3&&info.cata<mini){
      mini = info.cata;
      min_reg = i;
    }
  }
  if(min_reg!=INVALID)
  {
    transmuter(regions_info[me][min_reg].representant);
    get_api();
    calc_info();
  }
}

void transmuter_or()
{
  for(int i=0; i < max_regions[me]; i++)
  {
    region_info info = regions_info[me][i];
    if(info.taille>=6){
      transmuter(info.representant);
      get_api();
      calc_info();
      return transmuter_or();
    }
  }
}

void partie_init()
{
  random_device rd;
  gener = default_random_engine(rd());
  me = moi();
  him = adversaire();
}

/// Fonction appelée à chaque tour./
void jouer_tour()
{
  choisir_echantillon();
  pla_tries = 100;
  get_api();
  calc_info();
  transmuter_cata();
  placer();
  get_api();
  calc_info();
  catalyse();
  transmuter_or();
  catalyse();
  transmuter_or();
  if(tour >= NB_TOURS-1||!a_pose_echantillon())
  {
    dernier_recours();
    catalyse();
    dernier_recours();
  }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // THE GAME
}
