#include <iostream>
#include <random>
#include "prologin.hh"
using namespace std;

default_random_engine gener;
const position directions[] = {{1, 0}, {0, -1}, {-1, 0}, {0, 1}};

int me;
int him;
int tour;
int points[MAX_JOUEURS];
int max_regions[MAX_JOUEURS];

case_type etabli[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
int region[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
region_info regions_info[MAX_JOUEURS][MAX_REGIONS];

echantillon ech_tour;
vector<position_echantillon> ech_tour_pla;
int dfs_region(int region_id, int joueur, position courant)
{
  region[joueur][courant.ligne][courant.colonne] = region_id;
  case_type ty_case = etabli[joueur][courant.ligne][courant.colonne];
  int region_taille = 1;
  for(position dir: directions)
  {
    position next = dir+courant;
    if(next.inbound() && region[joueur][next.ligne][next.colonne] == INVALID && ty_case == etabli[joueur][next.ligne][next.colonne]) {
      region_taille += dfs_region(region_id, joueur, next);
    }
  }
  return region_taille;
}

void remplir_infos()
{
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        region[joueur][i][j] = INVALID;
      }
    }
  }

  ech_tour_pla.clear();

  tour = tour_actuel();
  for(int joueur = 1; joueur < 3; joueur++)
  {
    points[joueur]=score(joueur);
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        etabli[joueur][i][j] = type_case({i, j}, joueur);
      }
    }
    int region_id = 0;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        if(etabli[joueur][i][j] && region[joueur][i][j] == INVALID)
        {
          int taille = dfs_region(region_id, joueur, {i, j});
          regions_info[joueur][region_id] =
          {
            taille,
            {i, j},
            type_case({i, j}, joueur),
            propriete_case({i, j}, joueur),
            propriete_case({i, j}, joueur) == TRANSMUTABLE_OR ?
            quantite_transmutation_or(taille) :
            quantite_transmutation_catalyseur_or(taille),
            propriete_case({i, j}, joueur) == TRANSMUTABLE_OR ?
            0 :
            quantite_transmutation_catalyseur(taille)
          };
          region_id++;
        }
      }
    }
    max_regions[joueur] = region_id;
  }
  ech_tour = echantillon_tour();
  ech_tour_pla = placements_possible_echantillon(ech_tour, me);
}

void placer()
{
  if(ech_tour_pla.empty())
  {
    for(int i=0; i < max_regions[me]; i++)
    {
      region_info info = regions_info[me][i];
      if(info.gold>0){
        transmuter(info.representant);
      }
    }
  } else {
    uniform_int_distribution<> dis(0, ech_tour_pla.size()-1);
    int i = dis(gener);
    placer_echantillon(ech_tour_pla[i].pos1, ech_tour_pla[i].pos2);
  }
  //cout << max_regions[me] << endl;
}

void choisir_echantillon()
{
  uint mini = BEAUCOUP;
  echantillon min_ech = {};
  for(int i = PLOMB; i < NB_TYPE_CASES; i++)
  {
    if(i!=ech_tour.element1)
    {
      echantillon nou_ech = {ech_tour.element1, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
    if(i!=ech_tour.element2)
    {
      echantillon nou_ech = {ech_tour.element2, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
    cout << mini << endl;
  }
  donner_echantillon(min_ech);
}

void partie_init()
{
  random_device rd;
  gener = default_random_engine(rd());
  me = moi();
  him = adversaire();
}

/// Fonction appelée à chaque tour./
void jouer_tour()
{
  remplir_infos();
  placer();
  choisir_echantillon();
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // THE GAME
}
