#include <iostream>
#include <random>
#include "prologin.hh"
using namespace std;

default_random_engine gener;
const position directions[] = {{1, 0}, {0, -1}, {-1, 0}, {0, 1}};

int me;
int him;
int tour;
int points[MAX_JOUEURS];
int max_regions[MAX_JOUEURS];

case_type etabli[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
int region[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
region_info regions_info[MAX_JOUEURS][NB_CASES];
int types_info[MAX_JOUEURS][NB_TYPE_CASES];

echantillon ech_tour;
int dfs_region(int region_id, int joueur, position courant)
{
  region[joueur][courant.ligne][courant.colonne] = region_id;
  case_type ty_case = etabli[joueur][courant.ligne][courant.colonne];
  int region_taille = 1;
  for(position dir: directions)
  {
    position next = dir+courant;
    if(next.inbound() && region[joueur][next.ligne][next.colonne] == INVALID && ty_case == etabli[joueur][next.ligne][next.colonne]) {
      region_taille += dfs_region(region_id, joueur, next);
    }
  }
  return region_taille;
}

void get_api()
{
  tour = tour_actuel();
  for(int joueur = 1; joueur < 3; joueur++)
  {
    points[joueur]=score(joueur);
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        etabli[joueur][i][j] = type_case({i, j}, joueur);
      }
    }
  }
}

void calc_info()
{
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        region[joueur][i][j] = INVALID;
      }
    }
    for(int i = VIDE; i < NB_TYPE_CASES; i++)
    {
      types_info[joueur][i] = 0;
    }
  }
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        types_info[joueur][etabli[joueur][i][j]]++;
      }
    }
    int region_id = 0;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        if(etabli[joueur][i][j] && region[joueur][i][j] == INVALID)
        {
          int taille = dfs_region(region_id, joueur, {i, j});
          regions_info[joueur][region_id] =
          {
            taille,
            {i, j},
            etabli[joueur][i][j],
            propriete_case_type(etabli[joueur][i][j]),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            quantite_transmutation_or(taille) :
            quantite_transmutation_catalyseur_or(taille),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            0 :
            quantite_transmutation_catalyseur(taille)
          };
          region_id++;
        }
      }
    }
    max_regions[joueur] = region_id;
  }
  ech_tour = echantillon_tour();
}

int score_pot(int joueur)
{
  calc_info();
  int acc = 0;
  for(int i = 0; i < max_regions[joueur]; i++){
    if(regions_info[joueur][i].gold>0)
    {
      acc += regions_info[joueur][i].gold;
    }
  }
  return acc - max_regions[joueur];
}

void place_ech()
{
  int before = PAS_BEAUCOUP;
  position bestpos1 = {}, bestpos2 = {};
  for(int i = 0; i < TAILLE_ETABLI; i++)
  {
    for(int j = 0; j < TAILLE_ETABLI; j++)
    {
      for(position dir: directions)
      {
        position a = {i, j};
        position b = a + dir;
        for(position dir2: directions){
;
        }
        if(!(b.inbound()))
        {
          continue;
        }
        int after = PAS_BEAUCOUP;
        case_type tmpa = ech_tour.element1, tmpb = ech_tour.element1;
        if(region[me][a.ligne][a.colonne]&&regions_info[me][region[me][a.ligne][a.colonne]].gold<=0){
          after-=3;
        }
        if(region[me][b.ligne][b.colonne]&&regions_info[me][region[me][b.ligne][b.colonne]].gold<=0){
          after-=3;
        }
        swap(tmpa, etabli[me][a.ligne][a.colonne]);
        swap(tmpb, etabli[me][b.ligne][b.colonne]);
        after += score_pot(me);
        cout << i << ' ' << j  << ' ' << b.ligne << ' ' << b.colonne << score_pot(me) << endl;
        swap(tmpa, etabli[me][a.ligne][a.colonne]);
        swap(tmpb, etabli[me][b.ligne][b.colonne]);
        if(after>before)
        {
          before = after;
          bestpos1 = a;
          bestpos2 = b;
        }
      }
    }
  }
  transmuter(bestpos1);
  transmuter(bestpos2);
  placer_echantillon(bestpos1, bestpos2);
}

void transmute()
{
  /*calc_info();
  if(ech_tour_pla.empty()||tour>=NB_TOURS-1)
  {
    for(int i=0; i < max_regions[me]; i++)
    {
      region_info info = regions_info[me][i];
      if(info.gold>0){
        transmuter(info.representant);
      }
    }
    calc_info();
    cout << types_info[me][VIDE] << endl;
    if(types_info[me][VIDE] > NB_CASES/2 && !ech_tour_pla.empty())
    {
      place_ech();
    }
  } else {
    place_ech();
  }
  //cout << max_regions[me] << endl;*/
  place_ech();
}

void choisir_echantillon()
{
  uint mini = BEAUCOUP;
  echantillon min_ech = {};
  for(int i = PLOMB; i < NB_TYPE_CASES; i++)
  {
    if(i!=ech_tour.element1)
    {
      echantillon nou_ech = {ech_tour.element1, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
    if(i!=ech_tour.element2)
    {
      echantillon nou_ech = {ech_tour.element2, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
  }
  donner_echantillon(min_ech);
}

void partie_init()
{
  random_device rd;
  gener = default_random_engine(rd());
  me = moi();
  him = adversaire();
}

/// Fonction appelée à chaque tour./
void jouer_tour()
{
  get_api();
  transmute();
  choisir_echantillon();
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // THE GAME
}
