#include <iostream>
#include <random>
#include "prologin.hh"
using namespace std;

default_random_engine gener;
const position directions[] = {{1, 0}, {0, -1}, {-1, 0}, {0, 1}};

int pla_tries;
int me;
int him;
int tour;
int catalysant;
int points[MAX_JOUEURS];
int max_regions[MAX_JOUEURS];
int types_info[MAX_JOUEURS][NB_TYPE_CASES];

case_type etabli[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
int region[MAX_JOUEURS][TAILLE_ETABLI][TAILLE_ETABLI];
region_info regions_info[MAX_JOUEURS][MAX_REGIONS];

echantillon ech_tour;
vector<position_echantillon> ech_tour_pla;
int dfs_region(int region_id, int joueur, position courant)
{
  region[joueur][courant.ligne][courant.colonne] = region_id;
  case_type ty_case = etabli[joueur][courant.ligne][courant.colonne];
  int region_taille = 1;
  for(position dir: directions)
  {
    position next = dir+courant;
    if(next.inbound() && region[joueur][next.ligne][next.colonne] == INVALID && ty_case == etabli[joueur][next.ligne][next.colonne]) {
      region_taille += dfs_region(region_id, joueur, next);
    }
  }
  return region_taille;
}
void get_api()
{
  tour = tour_actuel();
  ech_tour = echantillon_tour();

  for(int joueur = 1; joueur < 3; joueur++)
  {
    points[joueur]=score(joueur);
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        etabli[joueur][i][j] = type_case({i, j}, joueur);
      }
    }
  }
}

void calc_info()
{
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        region[joueur][i][j] = INVALID;
      }
    }
    for(int i = VIDE; i < NB_TYPE_CASES; i++)
    {
      types_info[joueur][i] = 0;
    }
  }
  for(int joueur = 1; joueur < 3; joueur++)
  {
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        types_info[joueur][etabli[joueur][i][j]]++;
      }
    }
    int region_id = 0;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        if(etabli[joueur][i][j] && region[joueur][i][j] == INVALID)
        {
          int taille = dfs_region(region_id, joueur, {i, j});
          regions_info[joueur][region_id] =
          {
            taille,
            {i, j},
            etabli[joueur][i][j],
            propriete_case_type(etabli[joueur][i][j]),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            quantite_transmutation_or(taille) :
            quantite_transmutation_catalyseur_or(taille),
            propriete_case_type(etabli[joueur][i][j]) == TRANSMUTABLE_OR ?
            0 :
            quantite_transmutation_catalyseur(taille)
          };
          region_id++;
        }
      }
    }
    max_regions[joueur] = region_id;
  }
  catalysant = nombre_catalyseurs();
  ech_tour_pla = placements_possible_echantillon(ech_tour, me);
}
void catalyse()
{
  while(catalysant)
  {
    int maxi = PAS_BEAUCOUP;
    position maxi_m = {};
    case_type maxi_t = VIDE;
    for(int i = 0; i < TAILLE_ETABLI; i++)
    {
      for(int j = 0; j < TAILLE_ETABLI; j++)
      {
        position m = {i, j};
        if(!etabli[me][m.ligne][m.colonne])
          continue;
        for(int k = 0; k < 4; k++)
        {
          position dira = directions[k];
          position a = m + dira;
          int taille = regions_info[me][etabli[me][a.ligne][a.colonne]].taille + 1;
          if(!(a.inbound() &&
               etabli[me][a.ligne][a.colonne]&&
               etabli[me][a.ligne][a.colonne]!=etabli[me][m.ligne][m.colonne]))
            continue;
          for(int l = 0; l < 4; l++)
          {
            if(l==k)
              continue;
            position dirb = directions[l];
            position b = m + dirb;
            if(b.inbound() &&
               etabli[me][a.ligne][a.colonne] == etabli[me][b.ligne][b.colonne])
            {
              taille += regions_info[me][etabli[me][b.ligne][b.colonne]].taille;
            }
          }
          if(taille > maxi) {
            maxi = taille;
            maxi_m = m;
            maxi_t = etabli[me][a.ligne][a.colonne];
          }
        }
      }
    }
    catalyser(maxi_m, me, maxi_t);
    catalysant--;
    etabli[me][maxi_m.ligne][maxi_m.colonne]=maxi_t;
    calc_info();
  }
}

void dernier_recours()
{
  for(int i=0; i < max_regions[me]; i++)
  {
    region_info info = regions_info[me][i];
    if(info.gold>0)
    {
      transmuter(info.representant);
    }
  }
}
void placer()
{
  if(!pla_tries)
  {
    return dernier_recours();
  }
  pla_tries--;
  if(ech_tour_pla.empty())
  {
    int mini = BEAUCOUP;
    int min_reg = INVALID;
    for(int i=0; i < max_regions[me]; i++)
    {
      region_info info = regions_info[me][i];
      if(info.gold>0&&info.gold<mini){
        mini = info.gold;
        min_reg = i;
      }
    }
    transmuter(regions_info[me][min_reg].representant);
    get_api();
    calc_info();
    catalyse();
    placer();
  }
  else
  {
    int maxi = PAS_BEAUCOUP;
    position_echantillon max_ech = ech_tour_pla[0];
    for(position_echantillon ech : ech_tour_pla)
    {
      int taille1 = 1, taille2 = 1;
      for(position dir: directions)
      {
        position e1 = ech.pos1+dir;
        position e2 = ech.pos2+dir;
        if(etabli[me][e1.ligne][e1.colonne]==etabli[me][ech.pos1.ligne][ech.pos1.colonne])
        {
          taille1 += regions_info[me][etabli[me][e1.ligne][e1.colonne]].taille;
        }
        if(etabli[me][e2.ligne][e2.colonne]==etabli[me][ech.pos2.ligne][ech.pos2.colonne])
        {
          taille2 += regions_info[me][etabli[me][e2.ligne][e2.colonne]].taille;
        }
      }
      int maxim = max(taille1, taille2);
      int ne = maxim*maxim + (taille1 + taille2);
      if(ne > maxi) {
        maxi = ne;
        max_ech = ech;
      }
    }
    placer_echantillon(max_ech.pos1, max_ech.pos2);
  }
}

void choisir_echantillon()
{
  uint mini = BEAUCOUP;
  echantillon min_ech = {};
  for(int i = PLOMB; i < NB_TYPE_CASES; i++)
  {
    if(i!=ech_tour.element1)
    {
      echantillon nou_ech = {ech_tour.element1, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<=mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
    if(i!=ech_tour.element2)                //minimum dans caamp adverse
    {
      echantillon nou_ech = {ech_tour.element2, (case_type)(i)};
      uint nou = placements_possible_echantillon(nou_ech, him).size();
      if(nou<=mini) {
        mini = nou;
        min_ech = nou_ech;
      }
    }
  }
  donner_echantillon(min_ech);
}

void transmuter_cata()
{

}

void partie_init()
{
  random_device rd;
  gener = default_random_engine(rd());
  me = moi();
  him = adversaire();
}

/// Fonction appelée à chaque tour./
void jouer_tour()
{
  pla_tries = 10;
  get_api();
  calc_info();
  transmuter_cata();
  placer();
  choisir_echantillon();
  if(tour >= NB_TOURS-1)
  {
    dernier_recours();
  }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
  // THE GAME
}
