/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <cmath>
#include <set>
#include <map>
#include <queue>
#include <algorithm>

using namespace std;

int me, adv;
position myTav, advTav;
bool rush = false;
int num_m;
double best_rat;
int mi_li;

position newpos(int l, int c) { return {l, c}; }
position operator+(const position &a, const position &b) {
	return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position operator-(const position &a, const position &b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}
ostream& operator<<(ostream &stream, const position &p) {
	return stream << "(" << p.ligne << ", " << p.colonne << ")";
}
int pos_to_int(const position &p) { return p.ligne*TAILLE_MINE + p.colonne; }
position int_to_pos(int i) { return {i / TAILLE_MINE, i % TAILLE_MINE}; }
vector<position> dirs(4);

bool valid_pos(const position &p) {
	return p.ligne >= 0 && p.ligne < TAILLE_MINE
			&& p.colonne >= 0 && p.colonne < TAILLE_MINE;
}

int manhatan(const position &a, const position &b) {
	return abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne);
}
direction get_dir(const position &a, const position &b) {
	if(a == b) return ERREUR_DIRECTION;
	if(a.ligne == b.ligne) {
		if(a.colonne > b.colonne) return GAUCHE;
		else return DROITE;
	} else if(a.colonne == b.colonne) {
		if(a.ligne > b.ligne) return HAUT;
		else return BAS;
	}
	return ERREUR_DIRECTION;
}

/// Fonction appelée au début de la partie.
void partie_init() {
	dirs[HAUT] = {-1, 0};
	dirs[BAS] = {1, 0};
	dirs[GAUCHE] = {0, -1};
	dirs[DROITE] = {0, 1};

	me = moi();
	adv = adversaire();
	myTav = position_taverne(me);
	advTav = position_taverne(adv); 
}

double simu_fight(const nain &na, const position &p, int t) {
	if(nain_sur_case(p) != adv) return 0;
	vector<int> my_m, adv_m;
	double steal = 0;
	for(int i = 0; i < NB_NAINS; i++) {
		if(manhatan(info_nain(adv, i).pos, p) <= 3) {
			nain n2 = info_nain(adv, i);
			adv_m.push_back(-n2.vie);
			steal += 2 + (t + 4.2 * (n2.vie/3) < 1.2 * manhatan(advTav, n2.pos) ? 1.5 * n2.butin : 0);
		}
		if(manhatan(info_nain(me, i).pos, p) <= 3) my_m.push_back(-info_nain(me, i).vie);
	}
	if(manhatan(na.pos, p) > 3) my_m.push_back(-na.vie);
	sort(my_m.begin(), my_m.end());
	sort(adv_m.begin(), adv_m.end());
	while(true) {
		for(int i = 0; i < (int) my_m.size(); i++) {
			int s = adv_m.size();
			if(s == 0) return steal;
			adv_m[s-1] += DEGAT_PIOCHE;
			if(adv_m[s-1] >= 0) adv_m.pop_back();
		}
		for(int i = 0; i < (int) adv_m.size(); i++) {
			int s = my_m.size();
			if(s == 0) return DEGAT_PIOCHE-na.butin;
			my_m[s-1] += DEGAT_PIOCHE;
			if(my_m[s-1] >= 0) my_m.pop_back();
		}
	}
}

double val_mine(const minerai &a, double butin) {
	double rend = min(a.rendement, BUTIN_MAX);
	double res = rend / double(a.resistance);
	if(!rush) res -= (double(NB_TOURS - tour_actuel() + 0.8*butin) / double(num_m) + 0.1 * butin) * 0.21 * max(butin + rend - BUTIN_MAX, 0.0);
	return res;
}

double score_case(const position &p, int t, const nain &na) {
	if(p == myTav) return 0.85 * double(na.butin) / 25.0;
	if(p == advTav) return -1;
	if(na.butin > 0 && manhatan(na.pos, p) + manhatan(p, myTav) > 4.2*(NB_TOURS - tour_actuel())) return -1;
	t = max(t, 1);
	double dTav = manhatan(p, myTav) - 0.36*max(0, myTav.ligne - p.ligne);
	double sc = 2.0 * simu_fight(na, p, t) / double(t+10+dTav);
	bool ennemies = sc != 0;
	if(sc > 0 && na.butin < 0) sc -= na.butin * 0.2;
	double butin = na.butin;
	vector<minerai> mins;
	for(const position &d : dirs) {
		position p2 = p+d;
		if(!valid_pos(p2)) continue;
		if(type_case(p2) == GRANITE && info_minerai(p2).rendement > 0) {
			mins.push_back(info_minerai(p2));
		}
	}
	while(butin < BUTIN_MAX && !mins.empty()) {
		if(na.butin >= 0)
			sort(mins.begin(), mins.end(), [&butin](const minerai &a, const minerai &b) {
				return val_mine(a, butin) > val_mine(b, butin);
			});
		else
			sort(mins.begin(), mins.end(), [&butin](const minerai &a, const minerai &b) {
				return val_mine(a, butin) < val_mine(b, butin);
			});
		minerai m = mins[mins.size()-1];
		mins.pop_back();
		sc -= 0.05 * max(butin + min(BUTIN_MAX, m.rendement) - BUTIN_MAX, 0.0);
		butin = min(double(BUTIN_MAX), butin+m.rendement);
		t += 5 * pow(double(m.resistance), 0.75);
	}
	sc += 2.0 * (abs(butin) - abs(na.butin)) / double(t + dTav);
	if(sc < 0 && na.butin == 0 && ennemies) {
		int but = 0;
		for(int i = 0; i < NB_NAINS; i++) {
			nain n2 = info_nain(adv, i);
			if(manhatan(n2.pos, p) <= 3 && n2.butin > 0)
				but += n2.butin;
		}
		if(but > 0) sc = (0.0125*but) / max(4, min(t, 15));
		else sc = 0.0001;
	}
	return sc;
}

struct move_time {
	int turn, pm;
	move_time(int t=0, int p=0) {
		pm = p % 5;
		turn = t + (p / 5);
	}
	int to_int() { return 5*turn + pm; }
};
bool operator<(const move_time &a, const move_time &b) {
	return a.turn < b.turn || (a.turn == b.turn && a.pm < b.pm);
}
bool operator>(const move_time &a, const move_time &b) {
	return a.turn > b.turn || (a.turn == b.turn && a.pm > b.pm);
}
bool operator==(const move_time &a, const move_time &b) {
	return a.turn == b.turn && a.pm == b.pm;
}
move_time operator+(const move_time &a, int act) { 
	int p = a.pm + act;
	if(p > NB_POINTS_DEPLACEMENT) return move_time(a.turn+1, act);
	else if(p == NB_POINTS_DEPLACEMENT) return move_time(a.turn+1, 0);
	else return move_time(a.turn, p);
}
move_time& operator+=(move_time &a, const int &b) { 
	a = a+b;
	return a;
}
move_time int_to_mt(int a) { return move_time(a / 5, a % 5); }

struct dij_s {
	position pos, pred;
	int t;
	dij_s(position p, position pr, int t): pos(p), pred(pr), t(t) {}
};
bool operator<(const dij_s &a, const dij_s &b) {
	return a.t < b.t;
}

bool can_walk(const position &p) {
	position p2 = p + dirs[BAS];
	return !valid_pos(p2) || type_case(p2) != LIBRE || nain_sur_case(p2) == adv;
}

vector<dij_s> dijkstra(const position &p0, int max_ti, bool tavSeen=false, bool can_mine=true) {
	vector<dij_s> res;
	vector<vector<pair<position, position>>> q(500);
	int ds[TAILLE_MINE][TAILLE_MINE];
	for(int i = 0; i < TAILLE_MINE; i++)
		for(int j = 0; j < TAILLE_MINE; j++)
			ds[i][j] = 500;
	q[0].push_back({p0, p0});
	ds[p0.ligne][p0.colonne] = 0;
	int d0 = 0;
	while(d0 < 500) {
		if(tavSeen && d0 > max_ti) break;
		if(q[d0].empty()) {
			d0 ++;
			continue;
		}
		position p = q[d0][q[d0].size()-1].first;
		position pred = q[d0][q[d0].size()-1].second;
		q[d0].pop_back();
		if(d0 > ds[p.ligne][p.colonne]) continue;
		if(p == myTav) tavSeen = true;
		res.push_back(dij_s(p, pred, d0));
		for(const position &d : dirs) {
			position p2 = p+d;
			if(!valid_pos(p2)) continue;
			if(p2 == advTav || type_case(p2) == OBSIDIENNE) continue;
			move_time t2 = int_to_mt(d0);
			if(nain_sur_case(p2) == adv) {
				for(int i = 0; i < NB_NAINS; i++)
					if(info_nain(adv, i).pos == p2)
						t2.turn += (info_nain(adv, i).vie + 2) / 3;
				if(type_case(p) != GRANITE && nain_sur_case(p) != adv) t2.turn -= - 1;
			}
			if(type_case(p2) == GRANITE) {
				if(!can_mine) continue;	
				t2.turn += max(1, info_minerai(p2).resistance);
				if(d0 > 27 && type_case(p) != GRANITE)
					t2.turn -= 1;
			}
			if(d.ligne == 1) {
				position p3 = p2;
				while(p3.ligne <= p.ligne+3 && !can_walk(p3)) p3.ligne ++;
				if(p3.ligne <= p.ligne+3 && p3 != advTav
						&& t2.to_int() < ds[p3.ligne][p3.colonne]) {
					ds[p3.ligne][p3.colonne] = t2.to_int();
					q[t2.to_int()].push_back({p3, p});
				}
			}
			if((can_walk(p) && can_walk(p2)) || corde_sur_case(p2)) t2 += 1;
			else t2 += 2;
			if(t2.to_int() < ds[p2.ligne][p2.colonne]) {
				ds[p2.ligne][p2.colonne] = t2.to_int();
				q[t2.to_int()].push_back({p2, p});
			}
		}
	}
	return res;
}

vector<int> PRED(TAILLE_MINE*TAILLE_MINE);
int play(int id_nain, int p) {
	int pr = PRED[p];
	position pred = int_to_pos(pr);
	position pos = int_to_pos(p);
	if(pr == p) return 0;
	int res = play(id_nain, pr);
	nain na = info_nain(me, id_nain);
	if(na.pos != pred) return res;
	if(nain_sur_case(pos) == adv) return res;
	direction dir = get_dir(pred, pos);
	if(dir == ERREUR_DIRECTION) {
		cerr << "Erreur de direction: " << pred << " " << pos << endl;
		return res;
	}
	if(type_case(pred+dirs[dir]) != LIBRE) {
		if(na.pa < COUT_MINER) return res;
		if(!na.accroche) {
			res ++;
			agripper(id_nain);
		}
		miner(id_nain, dir);
		res ++;
	}
	if(can_walk(pos) && can_walk(pred)) {
		if(na.accroche) {
			lacher(id_nain);
			res ++;
		}
	} else if(can_walk(pos) && dir == BAS) {
		if(na.accroche) {
			lacher(id_nain);
			res ++;
		}
		return res;
	} else if(!na.accroche) {
		agripper(id_nain);
		res ++;
	}	
	int cost = cout_de_deplacement(id_nain, dir);
	if(cost != -1 && cost <= na.pm) {
		deplacer(id_nain, dir);
		res ++;
	}
	return res;
}

bool try_attack(int id) {
	nain na = info_nain(me, id);
	if(na.pa < COUT_MINER) return false;
	position p = na.pos;
	position bp = p;
	double bs = -1000;
	for(int i = 0; i < NB_NAINS; i++) {
		nain n2 = info_nain(adv, i);
		if(n2.butin >= 0 && manhatan(n2.pos, p) == 1) {
			double s = double(n2.butin) / ((n2.vie+2) / 3) + 1;
			if(s > bs) {
				bs = s;
				bp = n2.pos;
			}
		}
	}
	if(bs > 0) miner(id, get_dir(p, bp));
	else return false;
	return true;
}

void try_mine(int id) {
	nain na = info_nain(me, id);
	if(na.pa < COUT_MINER) return;
	position p = na.pos;
	position bp = p;
	double bs = -1000;
	for(const position &d : dirs) {
		position p2 = p+d;
		if(!valid_pos(p2)) continue;
		if(type_case(p2) == GRANITE && info_minerai(p2).rendement > 0) {
			minerai a = info_minerai(p2);
			if(a.rendement * na.butin < 0) continue;
			double s = val_mine(a, na.butin)+0.5;
			// cout << "sc:" << s << " " << na.butin << endl;
			if(s > bs) {
				bs = s;
				bp = p2;
			}
		}
	}
	if(bs > 0 || (bs > -1000 && na.butin == 0)) miner(id, get_dir(p, bp));
}

void play_and_mine(int id, int new_pos) {
	// try_attack(id);
	int nact = play(id, new_pos);
	nain na = info_nain(me, id);
	if(!try_attack(id) && na.pa == COUT_MINER) {
		// if(nact > 0) cout << nact << endl;
		for(int i = 0; i < nact; i++) annuler();
		// if(nact > 0) cout << "cancel" << endl;
		try_attack(id);
		// if(nact > 0) cout << "try attack" << endl;
		play(id, new_pos);
		// if(nact > 0) cout << "play" << endl;
	}
	try_mine(id);
	if(!na.accroche) agripper(id);
}

int best_play(int id, vector<dij_s> d) {
	double ms = 0;
	nain na = info_nain(me, id);
	int res = pos_to_int(na.pos);
	for(const dij_s &el : d) {
		PRED[pos_to_int(el.pos)] = pos_to_int(el.pred);
		double s = score_case(el.pos, el.t, na);
		// if(el.pos == myTav) cout << "tav: " << s << endl;
		if(s > ms) {
			ms = s;
			res = pos_to_int(el.pos);
		}
	}
	// cout << "best: " << ms << endl;
	return res;
}

int crop_size(const position &pos0) {
	position pos = pos0;
	pos.ligne = max(mi_li, pos.ligne);
	position p = pos;
	while(!can_walk(p) && !corde_sur_case(p)) p.ligne ++;
	if(corde_sur_case(p)) return p.ligne - pos.ligne - 0.3 * TAILLE_MINE;
	return p.ligne - 1.3 * pos.ligne; 
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	vector<position> mins = liste_minerais();
	num_m = mins.size();
	if(tour_actuel() > 72 || num_m < 8) rush = true;
	best_rat = 0;
	mi_li = myTav.ligne;
	for(const position &p : mins) {
		minerai m = info_minerai(p);
		best_rat = max(best_rat, double(m.rendement) / double(m.resistance));
		mi_li = min(mi_li, p.ligne);
	}
	int max_ti = min(100, 5*(1+NB_TOURS - tour_actuel()));
	bool crop = true;
	int mps[NB_NAINS];
	vector<dij_s> ds[NB_NAINS];
	for(int i = 0; i < NB_NAINS; i++) {
		nain na = info_nain(me, i);
		position p = na.pos;
		ds[i] = dijkstra(p, max_ti);
		mps[i] = best_play(i, ds[i]);
		play_and_mine(i, mps[i]);
		na = info_nain(me, i);
		if(na.pa < NB_POINTS_ACTION) crop = false;
	}
	if(crop) {
		while(annuler());
		int bs = -1000, id = -1, pos = -1, dr;
		for(int i = 0; i < NB_NAINS; i++) {
			for(int j = 0; j < (int) ds[i].size(); j++) {
				if(ds[i][j].t > NB_POINTS_DEPLACEMENT) break;
				for(int k = 0; k < 4; k++) {
					position p2 = ds[i][j].pos + dirs[k];
					int s = crop_size(p2);
					if(s > bs || (s == bs && manhatan(p2, int_to_pos(mps[i])) < manhatan(int_to_pos(pos), int_to_pos(mps[id]))))
						bs = s, id = i, pos = pos_to_int(p2), dr = k;
				}
			}
		}
		if(id != -1) {
			nain na = info_nain(me, id);
			ds[id] = dijkstra(na.pos, 5, true, false);
			best_play(id, ds[id]);
			play(id, pos);
			poser_corde(id, (direction) dr);
		}
		for(int i = 0; i < NB_NAINS; i++) {
			if(i == id) continue;
			nain na = info_nain(me, i);
			ds[i] = dijkstra(na.pos, max_ti);
			mps[i] = best_play(i, ds[i]);
			play_and_mine(i, mps[i]);
		}
	}
	for(int i = 0; i < NB_NAINS; i++) {
		if(info_nain(me, i).pm <= 0) continue;
		nain na = info_nain(me, i);
		ds[i] = dijkstra(na.pos, max_ti);
		mps[i] = best_play(i, ds[i]);
		play_and_mine(i, mps[i]);
	}
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {

}
