/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <cmath>
#include <set>
#include <map>
#include <queue>
#include <algorithm>

using namespace std;

/*
IA de Yoann Coudert--Osmont
*/

// Indices de l'adversaire et moi
int me, adv;
// Position des tavernes
position myTav, advTav;
// Le mode rush intervient en fin de partie ou lorsuq'il ne reste bientôt plus de minéraux.
// Dépasser la taille du sac n'est plus un problème
bool rush = false;
// Nombre de minerais
int num_m;
// première ligne qui contient un minerai
int mi_li;
// une valeur qui représente la prosximité de l'adversaire à notre base
double prox_val;
// tableau des positions à atteindre pour chaque nain
int bpos[NB_NAINS];
// Est-ce que l'adversaire a déjà attaqué
bool attack = false;


/****************************************************/
/******* QUELQUES FONCTIONS SUR LES POSITIONS *******/
/****************************************************/

position newpos(int l, int c) { return {l, c}; }
position operator+(const position &a, const position &b) {
	return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position operator-(const position &a, const position &b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}
ostream& operator<<(ostream &stream, const position &p) {
	return stream << "(" << p.ligne << ", " << p.colonne << ")";
}
int pos_to_int(const position &p) { return p.ligne*TAILLE_MINE + p.colonne; }
position int_to_pos(int i) { return {i / TAILLE_MINE, i % TAILLE_MINE}; }
vector<position> dirs(4);

bool valid_pos(const position &p) {
	return p.ligne >= 0 && p.ligne < TAILLE_MINE
			&& p.colonne >= 0 && p.colonne < TAILLE_MINE;
}

int manhatan(const position &a, const position &b) {
	return abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne);
}

direction get_dir(const position &a, const position &b) {
	if(a == b) return ERREUR_DIRECTION;
	if(a.ligne == b.ligne) {
		if(a.colonne > b.colonne) return GAUCHE;
		else return DROITE;
	} else if(a.colonne == b.colonne) {
		if(a.ligne > b.ligne) return HAUT;
		else return BAS;
	}
	return ERREUR_DIRECTION;
}


/*************************************************/
/******* DEBUT DE PARTIE / INITIALISATIONS *******/
/*************************************************/

void partie_init() {
	dirs[HAUT] = {-1, 0};
	dirs[BAS] = {1, 0};
	dirs[GAUCHE] = {0, -1};
	dirs[DROITE] = {0, 1};

	me = moi();
	adv = adversaire();
	myTav = position_taverne(me);
	advTav = position_taverne(adv);

	for(int i = 0; i < NB_NAINS; i++) bpos[i] = pos_to_int(myTav);
}


/************************************/
/******* EVALUATION d'ACTIONS *******/
/************************************/

/*** Mesure l'intérêt à déplacer le nain `na` à la position p en un temps t afin de combattre ***/
double simu_fight(const nain &na, const position &p, int t) {
	// S'il n'y a pas d'adversaire ce n'est pas intéressant
	if(nain_sur_case(p) != adv) return 0;
	// Liste de l'opposé des PV des combattants de chaque côté
	vector<int> my_m, adv_m;
	// Quantifie l'argent en jeu
	double steal = 3;
	// Si l'adversaire attaque il y a des risques de perdre de l'argent
	if(attack) steal -= 0.33 * na.butin;
	/**********************************************************************************/
	// On recherche les nains à proximités qui peuvent potentiellement combatre
	/**********************************************************************************/
	for(int i = 0; i < NB_NAINS; i++) {
		if(manhatan(info_nain(me, i).pos, p) <= 3) {
			nain n2 = info_nain(me, i);
			my_m.push_back(-n2.vie);
			steal += 0.8;
			if(t + 4 * (n2.vie/3) < (1.5 - 0.02 * double(n2.butin)) * manhatan(myTav, n2.pos))
				steal += 0.7 * n2.butin;
		}
	}
	if(manhatan(na.pos, p) > 3)
		my_m.push_back(-na.vie);
	for(int i = 0; i < NB_NAINS; i++) {
		if(manhatan(info_nain(adv, i).pos, p) <= 3) {
			nain n2 = info_nain(adv, i);
			adv_m.push_back(-n2.vie);
			steal += 1.75;
			if(t + 4 * (n2.vie/3) < (1.5 - 0.02 * double(n2.butin)) * manhatan(advTav, n2.pos))
				steal += 1.7 * n2.butin;
		}
	}
	/**********************************************************************************/
	// Si l'aderversaire n'ataque pas alors on revoie l'argent total en jeu
	if(!attack) return steal;
	// On trie selon les points de vies car il est plus avantageux de d'abord tuer ceux avec moins de PV
	sort(my_m.begin(), my_m.end());
	sort(adv_m.begin(), adv_m.end());
	// Le score en cas de perte
	double loose = DEGAT_PIOCHE-na.butin+0.12*steal;
	/************************************************/
	// Simulation du combat
	/************************************************/
	while(true) {
		for(int i = 0; i < (int) my_m.size(); i++) {
			int s = adv_m.size();
			if(s == 0) return steal;
			adv_m[s-1] += DEGAT_PIOCHE;
			if(adv_m[s-1] >= 0) adv_m.pop_back();
		}
		for(int i = 0; i < (int) adv_m.size(); i++) {
			int s = my_m.size();
			if(s == 0) return loose;
			my_m[s-1] += DEGAT_PIOCHE;
			if(my_m[s-1] >= 0) my_m.pop_back();
		}
	}
	/************************************************/
}

/*** Mesure l'intérêt d'un minerai pour un nain possédant le butin `butin` ***/
double val_mine(const minerai &a, double butin) {
	double rend = min(a.rendement, BUTIN_MAX);
	double res = rend / double(a.resistance);
	if(!rush) res -= (double(NB_TOURS - tour_actuel() + 0.8*butin) / double(num_m) + 0.1 * butin) * 0.21 * max(butin + rend - BUTIN_MAX, 0.0);
	return res;
}

/*** Mesure l'intérêt à déplacer le nain `na` à la position p en un temps t afin d'éffectuer à la fois des combats et de miner ***/
double score_case(const position &p, int t, const nain &na) {
	/* Cas particuliers */
	if(p == myTav) return 0.9 * double(na.butin) / 25.0;
	if(p == advTav) return -1;
	// Si c'est la fin il vaut mieux rentrer à sa base
	if(na.butin > 0 && manhatan(na.pos, p) + manhatan(p, myTav) > 4.2*(NB_TOURS - tour_actuel())) return -1;
	/********************/
	t = max(t, 1);
	// distance pour revenir
	double dTav = prox_val * (manhatan(p, myTav) - 0.35*max(0, myTav.ligne - p.ligne));
	// Initialisation du score avec la fonction spécifique pour les combats
	double sc = 2.0 * simu_fight(na, p, t) / double(t+8+dTav);
	bool ennemies = sc != 0; // s'il y a des ennemies
	// Si le butin du nain est négatif on peut essayé de le refiler aux adversaires
	if(ennemies && na.butin < 0) sc -= na.butin * 0.2;
	double butin = na.butin;
	/* recherche des minerais */
	vector<minerai> mins;
	for(const position &d : dirs) {
		position p2 = p+d;
		if(!valid_pos(p2)) continue;
		if(type_case(p2) == GRANITE && info_minerai(p2).rendement > 0) {
			mins.push_back(info_minerai(p2));
		}
	}
	/***************************/
	// Tant que le sac n'est pas remplie et qu'il reste des minerai on se remplie les poches
	while(butin < BUTIN_MAX && !mins.empty()) {
		if(na.butin >= 0)
			sort(mins.begin(), mins.end(), [&butin](const minerai &a, const minerai &b) {
				return val_mine(a, butin) > val_mine(b, butin);
			});
		else // Peut-être intéressant si l'adversaire est assez bête pour nous tuer lorsqu'on possède un butin négatif
			sort(mins.begin(), mins.end(), [&butin](const minerai &a, const minerai &b) {
				return val_mine(a, butin) < val_mine(b, butin);
			});
		minerai m = mins[mins.size()-1];
		mins.pop_back();
		// Pénalité importante si on remplie le sac. PAS DE GASPILLAGE
		sc -= 0.05 * max(butin + min(BUTIN_MAX, m.rendement) - BUTIN_MAX, 0.0);
		butin = min(double(BUTIN_MAX), butin+m.rendement);
		// On ajout le temps nécessaire au minage
		t += 5 * pow(double(m.resistance), 0.75);
	}
	// ajout du score lié au minage
	sc += 2.0 * (abs(butin) - abs(na.butin)) / double(t + dTav);
	// Si la case n'est pas intéressante mais qu'il y a des ennemis c'est toujours plus marrant d'aller taper
	if(sc < 0 && na.butin == 0 && ennemies) {
		int but = 0;
		for(int i = 0; i < NB_NAINS; i++) {
			nain n2 = info_nain(adv, i);
			if(manhatan(n2.pos, p) <= 3 && n2.butin > 0)
				but += n2.butin;
		}
		if(but > 0) sc = (0.015*but) / max(4, min(t, 15));
		else sc = 0.0001;
	}
	// Si l'adversaire attaque et qu'on possède de l'argent, mieux vaut ne pas trop s'aventuruer
	if(attack) sc -= 0.0017 * dTav * na.butin;
	return sc;
}


/****************************************************************/
/******* STRUCTURES POUR MESURER LE TEMPS ET POUR DIJKSTRA*******/
/****************************************************************/

struct move_time {
	int turn, pm;
	move_time(int t=0, int p=0) {
		pm = p % 5;
		turn = t + (p / 5);
	}
	int to_int() { return 5*turn + pm; }
};
bool operator<(const move_time &a, const move_time &b) {
	return a.turn < b.turn || (a.turn == b.turn && a.pm < b.pm);
}
bool operator>(const move_time &a, const move_time &b) {
	return a.turn > b.turn || (a.turn == b.turn && a.pm > b.pm);
}
bool operator==(const move_time &a, const move_time &b) {
	return a.turn == b.turn && a.pm == b.pm;
}
move_time operator+(const move_time &a, int act) { 
	int p = a.pm + act;
	if(p > NB_POINTS_DEPLACEMENT) return move_time(a.turn+1, act);
	else if(p == NB_POINTS_DEPLACEMENT) return move_time(a.turn+1, 0);
	else return move_time(a.turn, p);
}
move_time& operator+=(move_time &a, const int &b) { 
	a = a+b;
	return a;
}
move_time int_to_mt(int a) { return move_time(a / 5, a % 5); }

struct dij_s {
	position pos, pred;
	int t;
	dij_s(position p, position pr, int t): pos(p), pred(pr), t(t) {}
};
bool operator<(const dij_s &a, const dij_s &b) {
	return a.t < b.t;
}

/**************************************/
/******* DEPLACEMENT & DIJKSTRA *******/
/**************************************/

// Peut-on marcher sur la case p ?
bool can_walk(const position &p) {
	position p2 = p + dirs[BAS];
	return !valid_pos(p2) || type_case(p2) != LIBRE || nain_sur_case(p2) == adv;
}

// Dijkstra à partir de la position p0
// si on a trouvé comment aller à la taverne et alors on ne va pas plus loin que les déplacements qui demandent
// un temps max_ti
// tavSeen : Est-il nécessaire de voire la taverne ?
// can_mine : Le nain peut-il miner pendant qu'il se déplace ?
// ...........
// Utiliser une sorte de "bucket sort" pour faire disparaitre un facteur log(n) comme les différents temps
// possibles de déplacements sont faibles
vector<dij_s> dijkstra(const position &p0, int max_ti, bool tavSeen=false, bool can_mine=true) {
	vector<dij_s> res;
	vector<vector<dij_s>> q(500);
	int ds[TAILLE_MINE][TAILLE_MINE];
	for(int i = 0; i < TAILLE_MINE; i++)
		for(int j = 0; j < TAILLE_MINE; j++)
			ds[i][j] = 500;
	q[0].push_back(dij_s(p0, p0, 1));
	ds[p0.ligne][p0.colonne] = 0;
	int d0 = 0;
	while(d0 < 500) {
		if(tavSeen && d0 > max_ti) break;
		if(q[d0].empty()) {
			d0 ++;
			continue;
		}
		position p = q[d0][q[d0].size()-1].pos;
		position pred = q[d0][q[d0].size()-1].pred;
		// ceci est un système de PA astucieux pour savoir si on peut casser un bloc sans perde un tour
		int pa0 = q[d0][q[d0].size()-1].t;
		q[d0].pop_back();
		if(d0 > ds[p.ligne][p.colonne]) continue;
		if(p == myTav) tavSeen = true;
		int dp0 = d0;
		if(pa0 == 0) dp0 = (int(dp0/5) + 1) * 5;
		res.push_back(dij_s(p, pred, d0));
		for(const position &d : dirs) {
			position p2 = p+d;
			if(!valid_pos(p2)) continue;
			if(p2 == advTav || type_case(p2) == OBSIDIENNE) continue;
			move_time t2 = int_to_mt(d0);
			int pa = pa0;
			/* Partie ou on mine */
			if(nain_sur_case(p2) == adv) {
				if(!can_mine) continue;	
				for(int i = 0; i < NB_NAINS; i++)
					if(info_nain(adv, i).pos == p2)
						t2.turn += (info_nain(adv, i).vie + 2) / 3;
				if(pa == 1 && d0 > 22) t2.turn -= 1;
				pa = 0;
			}
			if(type_case(p2) == GRANITE) {
				if(!can_mine) continue;	
				t2.turn += max(1, info_minerai(p2).resistance);
				if(pa == 1 && d0 > 22) t2.turn -= 1;
				pa = 0;
			}
			/*********************/
			/* Partie pour se lacher */
			if(d.ligne == 1) {
				position p3 = p2;
				while(p3.ligne <= p.ligne+3 && !can_walk(p3)) p3.ligne ++;
				if(p3.ligne <= p.ligne+3 && p3 != advTav
						&& t2.to_int() < ds[p3.ligne][p3.colonne]) {
					int dp = t2.to_int();
					ds[p3.ligne][p3.colonne] = dp;
					q[dp].push_back(dij_s(p3, p, pa));
				}
			}
			/*************************/
			/* Simple déplacement */
			int lt = t2.turn;
			if((can_walk(p) && can_walk(p2)) || corde_sur_case(p2)) t2 += 1;
			else t2 += 2;
			if(t2.turn > lt) pa = 1;
			if(t2.to_int() < ds[p2.ligne][p2.colonne]) {
				int dp = t2.to_int();
				ds[p2.ligne][p2.colonne] = dp;
				q[dp].push_back(dij_s(p2, p, pa));
			}
			/***********************/
		}
	}
	return res;
}

// TABLEAU DES PREDESSEURS POUR SE DEPLACER
vector<int> PRED(TAILLE_MINE*TAILLE_MINE);

// fait jouer le nain qui correspond à l'id donné vers la position p
// pour cela le tableau PRED est utilisé récursivement
// Les nains restent toujours agripés sauf pour marcher lorsque cela est possible
// Ils peuvent aussi lacher la paroi pour tomber.
// Retourne le nombre d'actions effectuées
int play(int id_nain, int p) {
	int pr = PRED[p];
	position pred = int_to_pos(pr);
	position pos = int_to_pos(p);
	if(pr == p) return 0;
	int res = play(id_nain, pr);
	nain na = info_nain(me, id_nain);
	if(na.pos != pred) return res;
	if(nain_sur_case(pos) == adv) return res;
	direction dir = get_dir(pred, pos);
	if(dir == ERREUR_DIRECTION) {
		cerr << "Erreur de direction: " << pred << " " << pos << endl;
		return res;
	}
	// Minage
	if(type_case(pred+dirs[dir]) != LIBRE) {
		if(na.pa < COUT_MINER) return res;
		if(!na.accroche) {
			res ++;
			agripper(id_nain);
		}
		miner(id_nain, dir);
		res ++;
	}
	// Marche
	if(can_walk(pos) && can_walk(pred)) {
		if(na.accroche) {
			lacher(id_nain);
			res ++;
		}
	// Chute
	} else if(can_walk(pos) && dir == BAS) {
		if(na.accroche) {
			lacher(id_nain);
			res ++;
		}
		return res;
	// Normal (reste agripé)
	} else if(!na.accroche) {
		agripper(id_nain);
		res ++;
	}
	// déplacement
	int cost = cout_de_deplacement(id_nain, dir);
	if(cost != -1 && cost <= na.pm) {
		deplacer(id_nain, dir);
		res ++;
	}
	return res;
}

// le nain id essaye d'attaquer un ennemi voisin
bool try_attack(int id) {
	nain na = info_nain(me, id);
	if(na.pa < COUT_MINER) return false;
	position p = na.pos;
	position bp = p;
	double bs = -1000;
	for(int i = 0; i < NB_NAINS; i++) {
		nain n2 = info_nain(adv, i);
		if(n2.butin >= 0 && manhatan(n2.pos, p) == 1) {
			double s = double(n2.butin) / ((n2.vie+2) / 3) + 1;
			if(s > bs) {
				bs = s;
				bp = n2.pos;
			}
		}
	}
	if(bs > 0) miner(id, get_dir(p, bp));
	else return false;
	return true;
}

// le nain id essaye de miner un minerai voisin
void try_mine(int id) {
	nain na = info_nain(me, id);
	if(na.pa < COUT_MINER) return;
	position p = na.pos;
	position bp = p;
	double bs = -1000;
	for(const position &d : dirs) {
		position p2 = p+d;
		if(!valid_pos(p2)) continue;
		if(type_case(p2) == GRANITE && info_minerai(p2).resistance > 0) {
			minerai a = info_minerai(p2);
			if(a.rendement * na.butin < 0) continue;
			double s = val_mine(a, na.butin)+0.5;
			if(s > bs) {
				bs = s;
				bp = p2;
			}
		}
	}
	if(bs > 0 || (bs > -1000 && na.butin == 0)) miner(id, get_dir(p, bp));
}

// Fonction pour déplacer le nain id vers la position new_pos en tentant de donner
// des coups de pioches intéressants. La priorité est donné sur le tapage d'ennemi
void play_and_mine(int id, int new_pos) {
	int nact = play(id, new_pos);
	nain na = info_nain(me, id);
	// Si n'a pas utiliser ses pa après avoir essayé d'attaquer à la fin du déplacement
	// essaye d'attaquer au début du déplacement
	if(!try_attack(id) && na.pa == COUT_MINER) {
		for(int i = 0; i < nact; i++) annuler();
		try_attack(id);
		play(id, new_pos);
	}
	// Finalement essaye de miner
	try_mine(id);
	// On n'oublie de s'aggriper au cas où
	if(!na.accroche) agripper(id);
}

// recherche me meilleur coup dans le résultat de dijkstrat pour le nain id
// en profite pour remplir le tableau PRED pour ensuite pouvoir faire le déplacement
int best_play(int id, vector<dij_s> d) {
	debug_afficher_drapeau(int_to_pos(bpos[id]), AUCUN_DRAPEAU);
	double ms = 0;
	nain na = info_nain(me, id);
	int res = pos_to_int(na.pos);
	// cout << "size: " << d.size() << endl;
	for(const dij_s &el : d) {
		PRED[pos_to_int(el.pos)] = pos_to_int(el.pred);
		double s = score_case(el.pos, el.t, na);
		// if(el.pos == myTav) cout << "tav: " << s << endl;
		if(s > ms) {
			ms = s;
			res = pos_to_int(el.pos);
		}
	}
	bpos[id] = res;
	debug_afficher_drapeau(int_to_pos(bpos[id]), (debug_drapeau) me);
	// cout << "best: " << ms << endl;
	return res;
}

// Détermine l'intérêt de poser une corde à la position pos0
int crop_size(const position &pos0) {
	if(corde_sur_case(pos0) || type_case(pos0) != LIBRE) return -9999;
	position pos = pos0;
	pos.ligne = max(mi_li, pos.ligne);
	position p = pos;
	while(!can_walk(p) && !corde_sur_case(p)) p.ligne ++;
	if(corde_sur_case(p)) return p.ligne - pos.ligne - 0.3 * TAILLE_MINE;
	return p.ligne - 1.3 * pos.ligne; 
}


/***********************************/
/******* FONCTION PRINCIPALE *******/
/***********************************/

void jouer_tour() {
	// Initialisations variables globales
	/****************************************************/
	vector<position> mins = liste_minerais();
	num_m = mins.size();
	if(tour_actuel() > 72 || num_m < 8) rush = true;
	mi_li = myTav.ligne;
	for(const position &p : mins)
		mi_li = min(mi_li, p.ligne);
	int max_ti = min(100, 5*(1+NB_TOURS - tour_actuel()));
	prox_val = 0;
	for(int i = 0; i < NB_NAINS; i++) {
		prox_val += manhatan(myTav, info_nain(adv, i).pos);
		if(info_nain(me, i).vie < VIE_NAIN) attack = true;
	}
	prox_val = 1.45 - min(0.45, 0.07*pow(prox_val-3, 0.42));
	/****************************************************/
	// crop vaudrat true si aucun PA n'est utilisé par les six nains
	bool crop = true;
	int mps[NB_NAINS];
	vector<dij_s> ds[NB_NAINS];
	// Première tentative de tour
	for(int i = 0; i < NB_NAINS; i++) {
		nain na = info_nain(me, i);
		position p = na.pos;
		ds[i] = dijkstra(p, max_ti);
		mps[i] = best_play(i, ds[i]);
		play_and_mine(i, mps[i]);
		na = info_nain(me, i);
		if(na.pa < NB_POINTS_ACTION) crop = false;
	}
	// Si aucun PA n'a été utilisé on essaye de poser une corde
	if(crop) {
		// On annule ca qu'on a fait avant pour repartir à zéroet profiter de la corde
		while(annuler());
		/* On cherche la meilleur position atteignable dans ce tour pour la corde */
		int bs = -1000, id = -1, pos = -1, dr = -1;
		for(int i = 0; i < NB_NAINS; i++) {
			for(int j = 0; j < (int) ds[i].size(); j++) {
				if(ds[i][j].t > NB_POINTS_DEPLACEMENT) break;
				for(int k = 0; k < 4; k++) {
					position p2 = ds[i][j].pos + dirs[k];
					int s = crop_size(p2);
					if(s > bs || (s == bs && manhatan(p2, int_to_pos(mps[i])) < manhatan(int_to_pos(pos), int_to_pos(mps[id]))))
						bs = s, id = i, pos = pos_to_int(p2), dr = k;
				}
			}
		}
		/**************************************************************************/
		// Si on a trouvé une position on pose la corde
		if(id != -1) {
			nain na = info_nain(me, id);
			ds[id] = dijkstra(na.pos, 5, true, false);
			best_play(id, ds[id]);
			play(id, pos);
			poser_corde(id, (direction) dr);
		}
		// On fait jouer les autres
		for(int i = 0; i < NB_NAINS; i++) {
			if(i == id) continue;
			nain na = info_nain(me, i);
			ds[i] = dijkstra(na.pos, max_ti);
			mps[i] = best_play(i, ds[i]);
			play_and_mine(i, mps[i]);
		}
	}
	// Au cas où on retente de refaire jouer les nains des fois que certains n'est pas utiliser tous leurs points
	for(int i = 0; i < NB_NAINS; i++) {
		if(info_nain(me, i).pm <= 0) continue;
		nain na = info_nain(me, i);
		ds[i] = dijkstra(na.pos, max_ti);
		mps[i] = best_play(i, ds[i]);
		play_and_mine(i, mps[i]);
	}
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {

}

/*********************************************/
/* BONNE ANNEE !!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*********************************************/