/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#include "interface.hh"
#include <cstdlib>

template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in;
}

template<>
std::string lang2cxx<char*, std::string>(char* in)
{
  return in;
}

template<typename Lang, typename Lang_array, typename Cxx>
std::vector<Cxx> lang2cxx_array(Lang_array in)
{
  std::vector<Cxx> out(in.length);
  for (size_t i = 0; i < in.length; ++i)
    out[i] = lang2cxx<Lang, Cxx>(in.datas[i]);
  return out;
}

template<typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
  return in;
}

template<>
char* cxx2lang<char*, std::string>(std::string in)
{
  size_t l = in.length();
  char* out = (char *) malloc(l + 1);
  for (int i = 0; i < l; i++) out[i] = in[i];
  out[l] = 0;
  return out;
}

template<typename Lang, typename Lang_array, typename Cxx>
Lang_array cxx2lang_array(const std::vector<Cxx>& in)
{
  Lang_array out = { NULL, in.size() };
  out.datas = (Lang *)malloc((out.length) * sizeof(Lang));
  for (int i = 0; i < out.length; ++i)
    out.datas[i] = cxx2lang<Lang, Cxx>(in[i]);
  return out;
}
/// Position dans la mine, donnée par deux coordonnées.
template<>
__internal__cxx__position lang2cxx<position, __internal__cxx__position>(position in)
{
  __internal__cxx__position out;
  out.ligne = lang2cxx<int, int >(in.ligne);
  out.colonne = lang2cxx<int, int >(in.colonne);
  return out;
}

template<>
position cxx2lang<position, __internal__cxx__position>(__internal__cxx__position in)
{
  position out;
  out.ligne = cxx2lang<int, int >(in.ligne);
  out.colonne = cxx2lang<int, int >(in.colonne);
  return out;
}


/// Minerai à récolter
template<>
__internal__cxx__minerai lang2cxx<minerai, __internal__cxx__minerai>(minerai in)
{
  __internal__cxx__minerai out;
  out.resistance = lang2cxx<int, int >(in.resistance);
  out.rendement = lang2cxx<int, int >(in.rendement);
  return out;
}

template<>
minerai cxx2lang<minerai, __internal__cxx__minerai>(__internal__cxx__minerai in)
{
  minerai out;
  out.resistance = cxx2lang<int, int >(in.resistance);
  out.rendement = cxx2lang<int, int >(in.rendement);
  return out;
}


/// Nain (standard)
template<>
__internal__cxx__nain lang2cxx<nain, __internal__cxx__nain>(nain in)
{
  __internal__cxx__nain out;
  out.pos = lang2cxx<position, __internal__cxx__position >(in.pos);
  out.vie = lang2cxx<int, int >(in.vie);
  out.pa = lang2cxx<int, int >(in.pa);
  out.pm = lang2cxx<int, int >(in.pm);
  out.accroche = lang2cxx<bool, bool >(in.accroche);
  out.butin = lang2cxx<int, int >(in.butin);
  return out;
}

template<>
nain cxx2lang<nain, __internal__cxx__nain>(__internal__cxx__nain in)
{
  nain out;
  out.pos = cxx2lang<position, __internal__cxx__position >(in.pos);
  out.vie = cxx2lang<int, int >(in.vie);
  out.pa = cxx2lang<int, int >(in.pa);
  out.pm = cxx2lang<int, int >(in.pm);
  out.accroche = cxx2lang<bool, bool >(in.accroche);
  out.butin = cxx2lang<int, int >(in.butin);
  return out;
}


/// Action de déplacement représentée dans l'historique.
template<>
__internal__cxx__action_hist lang2cxx<action_hist, __internal__cxx__action_hist>(action_hist in)
{
  __internal__cxx__action_hist out;
  out.atype = lang2cxx<action_type, action_type >(in.atype);
  out.id_nain = lang2cxx<int, int >(in.id_nain);
  out.dir = lang2cxx<direction, direction >(in.dir);
  out.sens = lang2cxx<direction, direction >(in.sens);
  return out;
}

template<>
action_hist cxx2lang<action_hist, __internal__cxx__action_hist>(__internal__cxx__action_hist in)
{
  action_hist out;
  out.atype = cxx2lang<action_type, action_type >(in.atype);
  out.id_nain = cxx2lang<int, int >(in.id_nain);
  out.dir = cxx2lang<direction, direction >(in.dir);
  out.sens = cxx2lang<direction, direction >(in.sens);
  return out;
}


extern "C" {
/// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
direction_array chemin(position pos1, position pos2)
{
  return cxx2lang_array<direction, direction_array, direction >(api_chemin(lang2cxx<position, __internal__cxx__position >(pos1), lang2cxx<position, __internal__cxx__position >(pos2)));
}


/// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
erreur deplacer(int id_nain, direction dir)
{
  return cxx2lang<erreur, erreur >(api_deplacer(lang2cxx<int, int >(id_nain), lang2cxx<direction, direction >(dir)));
}


/// Le nain (standard) ``id_nain`` lâche la paroi.
erreur lacher(int id_nain)
{
  return cxx2lang<erreur, erreur >(api_lacher(lang2cxx<int, int >(id_nain)));
}


/// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
erreur agripper(int id_nain)
{
  return cxx2lang<erreur, erreur >(api_agripper(lang2cxx<int, int >(id_nain)));
}


/// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
erreur miner(int id_nain, direction dir)
{
  return cxx2lang<erreur, erreur >(api_miner(lang2cxx<int, int >(id_nain), lang2cxx<direction, direction >(dir)));
}


/// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
erreur tirer(int id_nain, direction dir_corde, direction sens)
{
  return cxx2lang<erreur, erreur >(api_tirer(lang2cxx<int, int >(id_nain), lang2cxx<direction, direction >(dir_corde), lang2cxx<direction, direction >(sens)));
}


/// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
erreur poser_corde(int id_nain, direction dir)
{
  return cxx2lang<erreur, erreur >(api_poser_corde(lang2cxx<int, int >(id_nain), lang2cxx<direction, direction >(dir)));
}


/// Affiche le drapeau spécifié sur la case indiquée.
erreur debug_afficher_drapeau(position pos, debug_drapeau drapeau)
{
  return cxx2lang<erreur, erreur >(api_debug_afficher_drapeau(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<debug_drapeau, debug_drapeau >(drapeau)));
}


/// Renvoie le type d'une case donnée.
case_type type_case(position pos)
{
  return cxx2lang<case_type, case_type >(api_type_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
position_array liste_cordes(void)
{
  return cxx2lang_array<position, position_array, __internal__cxx__position >(api_liste_cordes());
}


/// Indique si une corde se trouve sur une case donnée.
bool corde_sur_case(position pos)
{
  return cxx2lang<bool, bool >(api_corde_sur_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
int nain_sur_case(position pos)
{
  return cxx2lang<int, int >(api_nain_sur_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
nain info_nain(int id_joueur, int id_nain)
{
  return cxx2lang<nain, __internal__cxx__nain >(api_info_nain(lang2cxx<int, int >(id_joueur), lang2cxx<int, int >(id_nain)));
}


/// Renvoie la liste de tous les minerais dans la mine.
position_array liste_minerais(void)
{
  return cxx2lang_array<position, position_array, __internal__cxx__position >(api_liste_minerais());
}


/// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
minerai info_minerai(position pos)
{
  return cxx2lang<minerai, __internal__cxx__minerai >(api_info_minerai(lang2cxx<position, __internal__cxx__position >(pos)));
}


/// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
int cout_de_deplacement(int id_nain, direction dir)
{
  return cxx2lang<int, int >(api_cout_de_deplacement(lang2cxx<int, int >(id_nain), lang2cxx<direction, direction >(dir)));
}


/// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
position position_taverne(int id_joueur)
{
  return cxx2lang<position, __internal__cxx__position >(api_position_taverne(lang2cxx<int, int >(id_joueur)));
}


/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
action_hist_array historique(void)
{
  return cxx2lang_array<action_hist, action_hist_array, __internal__cxx__action_hist >(api_historique());
}


/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
int score(int id_joueur)
{
  return cxx2lang<int, int >(api_score(lang2cxx<int, int >(id_joueur)));
}


/// Renvoie votre numéro de joueur.
int moi(void)
{
  return cxx2lang<int, int >(api_moi());
}


/// Renvoie le numéro de joueur de votre adversaire.
int adversaire(void)
{
  return cxx2lang<int, int >(api_adversaire());
}


/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
bool annuler(void)
{
  return cxx2lang<bool, bool >(api_annuler());
}


/// Retourne le numéro du tour actuel.
int tour_actuel(void)
{
  return cxx2lang<int, int >(api_tour_actuel());
}


/// Affiche le contenu d'une valeur de type case_type
void afficher_case_type(case_type v)
{
  api_afficher_case_type(lang2cxx<case_type, case_type >(v));
}


/// Affiche le contenu d'une valeur de type direction
void afficher_direction(direction v)
{
  api_afficher_direction(lang2cxx<direction, direction >(v));
}


/// Affiche le contenu d'une valeur de type erreur
void afficher_erreur(erreur v)
{
  api_afficher_erreur(lang2cxx<erreur, erreur >(v));
}


/// Affiche le contenu d'une valeur de type action_type
void afficher_action_type(action_type v)
{
  api_afficher_action_type(lang2cxx<action_type, action_type >(v));
}


/// Affiche le contenu d'une valeur de type debug_drapeau
void afficher_debug_drapeau(debug_drapeau v)
{
  api_afficher_debug_drapeau(lang2cxx<debug_drapeau, debug_drapeau >(v));
}


/// Affiche le contenu d'une valeur de type position
void afficher_position(position v)
{
  api_afficher_position(lang2cxx<position, __internal__cxx__position >(v));
}


/// Affiche le contenu d'une valeur de type minerai
void afficher_minerai(minerai v)
{
  api_afficher_minerai(lang2cxx<minerai, __internal__cxx__minerai >(v));
}


/// Affiche le contenu d'une valeur de type nain
void afficher_nain(nain v)
{
  api_afficher_nain(lang2cxx<nain, __internal__cxx__nain >(v));
}


/// Affiche le contenu d'une valeur de type action_hist
void afficher_action_hist(action_hist v)
{
  api_afficher_action_hist(lang2cxx<action_hist, __internal__cxx__action_hist >(v));
}


}
