from api import *
from heapq import *
from math import sqrt
from time import time

#tableau représentant la carte, case : True = MUR, False = LIBRE
m = []
#tableau qui contient la listes des aliens qui vont spawn à chaque position
sp = [[[] for _ in range(25)] for _ in range(25)]
focus = [] #les position qui sont focus par mes agents
to = 0 #numéro du tour
abo = False #True si l'adversaire pousse
#les directions
ds = [(1, 0, direction.SUD), (-1, 0, direction.NORD), (0, 1, direction.EST), (0, -1, direction.OUEST)]
stt = 0 #temps du début de tour

#coeff nombre de tours
c0 = 3.25

def partie_init():
	#on crée m
	for x in range(25):
		l = []
		for y in range(25):
			l.append(type_case((x, y)) == case_type.MUR)
		m.append(l)
	#puis sp
	for a in liste_aliens():
		x, y = a.pos
		sp[x][y].append((a.tour_invasion, a.tour_invasion + a.duree_invasion, a.points_capture))

#True si (x, y) est dans la carte
def acc0(x, y):
	return x >= 0 and x < 25 and y >= 0 and y < 25

#True si (x, y) accessible
def acc(x, y):
	if not(acc0(x, y)) or m[x][y]:
		return False
	return agent_sur_case((x, y)) == -1

#heuristique
def heu(dt, sc, p):
	if sc <= 0:
		return 9999999
	x, y = p
	return c0*dt - sc

#protection horizontal (pour se poser à côté d'un alié ou entre un allié et un enemi)
def hor(x, y, rest):
	bo = True #si on protège
	nx = x+1
	while acc(nx, y):
		nx += 1
	jo = agent_sur_case((nx, y)) #joueur à droite
	if jo != -1:
		nx2 = x-1
		while acc(nx, y):
			nx2 -= 1
		for ax in range(nx2+1, nx):
			if (ax, y) in focus:
				bo = False
				break
		jo2 = agent_sur_case((nx2, y)) #joueur à gauche
		if bo and jo2 != -1 and jo2 != jo and nx-nx2 > 2:
			if jo2 == moi():
				nx = nx2
				ndx = 1
			else:
				ndx = -1
			if alien_sur_case((nx, y)):
				if moi() == 2 and info_alien((nx, y)).capture_en_cours == 2:
					bo = False
				else:
					for dx, dy, _ in ds:
						if dx == ndx:
							continue
						mx, my = nx+dx, y+dy
						while acc(mx, my):
							mx += dx
							my += dy
						if agent_sur_case((mx, my)) == adversaire():
							bo = False
							break
			else:
				bo = False
			if bo:
				for ay in [y+c for c in range(-3, 4)]:
					if ay == y:
						continue
					for ax in [nx+c for c in range(-4+abs(ay-y), 5-abs(ay-y))]:
						if agent_sur_case((ax, ay)) == adversaire():
							bo = False
							break
					if not(bo):
						break
		else:
			bo = False
	else:
		bo = False
	if bo:
		ad = 3 if info_alien((nx, y)).capture_en_cours + moi() == 3 else 0
		return info_alien((nx, y)).points_capture + ad
	if rest:
		if agent_sur_case((x+1, y)) == moi() and alien_sur_case((x+1, y)):
			return hor(x+2, y, False)
		if agent_sur_case((x-1, y)) == moi() and alien_sur_case((x-1, y)):
			return hor(x-2, y, False)
	return -1

#protection vertical
def ver(x, y, rest):
	bo = True
	ny = y+1
	while acc(x, ny):
		ny += 1
	jo = agent_sur_case((x, ny))
	if jo != -1:
		ny2 = y-1
		while acc(x, ny):
			ny2 -= 1
		for ay in range(ny2+1, ny):
			if (x, ay) in focus:
				bo = False
				break
		jo2 = agent_sur_case((x, ny2))
		if bo and jo2 != -1 and jo2 != jo and ny-ny2 > 2:
			if jo2 == moi():
				ny = ny2
				ndy = 1
			else:
				ndy = -1
			if alien_sur_case((x, ny)):
				if moi() == 2 and info_alien((x, ny)).capture_en_cours == 2:
					bo = False
				else:
					for dx, dy, _ in ds:
						if dy == ndy:
							continue
						mx, my = x+dx, ny+dy
						while acc(mx, my):
							mx += dx
							my += dy
						if agent_sur_case((mx, my)) == adversaire():
							bo = False
							break
			else:
				bo = False
			if bo:
				for ax in [x+c for c in range(-3, 4)]:
					if ax == x:
						continue
					for ay in [ny+c for c in range(-4+abs(ax-x), 5-abs(ax-x))]:
						if agent_sur_case((ax, ay)) == adversaire():
							bo = False
							break
					if not(bo):
						break
		else:
			bo = False
	else:
		bo = False
	if bo:
		ad = 3 if info_alien((x, ny)).capture_en_cours + moi() == 3 else 0
		return info_alien((x, ny)).points_capture + ad
	if rest:
		if agent_sur_case((x, y+1)) == moi() and alien_sur_case((x, y+1)):
			return ver(x, y+2, False)
		if agent_sur_case((x, y-1)) == moi() and alien_sur_case((x, y-1)):
			return ver(x, y-2, False)
	return -1

#Dijkstra customisé
def dij(j, i, act):
	vu = [[False] * 25 for _ in range(25)]
	dis = [[(100, 8)] * 25 for _ in range(25)]
	pre = [[0] * 25 for _ in range(25)]
	p = position_agent(j, i)
	x, y = p
	q = [((0, act), p)]
	dis[x][y] = (0, act)
	def add(d, x, y, pr):
		if d < dis[x][y]:
			dis[x][y] = d
			heappush(q, (d, (x, y)))
			pre[x][y] = pr
	be = 9999
	pb = 0
	co = 0
	while len(q) > 0 and time()-stt <= 0.92 and co < 360: #on évite les timeout ...
		d, p = heappop(q)
		x, y = p
		if vu[x][y]:
			continue
		co += 1
		vu[x][y] = True
		t = d[0] + to
		#possibilité d'aller sur un alien
		if not(p in focus):
			while len(sp[x][y]) > 0:
				a, b, c = sp[x][y][0]
				if c > 0 and t <= b-3 and (t < a or alien_sur_case(p)):
					bon = 2 #bonus s'il y a des murs à côté
					if x == 24 or m[x+1][y] or x == 0 or m[x-1][y]:
						c += bon
						bon += 3.2
					if y == 24 or m[x][y+1] or y == 0 or m[x][y-1]:
						c += bon
					bo = abo
					for aa in range(4):
						z, w = position_agent(adversaire(), aa)
						if abs(x - z) + abs(w - y) < 10:
							bo = False
							break
					if bo:
						c += 2
					nb = heu(d[0]+1.4*max(0, a-t), c, p)
					if nb < be:
						be, pb = nb, p
					break
				else:
					del sp[x][y][0]
		#possibilité de rester immobile pour empêcher l'adversaire de pousser
		if d[0] == 0 and abo:
			#horizontal
			ho = hor(x, y, True)
			if ho != -1:
				nb = heu(0, ho, p)
				if nb < be:
					be, pb = nb, p
			#vertical
			ve = ver(x, y, True)
			if ve != -1:
				nb = heu(0, ve, p)
				if nb < be:
					be, pb = nb, p
		#autre
		for dx, dy, dire in ds:
			np = nx, ny = x+dx, y+dy
			#possibilité de marcher
			if acc(nx, ny):
				d2 = (d[0]+1, 1) if d[1] == 8 else (d[0], d[1]+1)
				add(d2, nx, ny, (p, 0, dire))
			#possibilité de protéger
			if abo and not(p in focus) and not((nx+dx, ny+dy) in focus) and agent_sur_case(np) == moi() and alien_sur_case(np):
				al = info_alien(np)
				cec = al.capture_en_cours
				xok = (dx == 0 and (nx == 24 or m[nx+1][ny] or nx == 0 or m[nx-1][ny]))
				yok = (dy == 0 and (ny == 24 or m[nx][ny+1] or ny == 0 or m[nx][ny-1]))
				if (moi() == 1 or cec < 2) and d[0] < NB_TOURS_CAPTURE - cec and (xok or yok) and not(xok and yok):
					al = info_alien((nx, y))
					nb = heu(d[0], al.points_capture+1.3*al.capture_en_cours+0.5, p)
					if nb < be:
						be, pb = nb, p
			#possibilité de pousser
			elif not(np in focus) and acc0(nx, ny) and d < dis[nx][ny] and agent_sur_case(np) == adversaire() and alien_sur_case(np):
				t2 = d[0]+1 if d[1] >= 4 else d[0]
				al = info_alien(np)
				if acc(nx+dx, ny+dy) and t2 < NB_TOURS_CAPTURE - al.capture_en_cours and al.points_capture > 0:
					pre[nx][ny] = (p, 2, dire)
					dis[nx][ny] = d
					nb = heu(t2, al.points_capture+2*al.capture_en_cours-1, np)
					if nb < be:
						be, pb = nb, np
			#possibilité de glisser
			while acc(nx, ny):
				nx += dx
				ny += dy
			d2 = (d[0]+1, 3) if d[1] >= 6 else (d[0], d[1]+3)
			add(d2, nx-dx, ny-dy, (p, 1, dire))
	if be == 9999:
		return -1
	else:
		return be, pb, pre

#déplacement d'agent
def move(i, p, pre):
	x, y = p
	if p == position_agent(moi(), i):
		return True
	pp, h, dire = pre[x][y]
	if move(i, pp, pre):
		if h == 0 and points_action_agent(i) >= 1:
			deplacer(i, dire)
			return True
		elif h == 1 and points_action_agent(i) >= 3:
			glisser(i, dire)
			return True
		elif points_action_agent(i) >= 5:
			pousser(i, dire)
			if points_action_agent(i) == 5:
				return True
			return 42
		return False

def jouer_tour():
	global to, focus, abo, stt
	stt = time()
	#si on nous a déjà poussé on met le bonus d'éloignement
	if not(abo):
		for a in historique():
			if a.atype == action_type.ACTION_POUSSER:
				abo = True
				break
	#on choisit les agents qui vont se déplacer et ceux qui restent sur les aliens et poussent éventuellement
	focus = []
	ids = []
	for i in range(4):
		p = position_agent(moi(), i)
		if alien_sur_case(p) and info_alien(p).points_capture > 0:
			for dx, dy, dire in ds:
				x, y = p
				np = nx, ny = dx+x, dy+y
				if points_action_agent(i) >= 5 and acc0(nx, ny) and agent_sur_case(np) == adversaire() and acc(nx+dx, ny+dy):
					pousser(i, dire)
					break
			focus.append(position_agent(moi(), i))
		else:
			ids.append((i, 0))
	#on bouge les agents
	sav = {}
	tiou = False
	while True:
		r = []
		for i, act in ids:
			a = dij(moi(), i, act)
			if a == -1:
				p = x, y = position_agent(moi(), i)
				if alien_sur_case(p) and info_alien(p).points_capture < 0:
					for dx, dy, dire in ds:
						if acc(x+dx, y+dy):
							deplacer(i, dire)
							break
				continue
			d, p, pre = a
			sav[i] = p, pre
			r.append((d, i, p, pre))
			if time() - stt > 0.92:
				tiou = True
				break
		if len(r) == 0 or tiou:
			break
		r.sort()
		ids = [(a[1], 0) for a in r[1:]]
		d, i, p, pre = r[0]
		del sav[i]
		focus.append(p)
		if move(i, p, pre) == 42:
			ids.append((i, 8 - points_action_agent(i)))
			focus.pop()
	#si timeout, solution de secours
	if tiou:
		for i in sav:
			p, pre = sav[i]
			move(i, p, pre)
	to += 1
	print(time()-stt)

def partie_fin():
	pass
