<?php
/*
 * Taille de l’établi de travail (longueur et largeur)
 */
define('TAILLE_ETABLI', 6);

/*
 * Nombre de tours à jouer avant la fin de l’affrontement
 */
define('NB_TOURS', 150);

/*
 * Taille de l’énumération ``case_type``
 */
define('NB_TYPE_CASES', 6);

/*
 * Types de cases
 */
define('VIDE', 0); // Case vide
define('PLOMB', 1); // Plomb ; transmutable en or
define('FER', 2); // Fer ; transmutable en or
define('CUIVRE', 3); // Cuivre ; transmutable en or
define('SOUFRE', 4); // Soufre ; transmutable en catalyseur
define('MERCURE', 5); // Mercure ; transmutable en catalyseur

/*
 * Types de propriétés des éléments
 */
define('AUCUNE', 0); // Les cases vides ne contiennent pas d’élément, et n’ont donc aucune propriété
define('TRANSMUTABLE_OR', 1); // Élement transmutable en or
define('TRANSMUTABLE_CATALYSEUR', 2); // Élément transmutable en catalyseur

/*
 * Erreurs possibles
 */
define('OK', 0); // L’action a été exécutée avec succès
define('POSITION_INVALIDE', 1); // La position spécifiée n’est pas sur l’établi
define('PLACEMENT_INVALIDE', 2); // Les deux positions ne correspondent pas à des cases adjacentes
define('PLACEMENT_IMPOSSIBLE', 3); // Les cases ciblées ne sont pas vides
define('PLACEMENT_INCORRECT', 4); // Un des deux éléments de l'échantillon doit être placé adjacent à un élément du même type déjà présent sur l'établi
define('CASE_VIDE', 5); // La case ciblée est vide
define('ECHANTILLON_INCOMPLET', 6); // L’échantillon doit contenir deux éléments.
define('ECHANTILLON_INVALIDE', 7); // L’échantillon doit contenir au moins un des éléments de l’échantillon reçu auparavant
define('AUCUN_CATALYSEUR', 8); // Aucun catalyseur disponible
define('CATALYSE_INVALIDE', 9); // L'élément de destination ne peut pas être vide.
define('DEJA_POSE', 10); // L’échantillon a déjà été posé ce tour-ci
define('DEJA_DONNE', 11); // L’échantillon a déjà été donné ce tour-ci

/*
 * Types d’actions
 */
define('ACTION_PLACER', 0); // Action ``placer_echantillon``
define('ACTION_TRANSMUTER', 1); // Action ``transmuter``
define('ACTION_CATALYSER', 2); // Action ``catalyser``
define('ACTION_DONNER_ECHANTILLON', 3); // Action ``donner_echantillon``

?>
