"""
Recherche d'un chemin efficace pour déplacer nos PIB.
Le coût d'un déplacement suit un ordre lexicographique selon le couple
(tour, depenses) où tour correspond au nombre de tours qu'il faut, et
dépenses au points d'action utilisés [mod 8].
"""

#externes
from heapq import *
#internes
from Noeud import *
from api import *

def retrouve_chemin(noeud):
    if noeud.parent == None:
        return []
    else:
        chemin = retrouve_chemin(noeud.parent)
        chemin.append(noeud)
        return chemin

def plus_court_chemin(pos_depart, pos_arrivee):
    """
    Plus court chemin selon l'ordre susdecrit, entre (4)2 pts.
    """

    def dijkstra(pos_depart, pos_arrivee): #ne cree pas de liste de noeuds
        tas = []
        vu = [[0]*TAILLE_BANQUISE for i in range(TAILLE_BANQUISE)]
        heappush(tas, Noeud(pos_depart, None, (0,0)))
        while tas:
            noeud_cur = heappop(tas)
            x,y = noeud_cur.pos[0], noeud_cur.pos[1]
            if (x,y) == pos_arrivee:
                return noeud_cur
            if not vu[x][y]:
                vu[x][y] = 1
                voisins = noeud_cur.trouve_voisins()
                for voisin in voisins:
                    heappush(tas, voisin)
        return -1 #le noeud voulu se trouve dans une autre composante connexe

    parcours = dijkstra(pos_depart, pos_arrivee)
    if parcours != -1:
        return retrouve_chemin(parcours)

def plus_courts_chemins(pos_depart):
    """
    Plus court cheminS entre un noeud et tous les autres.
    (renvoie un tableau de Noeuds avec leur cout)
    """

    def dijkstra(pos_depart): #cree une liste de noeuds
        noeuds = [[None]*TAILLE_BANQUISE for i in range(TAILLE_BANQUISE)]
        tas = []
        vu = [[0]*TAILLE_BANQUISE for i in range(TAILLE_BANQUISE)]
        heappush(tas, Noeud(pos_depart, None, (0,0)))
        while tas:
            noeud_cur = heappop(tas)
            x,y = noeud_cur.pos[0], noeud_cur.pos[1]
            if not vu[x][y]:
                noeuds[x][y] = noeud_cur
                vu[x][y] = 1
                voisins = noeud_cur.trouve_voisins()
                for voisin in voisins:
                    heappush(tas, voisin)
        return noeuds #None si impossible, bon Noeud sinon

    return dijkstra(pos_depart)
