"""
Heuristiques et strategies pour optimiser la capture des aliens.
"""

from api import *

FORESIGHT_DEF = 5 #champ de vison (tours d'avance) (par défaut)
last_index = 0
tour_deb = 0

def update_aliens(derniers_aliens, lst_aliens, foresight=FORESIGHT_DEF):
    global last_index
    global tour_deb

    def range_aliens(lst_aliens, ind, tour_d, foresight):
        liste = []
        while ind < len(lst_aliens) and lst_aliens[ind].tour_invasion < tour_d:
            ind += 1
        while ind < len(lst_aliens) and lst_aliens[ind].tour_invasion <= tour_actuel()+foresight:
            liste.append(lst_aliens[ind])
            ind += 1
        tour_d = tour_actuel()+foresight
        return liste, ind, tour_d

    aliens_cur = []
    for alien in derniers_aliens:
        if (alien_sur_case(alien.pos) and alien.tour_invasion + alien.duree_invasion >= tour_actuel()+2)\
            or alien.tour_invasion >= tour_actuel():
            aliens_cur.append(alien)
    nouv_aliens, last_index, tour_deb = range_aliens(lst_aliens, last_index, tour_deb, foresight)
    aliens_cur += nouv_aliens
    return aliens_cur

def poids_alien(alien, noeud):
    #PARAMETRES
    c_va = 1
    c_di = 0.5
    c_du = 0.5
    c_sp = 0.5
    #---------
    valeur = alien.points_capture
    dist_tours = noeud.compa[0]
    if alien.tour_invasion > tour_actuel():
        dist_tours += alien.tour_invasion - tour_actuel()
    duree = alien.capture_en_cours
    sit_spec = situation_spec(alien)
    sp = 1 if sit_spec[0]==1 else 0

    poids = ((valeur*c_va)*(1+(duree*c_du))*(1+sp*c_sp))/(1+(dist_tours*c_di))
    return poids

def situation_spec(alien):
    """
    Dit comment défendre dans des situations locales spécifiques
    """
    x,y = alien.pos
    entourage = [0]*8
    if type_case((x-1, y)) != case_type.LIBRE:
        entourage[0] = 1
    if type_case((x-1, y+1)) != case_type.LIBRE:
        entourage[1] = 1
    if type_case((x, y+1)) != case_type.LIBRE:
        entourage[2] = 1
    if type_case((x+1, y+1)) != case_type.LIBRE:
        entourage[3] = 1
    if type_case((x+1, y)) != case_type.LIBRE:
        entourage[4] = 1
    if type_case((x+1, y-1)) != case_type.LIBRE:
        entourage[5] = 1
    if type_case((x, y-1)) != case_type.LIBRE:
        entourage[6] = 1
    if type_case((x-1, y-1)) != case_type.LIBRE:
        entourage[7] = 1
        #rotations
    entourage2 = [entourage[(x+2)%8] for x in range(8)]
    entourage3 = [entourage[(x+4)%8] for x in range(8)]
    entourage4 = [entourage[(x+6)%8] for x in range(8)]
    ents = [entourage, entourage2, entourage3, entourage4]
    #situations 1J (BEST)
    #1#
    for ent in ents:
        if ent[0]==1 and ent[2]==1 and ent[4]==0 and ent[6]==0:
            return 1, 2 #1J, access+
    #(4)2#
    for ent in ents:
        if ent[0]==1 and ent[2]==1 and ent[4]==1 and ent[6]==0:
            return 1, 1 #1J, access-
    #3#
    for i,ent in enumerate(ents):
        if ent[0]==1 and ent[1]==1 and ent[2]==0:
            if i==0:
                plac_x, plac_y = (0,1)
            elif i==1:
                plac_x, plac_y = (1,0)
            elif i==2:
                plac_x, plac_y = (0,-1)
            elif i==3:
                plac_x, plac_y = (-1,0)
            return 2, (plac_x, plac_y) #2J, placement
    #3.bis#
    for i,ent in enumerate(ents):
        if ent[0]==1 and ent[7]==1 and ent[6]==0:
            if i==0:
                plac_x, plac_y = (0,-1)
            elif i==1:
                plac_x, plac_y = (-1,0)
            elif i==2:
                plac_x, plac_y = (0,1)
            elif i==3:
                plac_x, plac_y = (1,0)
            return 2, (plac_x, plac_y) #2J, placement
    #4#
    for i,ent in enumerate(ents):
        if ent[0]==1 and (ent[3]==1 or ent[5]==0):
            if i==0:
                plac_x, plac_y = (1,0)
            elif i==1:
                plac_x, plac_y = (0,-1)
            elif i==2:
                plac_x, plac_y = (-1,0)
            elif i==3:
                plac_x, plac_y = (0,1)
            return 2, (plac_x, plac_y) #2J,  placmeent
    return (-1,-1) #pas de situation specifique

def find_empty_near(pos_x, pos_y):
    if type_case((pos_x,pos_y)) == case_type.LIBRE and agent_sur_case((pos_x,pos_y))==-1:
        return pos_x,pos_y
    else:
        for i in range(-2,3):
            for j in range(-2,3):
                if type_case((pos_x+i,pos_y+j)) == case_type.LIBRE and agent_sur_case((pos_x,pos_y))==-1:
                    return pos_x+i, pos_y+j
    return -1, -1
