"""
Implementation d'une classe noeud pour utiliser l'algorithme de Dijkstra
(sur un ordre modifie).
"""

from api import *

class Noeud:
    def __init__(self, pos, parent=None, compa=(0,0)):
        self.pos = pos
        self.parent = parent
        self.compa = compa

    def trouve_voisins(self):
        """
        Trouve les voisins d'un noeud, et les "prepare" (donne pos, parent, compa).
        """
        voisins = []
        directions = [(-1,0),(0,1),(1,0),(0,-1)]
        tour, points = self.compa
        for deplace in directions:
            new_pos = (self.pos[0]+deplace[0], self.pos[1]+deplace[1])
            if type_case(new_pos) == case_type.LIBRE and agent_sur_case(new_pos) == -1:
                (tour_sup, nouv_pts) = (1, COUT_DEPLACEMENT) if points+COUT_DEPLACEMENT > NB_POINTS_ACTION else (0, points+COUT_DEPLACEMENT)
                voisins.append(Noeud(new_pos, self, (tour+tour_sup, nouv_pts)))
        for glisse in directions:
            compt = 1
            new_pos = (self.pos[0]+compt*glisse[0], self.pos[1]+compt*glisse[1])
            while type_case(new_pos) == case_type.LIBRE and agent_sur_case(new_pos) == -1:
                compt += 1
                new_pos = (self.pos[0]+compt*glisse[0], self.pos[1]+compt*glisse[1])
            new_pos = (new_pos[0]-glisse[0], new_pos[1]-glisse[1])
            if new_pos != self.pos:
                (tour_sup, nouv_pts) = (1, COUT_GLISSADE) if points+COUT_GLISSADE > NB_POINTS_ACTION else (0, points+COUT_GLISSADE)
                voisins.append(Noeud(new_pos, self, (tour+tour_sup, nouv_pts)))
        return voisins

    def retrouve_mvt_dir(self, other):
        if self.pos[0]-other.pos[0] == 1:
            return action_type.ACTION_DEPLACER, direction.NORD
        elif self.pos[0]-other.pos[0] == -1:
            return action_type.ACTION_DEPLACER, direction.SUD
        elif self.pos[1]-other.pos[1] == -1:
            return action_type.ACTION_DEPLACER, direction.EST
        elif self.pos[1]-other.pos[1] == 1:
            return action_type.ACTION_DEPLACER, direction.OUEST
        elif self.pos[0]-other.pos[0] > 1:
            return action_type.ACTION_GLISSER, direction.NORD
        elif self.pos[0]-other.pos[0] < -1:
            return action_type.ACTION_GLISSER, direction.SUD
        elif self.pos[1]-other.pos[1] < -1:
            return action_type.ACTION_GLISSER, direction.EST
        elif self.pos[1]-other.pos[1] > 1:
            return action_type.ACTION_GLISSER, direction.OUEST

    def __lt__(self, other):
        if self.compa[0] < other.compa[0]:
            return True
        elif self.compa[0] == other.compa[0]:
            if self.compa[1] < other.compa[1]:
                return True
            else:
                return False
        else:
            return False

    def __le__(self, other):
        if self.compa[0] < other.compa[0]:
            return True
        elif self.compa[0] == other.compa[0]:
            if self.compa[1] < other.compa[1]:
                return True
            elif self.compa[1] == other.compa[1]:
                return True
            else:
                return False
        else:
            return False
