"""
Singleton qui centralise la gestion de nos stupides manchots.
"""

from api import *
from dijkstra import *
from Noeud import *
from aliens import *

from enum import IntEnum
class role(IntEnum):
    CAPTURE = 0  #chasse un alien
    DEFENSE = 1  #défend un alien
    ATTAQUE = 2  #attaque un ennemi


class ControleurPIB:

    def __init__(self, agent_A, agent_B, agent_C, agent_D):
        self.liste_agents = [agent_A, agent_B, agent_C, agent_D]

    def update_roles(self):
        self.liste_agents.sort(key=lambda agent: agent.poids_attrib)
        for agent in self.liste_agents:
            agent.role = role.CAPTURE
        if self.liste_agents[3].alien_attrib is not None:
            sit_spec3 = situation_spec(self.liste_agents[3].alien_attrib)
            if sit_spec3[0]!=1:
                if self.liste_agents[0].poids_attrib < self.liste_agents[3].poids_attrib/2:
                    self.liste_agents[0].role = role.DEFENSE
                    self.liste_agents[0].alien_attrib = self.liste_agents[3].alien_attrib
        if self.liste_agents[2].alien_attrib is not None:
            sit_spec2 = situation_spec(self.liste_agents[2].alien_attrib)
            if sit_spec2[0]!=1:
                if self.liste_agents[1].poids_attrib < self.liste_agents[2].poids_attrib/2:
                    self.liste_agents[1].role = role.DEFENSE
                    self.liste_agents[1].alien_attrib = self.liste_agents[2].alien_attrib
        if self.liste_agents[1].role == role.CAPTURE and\
            self.liste_agents[1].poids_attrib < self.liste_agents[3].poids_attrib/2:
            self.liste_agents[1].role = role.ATTAQUE
        for agent in self.liste_agents:
            if agent.alien_attrib is None and agent.role == role.CAPTURE:
                agent.role = role.ATTAQUE

    def affecte_aliens(self, aliens_tour):
        aliens_pris = []
        for agent in self.liste_agents:
            agent.pos = position_agent(moi(), agent.id)
            chemins = plus_courts_chemins(agent.pos)
            alien_max, poids_max = None, 0
            for alien in aliens_tour:
                if chemins[alien.pos[0]][alien.pos[1]] is None: #alien occupé/inacessible
                    poids = 0
                else:
                    poids = poids_alien(alien, chemins[alien.pos[0]][alien.pos[1]])
                if poids > poids_max and alien not in aliens_pris:
                    poids_max = poids
                    alien_max = alien
            aliens_pris.append(alien_max)
            agent.alien_attrib = alien_max
            agent.poids_attrib = poids_max
