"""
Classe pour décrire nos PIB.
Un objet par PIB, donc 4(2).
Gestion par le ControleurPIB.
"""

from api import *
from ControleurPIB import *
from dijkstra import *
from Noeud import *
from aliens import *

class AgentPIB:

    def __init__(self, id, role, alien_attrib=None, poids_attrib=0): #changer le None ?
        """
        role de type 'role' (cf. ControleurPIB)
        alien_attrib de type 'alien_info' (creer classe alien plus tard ?)
        """
        self.id = id
        self.role = role
        self.alien_attrib = alien_attrib
        self.poids_attrib = poids_attrib
        self.pos = position_agent(moi(), id)

    def run(self):
        self.pos = position_agent(moi(), self.id) #peut être supprimé...

        if self.role == role.CAPTURE:
            """
            Mode CAPTURE
            """
            if self.pos == self.alien_attrib.pos: #on est où on veut :)
                return
            chemin = plus_court_chemin(self.pos, self.alien_attrib.pos)
            mvt, dir = Noeud(self.pos).retrouve_mvt_dir(chemin[0])
            if mvt == action_type.ACTION_DEPLACER:
                deplacer(self.id, dir)
            elif mvt == action_type.ACTION_GLISSER:
                glisser(self.id, dir)
            i_noeud = 0
            while i_noeud < len(chemin)-1 and points_action_agent(self.id)>0:
                mvt, dir = chemin[i_noeud].retrouve_mvt_dir(chemin[i_noeud+1])
                if mvt == action_type.ACTION_DEPLACER:
                    deplacer(self.id, dir)
                elif mvt == action_type.ACTION_GLISSER:
                    glisser(self.id, dir)
                i_noeud += 1

        elif self.role == role.DEFENSE:
            """
            Mode DEFENSE
            """
            sp = situation_spec(self.alien_attrib)
            if sp[0]==2:
                dest_x,dest_y = sp[1]
            elif sp[0]==-1:
                dest_x,dest_y = self.alien_attrib.pos
            aller_x,aller_y = find_empty_near(dest_x,dest_y)
            if (aller_x,aller_y) == (-1,-1):
                return

            chemin = plus_court_chemin(self.pos, (aller_x,aller_y))
            mvt, dir = Noeud(self.pos).retrouve_mvt_dir(chemin[0])
            if mvt == action_type.ACTION_DEPLACER:
                deplacer(self.id, dir)
            elif mvt == action_type.ACTION_GLISSER:
                glisser(self.id, dir)
            i_noeud = 0
            while i_noeud < len(chemin)-1 and points_action_agent(self.id)>0:
                mvt, dir = chemin[i_noeud].retrouve_mvt_dir(chemin[i_noeud+1])
                if mvt == action_type.ACTION_DEPLACER:
                    deplacer(self.id, dir)
                elif mvt == action_type.ACTION_GLISSER:
                    glisser(self.id, dir)
                i_noeud += 1

        else: #ATTAQUE
            """
            Mode ATTAQUE
            """
            pos_advers = []
            for i_agent in range(4):
                pos_advers.append(position_agent(adversaire(),i_agent))
            pts_max, best_adv = 0, pos_advers[0]
            for advers in pos_advers:
                if alien_sur_case(advers):
                    if info_alien(advers).points_capture > pts_max:
                        pts_max = info_alien(advers).points_capture
                        best_adv = advers
            aller_x,aller_y = find_empty_near(best_adv[0],best_adv[1])
            if (aller_x,aller_y) == (-1,-1):
                return

            chemin = plus_court_chemin(self.pos, (aller_x,aller_y))
            mvt, dir = Noeud(self.pos).retrouve_mvt_dir(chemin[0])
            if mvt == action_type.ACTION_DEPLACER:
                deplacer(self.id, dir)
            elif mvt == action_type.ACTION_GLISSER:
                glisser(self.id, dir)
            i_noeud = 0
            while i_noeud < len(chemin)-1 and points_action_agent(self.id)>0:
                mvt, dir = chemin[i_noeud].retrouve_mvt_dir(chemin[i_noeud+1])
                if mvt == action_type.ACTION_DEPLACER:
                    deplacer(self.id, dir)
                elif mvt == action_type.ACTION_GLISSER:
                    glisser(self.id, dir)
                i_noeud += 1



    def pousse_naif(self):
        if points_action_agent(self.id) >= 5:
            x,y = self.pos
            if agent_sur_case((x,y+1))==adversaire():
                pousser(self.id, direction.EST)
            if agent_sur_case((x+1,y))==adversaire():
                pousser(self.id, direction.SUD)
            if agent_sur_case((x,y-1))==adversaire():
                pousser(self.id, direction.OUEST)
            if agent_sur_case((x-1,y))==adversaire():
                pousser(self.id, direction.NORD)
