<?php
/*
 * Taille de la banquise (longueur et largeur).
 */
define('TAILLE_BANQUISE', 25);

/*
 * Nombre de tours à jouer avant la fin de la partie.
 */
define('NB_TOURS', 100);

/*
 * Nombre de points d'action par tour par agent.
 */
define('NB_POINTS_ACTION', 8);

/*
 * Nombre de point d'action que coûte un déplacement.
 */
define('COUT_DEPLACEMENT', 1);

/*
 * Nombre de points d'action que coûte une glissade.
 */
define('COUT_GLISSADE', 3);

/*
 * Nombre de points d'action nécessaires pour pousser un agent.
 */
define('COUT_POUSSER', 5);

/*
 * Nombre d'agents par joueur.
 */
define('NB_AGENTS', 4);

/*
 * Nombre de tours nécessaires pour capturer un alien.
 */
define('NB_TOURS_CAPTURE', 3);

/*
 * Types de cases
 */
define('LIBRE', 0); // Case libre
define('MUR', 1); // Mur
define('ERREUR', 2); // Erreur

/*
 * Points cardinaux
 */
define('NORD', 0); // Direction : nord
define('EST', 1); // Direction : est
define('SUD', 2); // Direction : sud
define('OUEST', 3); // Direction : ouest

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action s'est effectuée avec succès.
define('PA_INSUFFISANTS', 1); // Votre agent ne possède pas assez de points d'action pour réaliser cette action.
define('POSITION_INVALIDE', 2); // La position spécifiée n'est pas sur la banquise.
define('OBSTACLE_MUR', 3); // La position spécifiée est un mur.
define('OBSTACLE_AGENT', 4); // La position spécifiée est un agent.
define('DEPLACEMENT_HORS_LIMITES', 5); // Ce déplacement fait sortir un agent des limites de la banquise.
define('DIRECTION_INVALIDE', 6); // La direction spécifiée n'existe pas.
define('ID_AGENT_INVALIDE', 7); // L'agent spécifié n'existe pas.
define('RIEN_A_POUSSER', 8); // Aucun agent à pousser dans la direction indiquée.
define('DRAPEAU_INVALIDE', 9); // Le drapeau spécifié n'existe pas.

/*
 * Types d'actions
 */
define('ACTION_DEPLACER', 0); // Action ``deplacer``
define('ACTION_GLISSER', 1); // Action ``glisser``
define('ACTION_POUSSER', 2); // Action ``pousser``

/*
 * Types de drapeaux de débug
 */
define('AUCUN_DRAPEAU', 0); // Aucun drapeau, enlève le drapeau présent
define('DRAPEAU_BLEU', 1); // Drapeau bleu
define('DRAPEAU_VERT', 2); // Drapeau vert
define('DRAPEAU_ROUGE', 3); // Drapeau rouge

?>
