// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Types de cases
enum CaseType {
  LIBRE, // <- Case libre
  MUR, // <- Mur
  ERREUR, // <- Erreur
}

// Points cardinaux
enum Direction {
  NORD, // <- Direction : nord
  EST, // <- Direction : est
  SUD, // <- Direction : sud
  OUEST, // <- Direction : ouest
}

// Erreurs possibles
enum Erreur {
  OK, // <- L'action s'est effectuée avec succès.
  PA_INSUFFISANTS, // <- Votre agent ne possède pas assez de points d'action pour réaliser cette action.
  POSITION_INVALIDE, // <- La position spécifiée n'est pas sur la banquise.
  OBSTACLE_MUR, // <- La position spécifiée est un mur.
  OBSTACLE_AGENT, // <- La position spécifiée est un agent.
  DEPLACEMENT_HORS_LIMITES, // <- Ce déplacement fait sortir un agent des limites de la banquise.
  DIRECTION_INVALIDE, // <- La direction spécifiée n'existe pas.
  ID_AGENT_INVALIDE, // <- L'agent spécifié n'existe pas.
  RIEN_A_POUSSER, // <- Aucun agent à pousser dans la direction indiquée.
  DRAPEAU_INVALIDE, // <- Le drapeau spécifié n'existe pas.
}

// Types d'actions
enum ActionType {
  ACTION_DEPLACER, // <- Action ``deplacer``
  ACTION_GLISSER, // <- Action ``glisser``
  ACTION_POUSSER, // <- Action ``pousser``
}

// Types de drapeaux de débug
enum DebugDrapeau {
  AUCUN_DRAPEAU, // <- Aucun drapeau, enlève le drapeau présent
  DRAPEAU_BLEU, // <- Drapeau bleu
  DRAPEAU_VERT, // <- Drapeau vert
  DRAPEAU_ROUGE, // <- Drapeau rouge
}

// Position sur la banquise, donnée par deux coordonnées.
class Position {
  public int ligne; // Coordonnée : ligne
  public int colonne; // Coordonnée : colonne
}

// Alien à capturer durant la mission.
class AlienInfo {
  public Position pos = new Position(); // Position de l'alien
  public int points_capture; // Nombre de points obtenus pour la capture de cet alien
  public int tour_invasion; // Tour où l'alien débarque sur la banquise
  public int duree_invasion; // Nombre de tours où l'alien reste sur la banquise
  public int capture_en_cours; // Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE
}

// Action de déplacement représentée dans l'historique.
class ActionHist {
  public ActionType atype; // Type de l'action
  public int id_agent; // Numéro de l'agent concerné par l'action
  public Direction dir; // Direction visée par l'agent durant le déplacement
}

public class Interface
{
  // Taille de la banquise (longueur et largeur).
  public static final int TAILLE_BANQUISE = 25;

  // Nombre de tours à jouer avant la fin de la partie.
  public static final int NB_TOURS = 100;

  // Nombre de points d'action par tour par agent.
  public static final int NB_POINTS_ACTION = 8;

  // Nombre de point d'action que coûte un déplacement.
  public static final int COUT_DEPLACEMENT = 1;

  // Nombre de points d'action que coûte une glissade.
  public static final int COUT_GLISSADE = 3;

  // Nombre de points d'action nécessaires pour pousser un agent.
  public static final int COUT_POUSSER = 5;

  // Nombre d'agents par joueur.
  public static final int NB_AGENTS = 4;

  // Nombre de tours nécessaires pour capturer un alien.
  public static final int NB_TOURS_CAPTURE = 3;

// Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
  public static native Erreur deplacer(int id_agent, Direction dir);

// Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
  public static native Erreur glisser(int id_agent, Direction dir);

// L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
  public static native Erreur pousser(int id_agent, Direction dir);

// Affiche le drapeau spécifié sur la case indiquée.
  public static native Erreur debug_afficher_drapeau(Position pos, DebugDrapeau drapeau);

// Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
  public static native int points_action_agent(int id_agent);

// Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
  public static native Direction[] chemin(Position pos1, Position pos2);

// Renvoie le type d'une case donnée.
  public static native CaseType type_case(Position pos);

// Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
  public static native int agent_sur_case(Position pos);

// Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
  public static native boolean alien_sur_case(Position pos);

// Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
  public static native Position position_agent(int id_joueur, int id_agent);

// Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
  public static native AlienInfo info_alien(Position pos);

// Renvoie la liste de tous les aliens présents durant la partie.
  public static native AlienInfo[] liste_aliens();

// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
  public static native ActionHist[] historique();

// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
  public static native int score(int id_joueur);

// Renvoie votre numéro de joueur.
  public static native int moi();

// Renvoie le numéro de joueur de votre adversaire.
  public static native int adversaire();

// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
  public static native boolean annuler();

// Retourne le numéro du tour actuel.
  public static native int tour_actuel();

// Affiche le contenu d'une valeur de type case_type
  public static native void afficher_case_type(CaseType v);

// Affiche le contenu d'une valeur de type direction
  public static native void afficher_direction(Direction v);

// Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

// Affiche le contenu d'une valeur de type action_type
  public static native void afficher_action_type(ActionType v);

// Affiche le contenu d'une valeur de type debug_drapeau
  public static native void afficher_debug_drapeau(DebugDrapeau v);

// Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

// Affiche le contenu d'une valeur de type alien_info
  public static native void afficher_alien_info(AlienInfo v);

// Affiche le contenu d'une valeur de type action_hist
  public static native void afficher_action_hist(ActionHist v);

}
