#include "utils.hh"

const int _NERR = 20;
std::string ERR_STR[_NERR];

void partie_init()
{
    for(int i = 0; i < _NERR; i++)
        ERR_STR[i] = "inconnu !!";
    ERR_STR[OK] = "OK";
    ERR_STR[PA_INSUFFISANTS] = "PA_INSUFFISANTS";
    ERR_STR[PM_INSUFFISANTS] = "PM_INSUFFISANTS";
    ERR_STR[HORS_LIMITES] = "HORS_LIMITES";
    ERR_STR[DIRECTION_INVALIDE] = "DIRECTION_INVALIDE";
    ERR_STR[ID_NAIN_INVALIDE] = "ID_NAIN_INVALIDE";
    ERR_STR[OBSTACLE_MUR] = "OBSTACLE_MUR";
    ERR_STR[OBSTACLE_NAIN] = "OBSTACLE_NAIN";
    ERR_STR[OBSTACLE_CORDE] = "OBSTACLE_CORDE";
    ERR_STR[PAS_DE_CIBLE] = "PAS_DE_CIBLE";
    ERR_STR[NAIN_MORT] = "NAIN_MORT";
    ERR_STR[PAS_ACCROCHE] = "PAS_ACCROCHE";
    ERR_STR[DEJA_ACCROCHE] = "DEJA_ACCROCHE";
    ERR_STR[PAS_DE_CORDE] = "PAS_DE_CORDE";
    ERR_STR[DRAPEAU_INVALIDE] = "DRAPEAU_INVALIDE";
}

bool peutl(position pos)
{
    pos.ligne++;
    if(type_case(pos) == GRANITE || type_case(pos) == OBSIDIENNE)
        return true;

    return false;
}

void jouer_tour()
{
    printf("\nTOUR %d\n", tour_actuel());

    for(int idxnain = 0; idxnain < NB_NAINS; idxnain++)
    {
        agripper(idxnain);
        nain inain = info_nain(moi(), idxnain);

        if(inain.butin < 17)
        {
            position pmax;
            std::vector<direction> vmax;
            double lmax = -1000000;
            for(auto ipos : liste_minerais())
            {
                auto iv  = chemin(inain.pos, ipos);
                double ilg = ((double) std::min(BUTIN_MAX, info_minerai(ipos).rendement)) /(iv.size() + info_minerai(ipos).resistance);
                if(ilg > lmax)
                {
                    lmax = ilg;
                    pmax = ipos;
                    vmax = iv;
                }
            }


            for(auto idir : vmax)
            {
                printf("%d\n", idir);
                inain = info_nain(moi(), idxnain);
                if(peutl(inain.pos))
                    lacher(idxnain);
                if(deplacer(idxnain, idir) != OK)
                {
                    miner(idxnain, idir);
                    deplacer(idxnain,idir);
                }
            }
        }
        else
        {

            for(auto idir : chemin(inain.pos, position_taverne(moi())))
            {
                inain = info_nain(moi(), idxnain);
                if(peutl(inain.pos))
                    lacher(idxnain);
                if(deplacer(idxnain, idir) != OK)
                {
                    miner(idxnain, idir);
                    deplacer(idxnain,idir);
                }
            }

        }


    }
}

void partie_fin()
{
}

