/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_c.rb

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

/// Position dans la mine, donnée par deux coordonnées.
typedef struct __internal__cxx__position {
  int ligne;
  int colonne;
} __internal__cxx__position;

/// Minerai à récolter
typedef struct __internal__cxx__minerai {
  int resistance;
  int rendement;
} __internal__cxx__minerai;

/// Nain (standard)
typedef struct __internal__cxx__nain {
  __internal__cxx__position pos;
  int vie;
  int pa;
  int pm;
  bool accroche;
  int butin;
} __internal__cxx__nain;

/// Action de déplacement représentée dans l'historique.
typedef struct __internal__cxx__action_hist {
  action_type atype;
  int id_nain;
  direction dir;
  direction sens;
} __internal__cxx__action_hist;

/// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
extern "C" std::vector<direction> api_chemin(__internal__cxx__position pos1, __internal__cxx__position pos2);

/// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
extern "C" erreur api_deplacer(int id_nain, direction dir);

/// Le nain (standard) ``id_nain`` lâche la paroi.
extern "C" erreur api_lacher(int id_nain);

/// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
extern "C" erreur api_agripper(int id_nain);

/// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
extern "C" erreur api_miner(int id_nain, direction dir);

/// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
extern "C" erreur api_tirer(int id_nain, direction dir_corde, direction sens);

/// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
extern "C" erreur api_poser_corde(int id_nain, direction dir);

/// Affiche le drapeau spécifié sur la case indiquée.
extern "C" erreur api_debug_afficher_drapeau(__internal__cxx__position pos, debug_drapeau drapeau);

/// Renvoie le type d'une case donnée.
extern "C" case_type api_type_case(__internal__cxx__position pos);

/// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
extern "C" std::vector<__internal__cxx__position> api_liste_cordes(void);

/// Indique si une corde se trouve sur une case donnée.
extern "C" bool api_corde_sur_case(__internal__cxx__position pos);

/// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
extern "C" int api_nain_sur_case(__internal__cxx__position pos);

/// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
extern "C" __internal__cxx__nain api_info_nain(int id_joueur, int id_nain);

/// Renvoie la liste de tous les minerais dans la mine.
extern "C" std::vector<__internal__cxx__position> api_liste_minerais(void);

/// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
extern "C" __internal__cxx__minerai api_info_minerai(__internal__cxx__position pos);

/// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
extern "C" int api_cout_de_deplacement(int id_nain, direction dir);

/// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
extern "C" __internal__cxx__position api_position_taverne(int id_joueur);

/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
extern "C" std::vector<__internal__cxx__action_hist> api_historique(void);

/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
extern "C" int api_score(int id_joueur);

/// Renvoie votre numéro de joueur.
extern "C" int api_moi(void);

/// Renvoie le numéro de joueur de votre adversaire.
extern "C" int api_adversaire(void);

/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
extern "C" bool api_annuler(void);

/// Retourne le numéro du tour actuel.
extern "C" int api_tour_actuel(void);

/// Affiche le contenu d'une valeur de type case_type
extern "C" void api_afficher_case_type(case_type v);

/// Affiche le contenu d'une valeur de type direction
extern "C" void api_afficher_direction(direction v);

/// Affiche le contenu d'une valeur de type erreur
extern "C" void api_afficher_erreur(erreur v);

/// Affiche le contenu d'une valeur de type action_type
extern "C" void api_afficher_action_type(action_type v);

/// Affiche le contenu d'une valeur de type debug_drapeau
extern "C" void api_afficher_debug_drapeau(debug_drapeau v);

/// Affiche le contenu d'une valeur de type position
extern "C" void api_afficher_position(__internal__cxx__position v);

/// Affiche le contenu d'une valeur de type minerai
extern "C" void api_afficher_minerai(__internal__cxx__minerai v);

/// Affiche le contenu d'une valeur de type nain
extern "C" void api_afficher_nain(__internal__cxx__nain v);

/// Affiche le contenu d'une valeur de type action_hist
extern "C" void api_afficher_action_hist(__internal__cxx__action_hist v);

#endif
