//#include "utils.hh"
#include "prologin.hh"
using namespace std;
enum e_strategie { STRATEGIE_RETOUR, STRATEGIE_ATTAQUE, STRATEGIE_MINE };

e_strategie strategie[NB_NAINS];
int att_cible[NB_NAINS];

void st_retour(int idnain)
{
    agripper(idnain);

    vector<direction> dirs = chemin(info_nain(moi(), idnain).pos,
                                    position_taverne(moi()));

    for(int i = 0; i < dirs.size(); i++)
        deplacer(idnain, dirs[i]);

    if(info_nain(moi(), idnain).pos == position_taverne(moi()))
        strategie[idnain] = STRATEGIE_ATTAQUE, att_cible[idnain] = rand() % NB_NAINS;
}

void st_attaque(int idnain)
{
    debug_afficher_drapeau(info_nain(adversaire(), att_cible[idnain]).pos, DRAPEAU_ROUGE);

    agripper(idnain);

    vector<direction> dirs = chemin(info_nain(moi(), idnain).pos,
                                    info_nain(adversaire(), att_cible[idnain]).pos);

    bool fin_chemin = (dirs.size() >= 1);

    for(int i = 0; i+1 < dirs.size(); i++)
        if(deplacer(idnain, dirs[i]) != OK)
            fin_chemin = false;

    if(fin_chemin)
        miner(idnain, dirs[dirs.size() - 1]);

    if(info_nain(adversaire(), att_cible[idnain]).vie == -1)
    {
        if(info_nain(moi(), idnain).butin >= 5)
            strategie[idnain] = STRATEGIE_RETOUR;
        else
            att_cible[idnain] = rand() % NB_NAINS;
    }

}

void partie_init()
{
    puts("DEBUT TOUR");
    debug_afficher_drapeau(position_taverne(moi()), DRAPEAU_BLEU);
    for(int i = 0; i < NB_NAINS; i++)
        strategie[i] = STRATEGIE_ATTAQUE, att_cible[i] = rand() % NB_NAINS;
}

void jouer_tour()
{
    for(int i = 0; i < NB_NAINS; i++)
        if(strategie[i] == STRATEGIE_RETOUR)
            st_retour(i);
        else
        {
            st_attaque(i);
        }
}

void partie_fin()
{
    printf("%d %d %d %d\n", HAUT, BAS, DROITE, GAUCHE);
}

